# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiKeyResult',
    'AwaitableGetApiKeyResult',
    'get_api_key',
    'get_api_key_output',
]

@pulumi.output_type
class GetApiKeyResult:
    """
    A collection of values returned by getApiKey.
    """
    def __init__(__self__, account_id=None, apikey_type=None, default_time_to_expire_token=None, description=None, id=None, identifier=None, name=None, org_id=None, parent_id=None, project_id=None, tags=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if apikey_type and not isinstance(apikey_type, str):
            raise TypeError("Expected argument 'apikey_type' to be a str")
        pulumi.set(__self__, "apikey_type", apikey_type)
        if default_time_to_expire_token and not isinstance(default_time_to_expire_token, int):
            raise TypeError("Expected argument 'default_time_to_expire_token' to be a int")
        pulumi.set(__self__, "default_time_to_expire_token", default_time_to_expire_token)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> builtins.str:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @property
    @pulumi.getter(name="defaultTimeToExpireToken")
    def default_time_to_expire_token(self) -> Optional[builtins.int]:
        """
        Default expiration time of the Token within API Key
        """
        return pulumi.get(self, "default_time_to_expire_token")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> builtins.str:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApiKeyResult(GetApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyResult(
            account_id=self.account_id,
            apikey_type=self.apikey_type,
            default_time_to_expire_token=self.default_time_to_expire_token,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            parent_id=self.parent_id,
            project_id=self.project_id,
            tags=self.tags)


def get_api_key(account_id: Optional[builtins.str] = None,
                apikey_type: Optional[builtins.str] = None,
                default_time_to_expire_token: Optional[builtins.int] = None,
                identifier: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                org_id: Optional[builtins.str] = None,
                parent_id: Optional[builtins.str] = None,
                project_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyResult:
    """
    Use this data source to retrieve information about a Harness API Key. API Keys are used to authenticate and authorize access to Harness Platform resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_api_key(identifier="test_apikey",
        name="test_apikey",
        parent_id="parent_id",
        apikey_type="USER",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param builtins.str account_id: Account Identifier for the Entity
    :param builtins.str apikey_type: Type of the API Key
    :param builtins.int default_time_to_expire_token: Default expiration time of the Token within API Key
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str parent_id: Parent Entity Identifier of the API Key
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['apikeyType'] = apikey_type
    __args__['defaultTimeToExpireToken'] = default_time_to_expire_token
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['parentId'] = parent_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getApiKey:getApiKey', __args__, opts=opts, typ=GetApiKeyResult).value

    return AwaitableGetApiKeyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        apikey_type=pulumi.get(__ret__, 'apikey_type'),
        default_time_to_expire_token=pulumi.get(__ret__, 'default_time_to_expire_token'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_api_key_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                       apikey_type: Optional[pulumi.Input[builtins.str]] = None,
                       default_time_to_expire_token: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                       identifier: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       parent_id: Optional[pulumi.Input[builtins.str]] = None,
                       project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiKeyResult]:
    """
    Use this data source to retrieve information about a Harness API Key. API Keys are used to authenticate and authorize access to Harness Platform resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_api_key(identifier="test_apikey",
        name="test_apikey",
        parent_id="parent_id",
        apikey_type="USER",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param builtins.str account_id: Account Identifier for the Entity
    :param builtins.str apikey_type: Type of the API Key
    :param builtins.int default_time_to_expire_token: Default expiration time of the Token within API Key
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str parent_id: Parent Entity Identifier of the API Key
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['apikeyType'] = apikey_type
    __args__['defaultTimeToExpireToken'] = default_time_to_expire_token
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['parentId'] = parent_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getApiKey:getApiKey', __args__, opts=opts, typ=GetApiKeyResult)
    return __ret__.apply(lambda __response__: GetApiKeyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        apikey_type=pulumi.get(__response__, 'apikey_type'),
        default_time_to_expire_token=pulumi.get(__response__, 'default_time_to_expire_token'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
