# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCentralNotificationChannelResult',
    'AwaitableGetCentralNotificationChannelResult',
    'get_central_notification_channel',
    'get_central_notification_channel_output',
]

@pulumi.output_type
class GetCentralNotificationChannelResult:
    """
    A collection of values returned by getCentralNotificationChannel.
    """
    def __init__(__self__, account=None, channels=None, created=None, id=None, identifier=None, last_modified=None, name=None, notification_channel_type=None, org=None, project=None, status=None):
        if account and not isinstance(account, str):
            raise TypeError("Expected argument 'account' to be a str")
        pulumi.set(__self__, "account", account)
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if created and not isinstance(created, int):
            raise TypeError("Expected argument 'created' to be a int")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_modified and not isinstance(last_modified, int):
            raise TypeError("Expected argument 'last_modified' to be a int")
        pulumi.set(__self__, "last_modified", last_modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_channel_type and not isinstance(notification_channel_type, str):
            raise TypeError("Expected argument 'notification_channel_type' to be a str")
        pulumi.set(__self__, "notification_channel_type", notification_channel_type)
        if org and not isinstance(org, str):
            raise TypeError("Expected argument 'org' to be a str")
        pulumi.set(__self__, "org", org)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def account(self) -> Optional[builtins.str]:
        """
        Account identifier associated with this notification channel.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter
    def channels(self) -> Optional[Sequence['outputs.GetCentralNotificationChannelChannelResult']]:
        """
        Configuration details of the notification channel.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def created(self) -> Optional[builtins.int]:
        """
        Timestamp when the notification channel was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the notification channel.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[builtins.int]:
        """
        Timestamp when the notification channel was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the notification channel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationChannelType")
    def notification_channel_type(self) -> Optional[builtins.str]:
        """
        Type of notification channel. One of: EMAIL, SLACK, PAGERDUTY, MSTeams, WEBHOOK, DATADOG.
        """
        return pulumi.get(self, "notification_channel_type")

    @property
    @pulumi.getter
    def org(self) -> Optional[builtins.str]:
        """
        Identifier of the organization the notification channel is scoped to.
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        Identifier of the project the notification channel is scoped to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the notification channel. Possible values are ENABLED or DISABLED.
        """
        return pulumi.get(self, "status")


class AwaitableGetCentralNotificationChannelResult(GetCentralNotificationChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCentralNotificationChannelResult(
            account=self.account,
            channels=self.channels,
            created=self.created,
            id=self.id,
            identifier=self.identifier,
            last_modified=self.last_modified,
            name=self.name,
            notification_channel_type=self.notification_channel_type,
            org=self.org,
            project=self.project,
            status=self.status)


def get_central_notification_channel(account: Optional[builtins.str] = None,
                                     channels: Optional[Sequence[Union['GetCentralNotificationChannelChannelArgs', 'GetCentralNotificationChannelChannelArgsDict']]] = None,
                                     created: Optional[builtins.int] = None,
                                     identifier: Optional[builtins.str] = None,
                                     last_modified: Optional[builtins.int] = None,
                                     name: Optional[builtins.str] = None,
                                     notification_channel_type: Optional[builtins.str] = None,
                                     org: Optional[builtins.str] = None,
                                     project: Optional[builtins.str] = None,
                                     status: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCentralNotificationChannelResult:
    """
    Data source for retrieving a central notification channel in Harness.


    :param builtins.str account: Account identifier associated with this notification channel.
    :param Sequence[Union['GetCentralNotificationChannelChannelArgs', 'GetCentralNotificationChannelChannelArgsDict']] channels: Configuration details of the notification channel.
    :param builtins.int created: Timestamp when the notification channel was created.
    :param builtins.str identifier: Unique identifier of the notification channel.
    :param builtins.int last_modified: Timestamp when the notification channel was last modified.
    :param builtins.str name: Name of the notification channel.
    :param builtins.str notification_channel_type: Type of notification channel. One of: EMAIL, SLACK, PAGERDUTY, MSTeams, WEBHOOK, DATADOG.
    :param builtins.str org: Identifier of the organization the notification channel is scoped to.
    :param builtins.str project: Identifier of the project the notification channel is scoped to.
    :param builtins.str status: Status of the notification channel. Possible values are ENABLED or DISABLED.
    """
    __args__ = dict()
    __args__['account'] = account
    __args__['channels'] = channels
    __args__['created'] = created
    __args__['identifier'] = identifier
    __args__['lastModified'] = last_modified
    __args__['name'] = name
    __args__['notificationChannelType'] = notification_channel_type
    __args__['org'] = org
    __args__['project'] = project
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getCentralNotificationChannel:getCentralNotificationChannel', __args__, opts=opts, typ=GetCentralNotificationChannelResult).value

    return AwaitableGetCentralNotificationChannelResult(
        account=pulumi.get(__ret__, 'account'),
        channels=pulumi.get(__ret__, 'channels'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        name=pulumi.get(__ret__, 'name'),
        notification_channel_type=pulumi.get(__ret__, 'notification_channel_type'),
        org=pulumi.get(__ret__, 'org'),
        project=pulumi.get(__ret__, 'project'),
        status=pulumi.get(__ret__, 'status'))
def get_central_notification_channel_output(account: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            channels: Optional[pulumi.Input[Optional[Sequence[Union['GetCentralNotificationChannelChannelArgs', 'GetCentralNotificationChannelChannelArgsDict']]]]] = None,
                                            created: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                            identifier: Optional[pulumi.Input[builtins.str]] = None,
                                            last_modified: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                            name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            notification_channel_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            org: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCentralNotificationChannelResult]:
    """
    Data source for retrieving a central notification channel in Harness.


    :param builtins.str account: Account identifier associated with this notification channel.
    :param Sequence[Union['GetCentralNotificationChannelChannelArgs', 'GetCentralNotificationChannelChannelArgsDict']] channels: Configuration details of the notification channel.
    :param builtins.int created: Timestamp when the notification channel was created.
    :param builtins.str identifier: Unique identifier of the notification channel.
    :param builtins.int last_modified: Timestamp when the notification channel was last modified.
    :param builtins.str name: Name of the notification channel.
    :param builtins.str notification_channel_type: Type of notification channel. One of: EMAIL, SLACK, PAGERDUTY, MSTeams, WEBHOOK, DATADOG.
    :param builtins.str org: Identifier of the organization the notification channel is scoped to.
    :param builtins.str project: Identifier of the project the notification channel is scoped to.
    :param builtins.str status: Status of the notification channel. Possible values are ENABLED or DISABLED.
    """
    __args__ = dict()
    __args__['account'] = account
    __args__['channels'] = channels
    __args__['created'] = created
    __args__['identifier'] = identifier
    __args__['lastModified'] = last_modified
    __args__['name'] = name
    __args__['notificationChannelType'] = notification_channel_type
    __args__['org'] = org
    __args__['project'] = project
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getCentralNotificationChannel:getCentralNotificationChannel', __args__, opts=opts, typ=GetCentralNotificationChannelResult)
    return __ret__.apply(lambda __response__: GetCentralNotificationChannelResult(
        account=pulumi.get(__response__, 'account'),
        channels=pulumi.get(__response__, 'channels'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        name=pulumi.get(__response__, 'name'),
        notification_channel_type=pulumi.get(__response__, 'notification_channel_type'),
        org=pulumi.get(__response__, 'org'),
        project=pulumi.get(__response__, 'project'),
        status=pulumi.get(__response__, 'status')))
