# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatadogConnectorResult',
    'AwaitableGetDatadogConnectorResult',
    'get_datadog_connector',
    'get_datadog_connector_output',
]

@pulumi.output_type
class GetDatadogConnectorResult:
    """
    A collection of values returned by getDatadogConnector.
    """
    def __init__(__self__, api_key_ref=None, application_key_ref=None, delegate_selectors=None, description=None, id=None, identifier=None, name=None, org_id=None, project_id=None, tags=None, url=None):
        if api_key_ref and not isinstance(api_key_ref, str):
            raise TypeError("Expected argument 'api_key_ref' to be a str")
        pulumi.set(__self__, "api_key_ref", api_key_ref)
        if application_key_ref and not isinstance(application_key_ref, str):
            raise TypeError("Expected argument 'application_key_ref' to be a str")
        pulumi.set(__self__, "application_key_ref", application_key_ref)
        if delegate_selectors and not isinstance(delegate_selectors, list):
            raise TypeError("Expected argument 'delegate_selectors' to be a list")
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="apiKeyRef")
    def api_key_ref(self) -> builtins.str:
        """
        Reference to the Harness secret containing the api key. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "api_key_ref")

    @property
    @pulumi.getter(name="applicationKeyRef")
    def application_key_ref(self) -> builtins.str:
        """
        Reference to the Harness secret containing the application key. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "application_key_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[Sequence[builtins.str]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL of the Datadog server.
        """
        return pulumi.get(self, "url")


class AwaitableGetDatadogConnectorResult(GetDatadogConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatadogConnectorResult(
            api_key_ref=self.api_key_ref,
            application_key_ref=self.application_key_ref,
            delegate_selectors=self.delegate_selectors,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            url=self.url)


def get_datadog_connector(delegate_selectors: Optional[Sequence[builtins.str]] = None,
                          identifier: Optional[builtins.str] = None,
                          name: Optional[builtins.str] = None,
                          org_id: Optional[builtins.str] = None,
                          project_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatadogConnectorResult:
    """
    Datasource for looking up a Datadog connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_datadog_connector(identifier="identifier")
    ```


    :param Sequence[builtins.str] delegate_selectors: Tags to filter delegates for connection.
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['delegateSelectors'] = delegate_selectors
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getDatadogConnector:getDatadogConnector', __args__, opts=opts, typ=GetDatadogConnectorResult).value

    return AwaitableGetDatadogConnectorResult(
        api_key_ref=pulumi.get(__ret__, 'api_key_ref'),
        application_key_ref=pulumi.get(__ret__, 'application_key_ref'),
        delegate_selectors=pulumi.get(__ret__, 'delegate_selectors'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        url=pulumi.get(__ret__, 'url'))
def get_datadog_connector_output(delegate_selectors: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                                 name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatadogConnectorResult]:
    """
    Datasource for looking up a Datadog connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_datadog_connector(identifier="identifier")
    ```


    :param Sequence[builtins.str] delegate_selectors: Tags to filter delegates for connection.
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['delegateSelectors'] = delegate_selectors
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getDatadogConnector:getDatadogConnector', __args__, opts=opts, typ=GetDatadogConnectorResult)
    return __ret__.apply(lambda __response__: GetDatadogConnectorResult(
        api_key_ref=pulumi.get(__response__, 'api_key_ref'),
        application_key_ref=pulumi.get(__response__, 'application_key_ref'),
        delegate_selectors=pulumi.get(__response__, 'delegate_selectors'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        url=pulumi.get(__response__, 'url')))
