# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGcpSecretManagerConnectorResult',
    'AwaitableGetGcpSecretManagerConnectorResult',
    'get_gcp_secret_manager_connector',
    'get_gcp_secret_manager_connector_output',
]

@pulumi.output_type
class GetGcpSecretManagerConnectorResult:
    """
    A collection of values returned by getGcpSecretManagerConnector.
    """
    def __init__(__self__, credentials_ref=None, delegate_selectors=None, description=None, execute_on_delegate=None, id=None, identifier=None, inherit_from_delegate=None, is_default=None, name=None, oidc_authentications=None, org_id=None, project_id=None, tags=None):
        if credentials_ref and not isinstance(credentials_ref, str):
            raise TypeError("Expected argument 'credentials_ref' to be a str")
        pulumi.set(__self__, "credentials_ref", credentials_ref)
        if delegate_selectors and not isinstance(delegate_selectors, list):
            raise TypeError("Expected argument 'delegate_selectors' to be a list")
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if execute_on_delegate and not isinstance(execute_on_delegate, bool):
            raise TypeError("Expected argument 'execute_on_delegate' to be a bool")
        pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegate and not isinstance(inherit_from_delegate, bool):
            raise TypeError("Expected argument 'inherit_from_delegate' to be a bool")
        pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oidc_authentications and not isinstance(oidc_authentications, list):
            raise TypeError("Expected argument 'oidc_authentications' to be a list")
        pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> builtins.str:
        """
        Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "credentials_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[builtins.str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> builtins.bool:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> builtins.bool:
        """
        Inherit configuration from delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> builtins.bool:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Sequence['outputs.GetGcpSecretManagerConnectorOidcAuthenticationResult']:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGcpSecretManagerConnectorResult(GetGcpSecretManagerConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpSecretManagerConnectorResult(
            credentials_ref=self.credentials_ref,
            delegate_selectors=self.delegate_selectors,
            description=self.description,
            execute_on_delegate=self.execute_on_delegate,
            id=self.id,
            identifier=self.identifier,
            inherit_from_delegate=self.inherit_from_delegate,
            is_default=self.is_default,
            name=self.name,
            oidc_authentications=self.oidc_authentications,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags)


def get_gcp_secret_manager_connector(identifier: Optional[builtins.str] = None,
                                     name: Optional[builtins.str] = None,
                                     org_id: Optional[builtins.str] = None,
                                     project_id: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpSecretManagerConnectorResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gcp_secret_manager_connector(identifier="identifier")
    ```


    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGcpSecretManagerConnector:getGcpSecretManagerConnector', __args__, opts=opts, typ=GetGcpSecretManagerConnectorResult).value

    return AwaitableGetGcpSecretManagerConnectorResult(
        credentials_ref=pulumi.get(__ret__, 'credentials_ref'),
        delegate_selectors=pulumi.get(__ret__, 'delegate_selectors'),
        description=pulumi.get(__ret__, 'description'),
        execute_on_delegate=pulumi.get(__ret__, 'execute_on_delegate'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        inherit_from_delegate=pulumi.get(__ret__, 'inherit_from_delegate'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name=pulumi.get(__ret__, 'name'),
        oidc_authentications=pulumi.get(__ret__, 'oidc_authentications'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_gcp_secret_manager_connector_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                                            name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpSecretManagerConnectorResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gcp_secret_manager_connector(identifier="identifier")
    ```


    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getGcpSecretManagerConnector:getGcpSecretManagerConnector', __args__, opts=opts, typ=GetGcpSecretManagerConnectorResult)
    return __ret__.apply(lambda __response__: GetGcpSecretManagerConnectorResult(
        credentials_ref=pulumi.get(__response__, 'credentials_ref'),
        delegate_selectors=pulumi.get(__response__, 'delegate_selectors'),
        description=pulumi.get(__response__, 'description'),
        execute_on_delegate=pulumi.get(__response__, 'execute_on_delegate'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        inherit_from_delegate=pulumi.get(__response__, 'inherit_from_delegate'),
        is_default=pulumi.get(__response__, 'is_default'),
        name=pulumi.get(__response__, 'name'),
        oidc_authentications=pulumi.get(__response__, 'oidc_authentications'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
