# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGitopsAgentOperatorYamlResult',
    'AwaitableGetGitopsAgentOperatorYamlResult',
    'get_gitops_agent_operator_yaml',
    'get_gitops_agent_operator_yaml_output',
]

@pulumi.output_type
class GetGitopsAgentOperatorYamlResult:
    """
    A collection of values returned by getGitopsAgentOperatorYaml.
    """
    def __init__(__self__, ca_data=None, id=None, identifier=None, namespace=None, org_id=None, private_key=None, project_id=None, proxies=None, skip_crds=None, yaml=None):
        if ca_data and not isinstance(ca_data, str):
            raise TypeError("Expected argument 'ca_data' to be a str")
        pulumi.set(__self__, "ca_data", ca_data)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if private_key and not isinstance(private_key, str):
            raise TypeError("Expected argument 'private_key' to be a str")
        pulumi.set(__self__, "private_key", private_key)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if proxies and not isinstance(proxies, list):
            raise TypeError("Expected argument 'proxies' to be a list")
        pulumi.set(__self__, "proxies", proxies)
        if skip_crds and not isinstance(skip_crds, bool):
            raise TypeError("Expected argument 'skip_crds' to be a bool")
        pulumi.set(__self__, "skip_crds", skip_crds)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[builtins.str]:
        """
        CA data of the GitOps agent, base64 encoded content of ca chain.
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The kubernetes namespace where the agent is installed.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[builtins.str]:
        """
        Private key for the GitOps agent. If provided authentication token will not be regenerated. Must be base64 encoded.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def proxies(self) -> Optional[Sequence['outputs.GetGitopsAgentOperatorYamlProxyResult']]:
        """
        Proxy settings for the GitOps agent.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter(name="skipCrds")
    def skip_crds(self) -> Optional[builtins.bool]:
        """
        Skip CRDs for the GitOps agent.
        """
        return pulumi.get(self, "skip_crds")

    @property
    @pulumi.getter
    def yaml(self) -> builtins.str:
        """
        The operator manifest YAML of the GitOps agent.
        """
        return pulumi.get(self, "yaml")


class AwaitableGetGitopsAgentOperatorYamlResult(GetGitopsAgentOperatorYamlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitopsAgentOperatorYamlResult(
            ca_data=self.ca_data,
            id=self.id,
            identifier=self.identifier,
            namespace=self.namespace,
            org_id=self.org_id,
            private_key=self.private_key,
            project_id=self.project_id,
            proxies=self.proxies,
            skip_crds=self.skip_crds,
            yaml=self.yaml)


def get_gitops_agent_operator_yaml(ca_data: Optional[builtins.str] = None,
                                   identifier: Optional[builtins.str] = None,
                                   namespace: Optional[builtins.str] = None,
                                   org_id: Optional[builtins.str] = None,
                                   private_key: Optional[builtins.str] = None,
                                   project_id: Optional[builtins.str] = None,
                                   proxies: Optional[Sequence[Union['GetGitopsAgentOperatorYamlProxyArgs', 'GetGitopsAgentOperatorYamlProxyArgsDict']]] = None,
                                   skip_crds: Optional[builtins.bool] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitopsAgentOperatorYamlResult:
    """
    Datasource for fetching a Harness Gitops Agent operator manifest YAML.


    :param builtins.str ca_data: CA data of the GitOps agent, base64 encoded content of ca chain.
    :param builtins.str identifier: Identifier of the GitOps agent.
    :param builtins.str namespace: The kubernetes namespace where the agent is installed.
    :param builtins.str org_id: Organization identifier of the GitOps agent.
    :param builtins.str private_key: Private key for the GitOps agent. If provided authentication token will not be regenerated. Must be base64 encoded.
    :param builtins.str project_id: Project identifier of the GitOps agent.
    :param Sequence[Union['GetGitopsAgentOperatorYamlProxyArgs', 'GetGitopsAgentOperatorYamlProxyArgsDict']] proxies: Proxy settings for the GitOps agent.
    :param builtins.bool skip_crds: Skip CRDs for the GitOps agent.
    """
    __args__ = dict()
    __args__['caData'] = ca_data
    __args__['identifier'] = identifier
    __args__['namespace'] = namespace
    __args__['orgId'] = org_id
    __args__['privateKey'] = private_key
    __args__['projectId'] = project_id
    __args__['proxies'] = proxies
    __args__['skipCrds'] = skip_crds
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGitopsAgentOperatorYaml:getGitopsAgentOperatorYaml', __args__, opts=opts, typ=GetGitopsAgentOperatorYamlResult).value

    return AwaitableGetGitopsAgentOperatorYamlResult(
        ca_data=pulumi.get(__ret__, 'ca_data'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        namespace=pulumi.get(__ret__, 'namespace'),
        org_id=pulumi.get(__ret__, 'org_id'),
        private_key=pulumi.get(__ret__, 'private_key'),
        project_id=pulumi.get(__ret__, 'project_id'),
        proxies=pulumi.get(__ret__, 'proxies'),
        skip_crds=pulumi.get(__ret__, 'skip_crds'),
        yaml=pulumi.get(__ret__, 'yaml'))
def get_gitops_agent_operator_yaml_output(ca_data: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          identifier: Optional[pulumi.Input[builtins.str]] = None,
                                          namespace: Optional[pulumi.Input[builtins.str]] = None,
                                          org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          private_key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          proxies: Optional[pulumi.Input[Optional[Sequence[Union['GetGitopsAgentOperatorYamlProxyArgs', 'GetGitopsAgentOperatorYamlProxyArgsDict']]]]] = None,
                                          skip_crds: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitopsAgentOperatorYamlResult]:
    """
    Datasource for fetching a Harness Gitops Agent operator manifest YAML.


    :param builtins.str ca_data: CA data of the GitOps agent, base64 encoded content of ca chain.
    :param builtins.str identifier: Identifier of the GitOps agent.
    :param builtins.str namespace: The kubernetes namespace where the agent is installed.
    :param builtins.str org_id: Organization identifier of the GitOps agent.
    :param builtins.str private_key: Private key for the GitOps agent. If provided authentication token will not be regenerated. Must be base64 encoded.
    :param builtins.str project_id: Project identifier of the GitOps agent.
    :param Sequence[Union['GetGitopsAgentOperatorYamlProxyArgs', 'GetGitopsAgentOperatorYamlProxyArgsDict']] proxies: Proxy settings for the GitOps agent.
    :param builtins.bool skip_crds: Skip CRDs for the GitOps agent.
    """
    __args__ = dict()
    __args__['caData'] = ca_data
    __args__['identifier'] = identifier
    __args__['namespace'] = namespace
    __args__['orgId'] = org_id
    __args__['privateKey'] = private_key
    __args__['projectId'] = project_id
    __args__['proxies'] = proxies
    __args__['skipCrds'] = skip_crds
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getGitopsAgentOperatorYaml:getGitopsAgentOperatorYaml', __args__, opts=opts, typ=GetGitopsAgentOperatorYamlResult)
    return __ret__.apply(lambda __response__: GetGitopsAgentOperatorYamlResult(
        ca_data=pulumi.get(__response__, 'ca_data'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        namespace=pulumi.get(__response__, 'namespace'),
        org_id=pulumi.get(__response__, 'org_id'),
        private_key=pulumi.get(__response__, 'private_key'),
        project_id=pulumi.get(__response__, 'project_id'),
        proxies=pulumi.get(__response__, 'proxies'),
        skip_crds=pulumi.get(__response__, 'skip_crds'),
        yaml=pulumi.get(__response__, 'yaml')))
