# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGitopsRepositoryResult',
    'AwaitableGetGitopsRepositoryResult',
    'get_gitops_repository',
    'get_gitops_repository_output',
]

@pulumi.output_type
class GetGitopsRepositoryResult:
    """
    A collection of values returned by getGitopsRepository.
    """
    def __init__(__self__, account_id=None, agent_id=None, enable_oci=None, id=None, identifier=None, org_id=None, project_id=None, repos=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if enable_oci and not isinstance(enable_oci, bool):
            raise TypeError("Expected argument 'enable_oci' to be a bool")
        pulumi.set(__self__, "enable_oci", enable_oci)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if repos and not isinstance(repos, list):
            raise TypeError("Expected argument 'repos' to be a list")
        pulumi.set(__self__, "repos", repos)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> builtins.str:
        """
        Account identifier of the GitOps repository.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> builtins.str:
        """
        Agent identifier of the GitOps repository.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="enableOci")
    def enable_oci(self) -> builtins.bool:
        """
        Indicates if helm-oci support must be enabled for this repo.
        """
        return pulumi.get(self, "enable_oci")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Identifier of the GitOps repository.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Organization identifier of the GitOps repository.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Project identifier of the GitOps repository.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def repos(self) -> Sequence['outputs.GetGitopsRepositoryRepoResult']:
        """
        Repo details holding application configurations.
        """
        return pulumi.get(self, "repos")


class AwaitableGetGitopsRepositoryResult(GetGitopsRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitopsRepositoryResult(
            account_id=self.account_id,
            agent_id=self.agent_id,
            enable_oci=self.enable_oci,
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            project_id=self.project_id,
            repos=self.repos)


def get_gitops_repository(account_id: Optional[builtins.str] = None,
                          agent_id: Optional[builtins.str] = None,
                          identifier: Optional[builtins.str] = None,
                          org_id: Optional[builtins.str] = None,
                          project_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitopsRepositoryResult:
    """
    Data source for fetching a Harness GitOps Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_repository(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id",
        agent_id="agent_id")
    ```


    :param builtins.str account_id: Account identifier of the GitOps repository.
    :param builtins.str agent_id: Agent identifier of the GitOps repository.
    :param builtins.str identifier: Identifier of the GitOps repository.
    :param builtins.str org_id: Organization identifier of the GitOps repository.
    :param builtins.str project_id: Project identifier of the GitOps repository.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['agentId'] = agent_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGitopsRepository:getGitopsRepository', __args__, opts=opts, typ=GetGitopsRepositoryResult).value

    return AwaitableGetGitopsRepositoryResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        agent_id=pulumi.get(__ret__, 'agent_id'),
        enable_oci=pulumi.get(__ret__, 'enable_oci'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        repos=pulumi.get(__ret__, 'repos'))
def get_gitops_repository_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                                 org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitopsRepositoryResult]:
    """
    Data source for fetching a Harness GitOps Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_repository(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id",
        agent_id="agent_id")
    ```


    :param builtins.str account_id: Account identifier of the GitOps repository.
    :param builtins.str agent_id: Agent identifier of the GitOps repository.
    :param builtins.str identifier: Identifier of the GitOps repository.
    :param builtins.str org_id: Organization identifier of the GitOps repository.
    :param builtins.str project_id: Project identifier of the GitOps repository.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['agentId'] = agent_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getGitopsRepository:getGitopsRepository', __args__, opts=opts, typ=GetGitopsRepositoryResult)
    return __ret__.apply(lambda __response__: GetGitopsRepositoryResult(
        account_id=pulumi.get(__response__, 'account_id'),
        agent_id=pulumi.get(__response__, 'agent_id'),
        enable_oci=pulumi.get(__response__, 'enable_oci'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        repos=pulumi.get(__response__, 'repos')))
