# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPipelineListResult',
    'AwaitableGetPipelineListResult',
    'get_pipeline_list',
    'get_pipeline_list_output',
]

@pulumi.output_type
class GetPipelineListResult:
    """
    A collection of values returned by getPipelineList.
    """
    def __init__(__self__, description=None, id=None, identifier=None, limit=None, name=None, org_id=None, page=None, pipelines=None, project_id=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if pipelines and not isinstance(pipelines, list):
            raise TypeError("Expected argument 'pipelines' to be a list")
        pulumi.set(__self__, "pipelines", pipelines)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Optional pagination parameter indicating the maximum number of entities to retrieve per page.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def page(self) -> Optional[builtins.int]:
        """
        Optional pagination parameter indicating the page number when retrieving entities.
        """
        return pulumi.get(self, "page")

    @property
    @pulumi.getter
    def pipelines(self) -> Sequence['outputs.GetPipelineListPipelineResult']:
        """
        Containing list of all pipeline with details identifier and name.
        """
        return pulumi.get(self, "pipelines")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetPipelineListResult(GetPipelineListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineListResult(
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            limit=self.limit,
            name=self.name,
            org_id=self.org_id,
            page=self.page,
            pipelines=self.pipelines,
            project_id=self.project_id,
            tags=self.tags)


def get_pipeline_list(identifier: Optional[builtins.str] = None,
                      limit: Optional[builtins.int] = None,
                      name: Optional[builtins.str] = None,
                      org_id: Optional[builtins.str] = None,
                      page: Optional[builtins.int] = None,
                      project_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineListResult:
    """
    Data source for retrieving a Harness pipeline list.

    ## Example Usage

    ### Without the Pagination

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline_list(org_id="org_id",
        project_id="project_id")
    ```

    ### With Pagination Logic

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline_list(org_id="org_id",
        project_id="project_id",
        page=1,
        limit=4)
    ```


    :param builtins.int limit: Optional pagination parameter indicating the maximum number of entities to retrieve per page.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.int page: Optional pagination parameter indicating the page number when retrieving entities.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['page'] = page
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getPipelineList:getPipelineList', __args__, opts=opts, typ=GetPipelineListResult).value

    return AwaitableGetPipelineListResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        limit=pulumi.get(__ret__, 'limit'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        page=pulumi.get(__ret__, 'page'),
        pipelines=pulumi.get(__ret__, 'pipelines'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_pipeline_list_output(identifier: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             limit: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             org_id: Optional[pulumi.Input[builtins.str]] = None,
                             page: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                             project_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineListResult]:
    """
    Data source for retrieving a Harness pipeline list.

    ## Example Usage

    ### Without the Pagination

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline_list(org_id="org_id",
        project_id="project_id")
    ```

    ### With Pagination Logic

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline_list(org_id="org_id",
        project_id="project_id",
        page=1,
        limit=4)
    ```


    :param builtins.int limit: Optional pagination parameter indicating the maximum number of entities to retrieve per page.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.int page: Optional pagination parameter indicating the page number when retrieving entities.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['page'] = page
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getPipelineList:getPipelineList', __args__, opts=opts, typ=GetPipelineListResult)
    return __ret__.apply(lambda __response__: GetPipelineListResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        limit=pulumi.get(__response__, 'limit'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        page=pulumi.get(__response__, 'page'),
        pipelines=pulumi.get(__response__, 'pipelines'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
