# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRolesResult',
    'AwaitableGetRolesResult',
    'get_roles',
    'get_roles_output',
]

@pulumi.output_type
class GetRolesResult:
    """
    A collection of values returned by getRoles.
    """
    def __init__(__self__, allowed_scope_levels=None, description=None, id=None, identifier=None, name=None, org_id=None, permissions=None, project_id=None, tags=None):
        if allowed_scope_levels and not isinstance(allowed_scope_levels, list):
            raise TypeError("Expected argument 'allowed_scope_levels' to be a list")
        pulumi.set(__self__, "allowed_scope_levels", allowed_scope_levels)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowedScopeLevels")
    def allowed_scope_levels(self) -> Sequence[builtins.str]:
        """
        The scope levels at which this role can be used
        """
        return pulumi.get(self, "allowed_scope_levels")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of the permission identifiers
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRolesResult(GetRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRolesResult(
            allowed_scope_levels=self.allowed_scope_levels,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            permissions=self.permissions,
            project_id=self.project_id,
            tags=self.tags)


def get_roles(allowed_scope_levels: Optional[Sequence[builtins.str]] = None,
              identifier: Optional[builtins.str] = None,
              name: Optional[builtins.str] = None,
              org_id: Optional[builtins.str] = None,
              permissions: Optional[Sequence[builtins.str]] = None,
              project_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRolesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_roles(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Sequence[builtins.str] allowed_scope_levels: The scope levels at which this role can be used
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param Sequence[builtins.str] permissions: List of the permission identifiers
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['allowedScopeLevels'] = allowed_scope_levels
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['permissions'] = permissions
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getRoles:getRoles', __args__, opts=opts, typ=GetRolesResult).value

    return AwaitableGetRolesResult(
        allowed_scope_levels=pulumi.get(__ret__, 'allowed_scope_levels'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        permissions=pulumi.get(__ret__, 'permissions'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_roles_output(allowed_scope_levels: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                     identifier: Optional[pulumi.Input[builtins.str]] = None,
                     name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     permissions: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                     project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRolesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_roles(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Sequence[builtins.str] allowed_scope_levels: The scope levels at which this role can be used
    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param Sequence[builtins.str] permissions: List of the permission identifiers
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['allowedScopeLevels'] = allowed_scope_levels
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['permissions'] = permissions
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getRoles:getRoles', __args__, opts=opts, typ=GetRolesResult)
    return __ret__.apply(lambda __response__: GetRolesResult(
        allowed_scope_levels=pulumi.get(__response__, 'allowed_scope_levels'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        permissions=pulumi.get(__response__, 'permissions'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
