# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceNowConnectorResult',
    'AwaitableGetServiceNowConnectorResult',
    'get_service_now_connector',
    'get_service_now_connector_output',
]

@pulumi.output_type
class GetServiceNowConnectorResult:
    """
    A collection of values returned by getServiceNowConnector.
    """
    def __init__(__self__, auths=None, delegate_selectors=None, description=None, id=None, identifier=None, name=None, org_id=None, password_ref=None, project_id=None, service_now_url=None, tags=None, username=None, username_ref=None):
        if auths and not isinstance(auths, list):
            raise TypeError("Expected argument 'auths' to be a list")
        pulumi.set(__self__, "auths", auths)
        if delegate_selectors and not isinstance(delegate_selectors, list):
            raise TypeError("Expected argument 'delegate_selectors' to be a list")
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if password_ref and not isinstance(password_ref, str):
            raise TypeError("Expected argument 'password_ref' to be a str")
        pulumi.set(__self__, "password_ref", password_ref)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if service_now_url and not isinstance(service_now_url, str):
            raise TypeError("Expected argument 'service_now_url' to be a str")
        pulumi.set(__self__, "service_now_url", service_now_url)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if username_ref and not isinstance(username_ref, str):
            raise TypeError("Expected argument 'username_ref' to be a str")
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter
    def auths(self) -> Sequence['outputs.GetServiceNowConnectorAuthResult']:
        """
        The credentials to use for the service now authentication.
        """
        return pulumi.get(self, "auths")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[builtins.str]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> builtins.str:
        """
        Reference to a secret containing the password to use for authentication. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceNowUrl")
    def service_now_url(self) -> builtins.str:
        """
        URL of service now.
        """
        return pulumi.get(self, "service_now_url")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> builtins.str:
        """
        Reference to a secret containing the username to use for authentication. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "username_ref")


class AwaitableGetServiceNowConnectorResult(GetServiceNowConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceNowConnectorResult(
            auths=self.auths,
            delegate_selectors=self.delegate_selectors,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            password_ref=self.password_ref,
            project_id=self.project_id,
            service_now_url=self.service_now_url,
            tags=self.tags,
            username=self.username,
            username_ref=self.username_ref)


def get_service_now_connector(identifier: Optional[builtins.str] = None,
                              name: Optional[builtins.str] = None,
                              org_id: Optional[builtins.str] = None,
                              project_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceNowConnectorResult:
    """
    Datasource for looking up a Service Now connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_service_now_connector(identifier="identifier")
    ```


    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getServiceNowConnector:getServiceNowConnector', __args__, opts=opts, typ=GetServiceNowConnectorResult).value

    return AwaitableGetServiceNowConnectorResult(
        auths=pulumi.get(__ret__, 'auths'),
        delegate_selectors=pulumi.get(__ret__, 'delegate_selectors'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        password_ref=pulumi.get(__ret__, 'password_ref'),
        project_id=pulumi.get(__ret__, 'project_id'),
        service_now_url=pulumi.get(__ret__, 'service_now_url'),
        tags=pulumi.get(__ret__, 'tags'),
        username=pulumi.get(__ret__, 'username'),
        username_ref=pulumi.get(__ret__, 'username_ref'))
def get_service_now_connector_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                                     name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceNowConnectorResult]:
    """
    Datasource for looking up a Service Now connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_service_now_connector(identifier="identifier")
    ```


    :param builtins.str identifier: Unique identifier of the resource.
    :param builtins.str name: Name of the resource.
    :param builtins.str org_id: Unique identifier of the organization.
    :param builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getServiceNowConnector:getServiceNowConnector', __args__, opts=opts, typ=GetServiceNowConnectorResult)
    return __ret__.apply(lambda __response__: GetServiceNowConnectorResult(
        auths=pulumi.get(__response__, 'auths'),
        delegate_selectors=pulumi.get(__response__, 'delegate_selectors'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        password_ref=pulumi.get(__response__, 'password_ref'),
        project_id=pulumi.get(__response__, 'project_id'),
        service_now_url=pulumi.get(__response__, 'service_now_url'),
        tags=pulumi.get(__response__, 'tags'),
        username=pulumi.get(__response__, 'username'),
        username_ref=pulumi.get(__response__, 'username_ref')))
