# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceOutputValueResult',
    'AwaitableGetWorkspaceOutputValueResult',
    'get_workspace_output_value',
    'get_workspace_output_value_output',
]

@pulumi.output_type
class GetWorkspaceOutputValueResult:
    """
    A collection of values returned by getWorkspaceOutputValue.
    """
    def __init__(__self__, id=None, identifier=None, org_id=None, output_values=None, project_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if output_values and not isinstance(output_values, list):
            raise TypeError("Expected argument 'output_values' to be a list")
        pulumi.set(__self__, "output_values", output_values)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Identifier of the Workspace.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        """
        Organization identifier of the organization the workspace resides in.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="outputValues")
    def output_values(self) -> Sequence['outputs.GetWorkspaceOutputValueOutputValueResult']:
        return pulumi.get(self, "output_values")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project identifier of the project the workspace resides in.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetWorkspaceOutputValueResult(GetWorkspaceOutputValueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceOutputValueResult(
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            output_values=self.output_values,
            project_id=self.project_id)


def get_workspace_output_value(identifier: Optional[builtins.str] = None,
                               org_id: Optional[builtins.str] = None,
                               project_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceOutputValueResult:
    """
    Data source for retrieving workspace outputs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_workspace_output_value(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param builtins.str identifier: Identifier of the Workspace.
    :param builtins.str org_id: Organization identifier of the organization the workspace resides in.
    :param builtins.str project_id: Project identifier of the project the workspace resides in.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getWorkspaceOutputValue:getWorkspaceOutputValue', __args__, opts=opts, typ=GetWorkspaceOutputValueResult).value

    return AwaitableGetWorkspaceOutputValueResult(
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        output_values=pulumi.get(__ret__, 'output_values'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_workspace_output_value_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                                      org_id: Optional[pulumi.Input[builtins.str]] = None,
                                      project_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceOutputValueResult]:
    """
    Data source for retrieving workspace outputs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_workspace_output_value(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param builtins.str identifier: Identifier of the Workspace.
    :param builtins.str org_id: Organization identifier of the organization the workspace resides in.
    :param builtins.str project_id: Project identifier of the project the workspace resides in.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getWorkspaceOutputValue:getWorkspaceOutputValue', __args__, opts=opts, typ=GetWorkspaceOutputValueResult)
    return __ret__.apply(lambda __response__: GetWorkspaceOutputValueResult(
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        org_id=pulumi.get(__response__, 'org_id'),
        output_values=pulumi.get(__response__, 'output_values'),
        project_id=pulumi.get(__response__, 'project_id')))
