# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitOpsAgentArgs', 'GitOpsAgent']

@pulumi.input_type
class GitOpsAgentArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a GitOpsAgent resource.
        :param pulumi.Input[builtins.str] identifier: Identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] type: Default: "AGENT*TYPE*UNSET"
               Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        :param pulumi.Input[builtins.str] account_id: Account identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] description: Description of the GitOps agent.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]] metadatas: Metadata of the agent.
        :param pulumi.Input[builtins.str] name: Name of the GitOps agent.
        :param pulumi.Input[builtins.str] operator: The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the GitOps agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Default: "AGENT*TYPE*UNSET"
        Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier of the GitOps agent.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the GitOps agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]]:
        """
        Metadata of the agent.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the GitOps agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GitOpsAgentState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 agent_token: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 prefixed_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitOpsAgent resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] agent_token: Agent token to be used for authentication of the agent with Harness.
        :param pulumi.Input[builtins.str] description: Description of the GitOps agent.
        :param pulumi.Input[builtins.str] identifier: Identifier of the GitOps agent.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]] metadatas: Metadata of the agent.
        :param pulumi.Input[builtins.str] name: Name of the GitOps agent.
        :param pulumi.Input[builtins.str] operator: The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] prefixed_identifier: Prefixed identifier of the GitOps agent. Agent identifier prefixed with scope of the agent
        :param pulumi.Input[builtins.str] project_id: Project identifier of the GitOps agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        :param pulumi.Input[builtins.str] type: Default: "AGENT*TYPE*UNSET"
               Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_token is not None:
            pulumi.set(__self__, "agent_token", agent_token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if prefixed_identifier is not None:
            pulumi.set(__self__, "prefixed_identifier", prefixed_identifier)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier of the GitOps agent.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="agentToken")
    def agent_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Agent token to be used for authentication of the agent with Harness.
        """
        return pulumi.get(self, "agent_token")

    @agent_token.setter
    def agent_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_token", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the GitOps agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]]:
        """
        Metadata of the agent.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsAgentMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the GitOps agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="prefixedIdentifier")
    def prefixed_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefixed identifier of the GitOps agent. Agent identifier prefixed with scope of the agent
        """
        return pulumi.get(self, "prefixed_identifier")

    @prefixed_identifier.setter
    def prefixed_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefixed_identifier", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default: "AGENT*TYPE*UNSET"
        Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("harness:platform/gitOpsAgent:GitOpsAgent")
class GitOpsAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsAgentMetadataArgs', 'GitOpsAgentMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing a Harness GitOps Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.GitOpsAgent("example",
            identifier="identifier",
            account_id="account_id",
            project_id="project_id",
            org_id="org_id",
            name="name",
            type="MANAGED_ARGO_PROVIDER",
            metadatas=[{
                "namespace": "namespace",
                "high_availability": True,
            }])
        ```

        ## Import

        Import an Account level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <agent_id>
        ```

        Import an Org level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <organization_id>/<agent_id>
        ```

        Import a Project level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <organization_id>/<project_id>/<agent_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] description: Description of the GitOps agent.
        :param pulumi.Input[builtins.str] identifier: Identifier of the GitOps agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsAgentMetadataArgs', 'GitOpsAgentMetadataArgsDict']]]] metadatas: Metadata of the agent.
        :param pulumi.Input[builtins.str] name: Name of the GitOps agent.
        :param pulumi.Input[builtins.str] operator: The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the GitOps agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        :param pulumi.Input[builtins.str] type: Default: "AGENT*TYPE*UNSET"
               Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitOpsAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness GitOps Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.GitOpsAgent("example",
            identifier="identifier",
            account_id="account_id",
            project_id="project_id",
            org_id="org_id",
            name="name",
            type="MANAGED_ARGO_PROVIDER",
            metadatas=[{
                "namespace": "namespace",
                "high_availability": True,
            }])
        ```

        ## Import

        Import an Account level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <agent_id>
        ```

        Import an Org level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <organization_id>/<agent_id>
        ```

        Import a Project level Gitops Agent

        ```sh
        $ pulumi import harness:platform/gitOpsAgent:GitOpsAgent example <organization_id>/<project_id>/<agent_id>
        ```

        :param str resource_name: The name of the resource.
        :param GitOpsAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitOpsAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsAgentMetadataArgs', 'GitOpsAgentMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitOpsAgentArgs.__new__(GitOpsAgentArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["name"] = name
            __props__.__dict__["operator"] = operator
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["agent_token"] = None
            __props__.__dict__["prefixed_identifier"] = None
        super(GitOpsAgent, __self__).__init__(
            'harness:platform/gitOpsAgent:GitOpsAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            agent_token: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsAgentMetadataArgs', 'GitOpsAgentMetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            operator: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            prefixed_identifier: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'GitOpsAgent':
        """
        Get an existing GitOpsAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] agent_token: Agent token to be used for authentication of the agent with Harness.
        :param pulumi.Input[builtins.str] description: Description of the GitOps agent.
        :param pulumi.Input[builtins.str] identifier: Identifier of the GitOps agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsAgentMetadataArgs', 'GitOpsAgentMetadataArgsDict']]]] metadatas: Metadata of the agent.
        :param pulumi.Input[builtins.str] name: Name of the GitOps agent.
        :param pulumi.Input[builtins.str] operator: The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the GitOps agent.
        :param pulumi.Input[builtins.str] prefixed_identifier: Prefixed identifier of the GitOps agent. Agent identifier prefixed with scope of the agent
        :param pulumi.Input[builtins.str] project_id: Project identifier of the GitOps agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        :param pulumi.Input[builtins.str] type: Default: "AGENT*TYPE*UNSET"
               Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitOpsAgentState.__new__(_GitOpsAgentState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_token"] = agent_token
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["operator"] = operator
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["prefixed_identifier"] = prefixed_identifier
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return GitOpsAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier of the GitOps agent.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentToken")
    def agent_token(self) -> pulumi.Output[builtins.str]:
        """
        Agent token to be used for authentication of the agent with Harness.
        """
        return pulumi.get(self, "agent_token")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the GitOps agent.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.GitOpsAgentMetadata']]]:
        """
        Metadata of the agent.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the GitOps agent.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="prefixedIdentifier")
    def prefixed_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Prefixed identifier of the GitOps agent. Agent identifier prefixed with scope of the agent
        """
        return pulumi.get(self, "prefixed_identifier")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Default: "AGENT*TYPE*UNSET"
        Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        return pulumi.get(self, "type")

