# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GitopsFiltersArgs', 'GitopsFilters']

@pulumi.input_type
class GitopsFiltersArgs:
    def __init__(__self__, *,
                 filter_properties: pulumi.Input[builtins.str],
                 identifier: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 filter_visibility: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GitopsFilters resource.
        :param pulumi.Input[builtins.str] filter_properties: Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the GitOps filter.
        :param pulumi.Input[builtins.str] org_id: Organization identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] project_id: Project identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] type: Type of GitOps filter. Currently, only "APPLICATION" is supported.
        :param pulumi.Input[builtins.str] filter_visibility: Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        :param pulumi.Input[builtins.str] name: Name of the GitOps filter.
        """
        pulumi.set(__self__, "filter_properties", filter_properties)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if filter_visibility is not None:
            pulumi.set(__self__, "filter_visibility", filter_visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> pulumi.Input[builtins.str]:
        """
        Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        """
        return pulumi.get(self, "filter_properties")

    @filter_properties.setter
    def filter_properties(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter_properties", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the GitOps filter.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        Organization identifier for the GitOps filter.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        Project identifier for the GitOps filter.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        """
        return pulumi.get(self, "filter_visibility")

    @filter_visibility.setter
    def filter_visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_visibility", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the GitOps filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GitopsFiltersState:
    def __init__(__self__, *,
                 filter_properties: Optional[pulumi.Input[builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitopsFilters resources.
        :param pulumi.Input[builtins.str] filter_properties: Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        :param pulumi.Input[builtins.str] filter_visibility: Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the GitOps filter.
        :param pulumi.Input[builtins.str] name: Name of the GitOps filter.
        :param pulumi.Input[builtins.str] org_id: Organization identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] project_id: Project identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] type: Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        if filter_properties is not None:
            pulumi.set(__self__, "filter_properties", filter_properties)
        if filter_visibility is not None:
            pulumi.set(__self__, "filter_visibility", filter_visibility)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        """
        return pulumi.get(self, "filter_properties")

    @filter_properties.setter
    def filter_properties(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_properties", value)

    @property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        """
        return pulumi.get(self, "filter_visibility")

    @filter_visibility.setter
    def filter_visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_visibility", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the GitOps filter.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the GitOps filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier for the GitOps filter.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier for the GitOps filter.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("harness:platform/gitopsFilters:GitopsFilters")
class GitopsFilters(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_properties: Optional[pulumi.Input[builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating and managing Harness GitOps Filters.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        example = harness.platform.GitopsFilters("example",
            name="example_filter",
            org_id="your_org_id",
            project_id="your_project_id",
            identifier="example_filter",
            type="APPLICATION",
            filter_properties=json.dumps({
                "agentIdentifiers": ["your_agent_identifier"],
                "clusters": ["https://your-cluster-url"],
                "healthStatus": [
                    "Unknown",
                    "Progressing",
                    "Suspended",
                    "Healthy",
                    "Degraded",
                    "Missing",
                ],
                "namespaces": ["your-namespace"],
                "repositories": ["your-repo"],
                "syncStatus": [
                    "OutOfSync",
                    "Synced",
                    "Unknown",
                ],
            }),
            filter_visibility="OnlyCreator")
        ```

        ## Filter Properties Reference

        The `filter_properties` field supports the following filter types:

        > **Note:** The following filter properties are only valid for filter type "APPLICATION". Different filter types may support different properties.

        * `agentIdentifiers` - Array of GitOps agent identifiers to filter by.
        * `clusters` - Array of cluster URLs to filter by.
        * `healthStatus` - Array of health status values to filter by. Valid values include: "Unknown", "Progressing", "Suspended", "Healthy", "Degraded", "Missing".
        * `namespaces` - Array of Kubernetes namespaces to filter by.
        * `repositories` - Array of Git repository URLs to filter by.
        * `syncStatus` - Array of sync status values to filter by. Valid values include: "OutOfSync", "Synced", "Unknown".

        ## Schema Attributes Reference

        * `id` - Identifier of the GitOps filter.

        ## Import

        GitOps filters can be imported using a composite ID formed of organization ID, project ID, filter ID, and filter type.

        bash

        Format: <org_id>/<project_id>/<filter_id>/<filter_type>

        ```sh
        $ pulumi import harness:platform/gitopsFilters:GitopsFilters example org_id/project_id/filter_id/APPLICATION
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] filter_properties: Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        :param pulumi.Input[builtins.str] filter_visibility: Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the GitOps filter.
        :param pulumi.Input[builtins.str] name: Name of the GitOps filter.
        :param pulumi.Input[builtins.str] org_id: Organization identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] project_id: Project identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] type: Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitopsFiltersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating and managing Harness GitOps Filters.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        example = harness.platform.GitopsFilters("example",
            name="example_filter",
            org_id="your_org_id",
            project_id="your_project_id",
            identifier="example_filter",
            type="APPLICATION",
            filter_properties=json.dumps({
                "agentIdentifiers": ["your_agent_identifier"],
                "clusters": ["https://your-cluster-url"],
                "healthStatus": [
                    "Unknown",
                    "Progressing",
                    "Suspended",
                    "Healthy",
                    "Degraded",
                    "Missing",
                ],
                "namespaces": ["your-namespace"],
                "repositories": ["your-repo"],
                "syncStatus": [
                    "OutOfSync",
                    "Synced",
                    "Unknown",
                ],
            }),
            filter_visibility="OnlyCreator")
        ```

        ## Filter Properties Reference

        The `filter_properties` field supports the following filter types:

        > **Note:** The following filter properties are only valid for filter type "APPLICATION". Different filter types may support different properties.

        * `agentIdentifiers` - Array of GitOps agent identifiers to filter by.
        * `clusters` - Array of cluster URLs to filter by.
        * `healthStatus` - Array of health status values to filter by. Valid values include: "Unknown", "Progressing", "Suspended", "Healthy", "Degraded", "Missing".
        * `namespaces` - Array of Kubernetes namespaces to filter by.
        * `repositories` - Array of Git repository URLs to filter by.
        * `syncStatus` - Array of sync status values to filter by. Valid values include: "OutOfSync", "Synced", "Unknown".

        ## Schema Attributes Reference

        * `id` - Identifier of the GitOps filter.

        ## Import

        GitOps filters can be imported using a composite ID formed of organization ID, project ID, filter ID, and filter type.

        bash

        Format: <org_id>/<project_id>/<filter_id>/<filter_type>

        ```sh
        $ pulumi import harness:platform/gitopsFilters:GitopsFilters example org_id/project_id/filter_id/APPLICATION
        ```

        :param str resource_name: The name of the resource.
        :param GitopsFiltersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitopsFiltersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_properties: Optional[pulumi.Input[builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitopsFiltersArgs.__new__(GitopsFiltersArgs)

            if filter_properties is None and not opts.urn:
                raise TypeError("Missing required property 'filter_properties'")
            __props__.__dict__["filter_properties"] = filter_properties
            __props__.__dict__["filter_visibility"] = filter_visibility
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(GitopsFilters, __self__).__init__(
            'harness:platform/gitopsFilters:GitopsFilters',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter_properties: Optional[pulumi.Input[builtins.str]] = None,
            filter_visibility: Optional[pulumi.Input[builtins.str]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'GitopsFilters':
        """
        Get an existing GitopsFilters resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] filter_properties: Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        :param pulumi.Input[builtins.str] filter_visibility: Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the GitOps filter.
        :param pulumi.Input[builtins.str] name: Name of the GitOps filter.
        :param pulumi.Input[builtins.str] org_id: Organization identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] project_id: Project identifier for the GitOps filter.
        :param pulumi.Input[builtins.str] type: Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitopsFiltersState.__new__(_GitopsFiltersState)

        __props__.__dict__["filter_properties"] = filter_properties
        __props__.__dict__["filter_visibility"] = filter_visibility
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["type"] = type
        return GitopsFilters(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> pulumi.Output[builtins.str]:
        """
        Properties of the filter entity defined in Harness as a JSON string. All values should be arrays of strings. Example: `jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})`.
        """
        return pulumi.get(self, "filter_properties")

    @property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Visibility of the filter. Valid values are "EveryOne" and "OnlyCreator". Default is "EveryOne".
        """
        return pulumi.get(self, "filter_visibility")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the GitOps filter.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the GitOps filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        Organization identifier for the GitOps filter.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        Project identifier for the GitOps filter.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of GitOps filter. Currently, only "APPLICATION" is supported.
        """
        return pulumi.get(self, "type")

