# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManualFreezeArgs', 'ManualFreeze']

@pulumi.input_type
class ManualFreezeArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 identifier: pulumi.Input[builtins.str],
                 yaml: pulumi.Input[builtins.str],
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManualFreeze resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier of the freeze
        :param pulumi.Input[builtins.str] identifier: Identifier of the freeze
        :param pulumi.Input[builtins.str] yaml: Yaml of the freeze
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the freeze
        :param pulumi.Input[builtins.str] project_id: Project identifier of the freeze
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "yaml", yaml)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account Identifier of the freeze
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the freeze
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def yaml(self) -> pulumi.Input[builtins.str]:
        """
        Yaml of the freeze
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "yaml", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the freeze
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the freeze
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _ManualFreezeState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 current_or_upcoming_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeCurrentOrUpcomingWindowArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeze_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeFreezeWindowArgs']]]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManualFreeze resources.
        :param pulumi.Input[builtins.str] account_id: Account Identifier of the freeze
        :param pulumi.Input[Sequence[pulumi.Input['ManualFreezeCurrentOrUpcomingWindowArgs']]] current_or_upcoming_windows: Current or upcoming windows
        :param pulumi.Input[builtins.str] description: Description of the freeze
        :param pulumi.Input[Sequence[pulumi.Input['ManualFreezeFreezeWindowArgs']]] freeze_windows: Freeze windows in the freeze response
        :param pulumi.Input[builtins.str] identifier: Identifier of the freeze
        :param pulumi.Input[builtins.str] name: Name of the freeze
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the freeze
        :param pulumi.Input[builtins.str] project_id: Project identifier of the freeze
        :param pulumi.Input[builtins.str] scope: Scope of the freeze
        :param pulumi.Input[builtins.str] status: Status of the freeze
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags associated with the freeze
        :param pulumi.Input[builtins.str] type: Type of freeze
        :param pulumi.Input[builtins.str] yaml: Yaml of the freeze
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if current_or_upcoming_windows is not None:
            pulumi.set(__self__, "current_or_upcoming_windows", current_or_upcoming_windows)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeze_windows is not None:
            pulumi.set(__self__, "freeze_windows", freeze_windows)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account Identifier of the freeze
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="currentOrUpcomingWindows")
    def current_or_upcoming_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeCurrentOrUpcomingWindowArgs']]]]:
        """
        Current or upcoming windows
        """
        return pulumi.get(self, "current_or_upcoming_windows")

    @current_or_upcoming_windows.setter
    def current_or_upcoming_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeCurrentOrUpcomingWindowArgs']]]]):
        pulumi.set(self, "current_or_upcoming_windows", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the freeze
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freezeWindows")
    def freeze_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeFreezeWindowArgs']]]]:
        """
        Freeze windows in the freeze response
        """
        return pulumi.get(self, "freeze_windows")

    @freeze_windows.setter
    def freeze_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManualFreezeFreezeWindowArgs']]]]):
        pulumi.set(self, "freeze_windows", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the freeze
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the freeze
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the freeze
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the freeze
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Scope of the freeze
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the freeze
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags associated with the freeze
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of freeze
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Yaml of the freeze
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.type_token("harness:platform/manualFreeze:ManualFreeze")
class ManualFreeze(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for Manual Deployment Freeze Window.
        ## Example to create Manual Freeze at different levels (Org, Project, Account)

        ### Account Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ### Org Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ### Project Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ## Import

        Import an account level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <freeze_id>
        ```

        Import an organization level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <org_id>/<freeze_id>
        ```

        Import project level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <org_id>/<project_id>/<freeze_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier of the freeze
        :param pulumi.Input[builtins.str] identifier: Identifier of the freeze
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the freeze
        :param pulumi.Input[builtins.str] project_id: Project identifier of the freeze
        :param pulumi.Input[builtins.str] yaml: Yaml of the freeze
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManualFreezeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for Manual Deployment Freeze Window.
        ## Example to create Manual Freeze at different levels (Org, Project, Account)

        ### Account Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ### Org Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ### Project Level

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.ManualFreeze("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            account_id="accountIdentifier",
            yaml=\"\"\"freeze:
          name: freezeName
          identifier: identifier
          entityConfigs:
            - name: r1
              entities:
                - filterType: All
                  type: Org
                - filterType: All
                  type: Project
                - filterType: All
                  type: Service
                - filterType: All
                  type: EnvType
          status: Disabled
          description: hi
          windows:
          - timeZone: Asia/Calcutta
            startTime: 2023-05-03 04:16 PM
            duration: 30m
            recurrence:
              type: Daily
          notificationRules: []
          tags: {}
        \"\"\")
        ```

        ## Import

        Import an account level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <freeze_id>
        ```

        Import an organization level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <org_id>/<freeze_id>
        ```

        Import project level freeze

        ```sh
        $ pulumi import harness:platform/manualFreeze:ManualFreeze example <org_id>/<project_id>/<freeze_id>
        ```

        :param str resource_name: The name of the resource.
        :param ManualFreezeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManualFreezeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManualFreezeArgs.__new__(ManualFreezeArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if yaml is None and not opts.urn:
                raise TypeError("Missing required property 'yaml'")
            __props__.__dict__["yaml"] = yaml
            __props__.__dict__["current_or_upcoming_windows"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["freeze_windows"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["scope"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["type"] = None
        super(ManualFreeze, __self__).__init__(
            'harness:platform/manualFreeze:ManualFreeze',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            current_or_upcoming_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManualFreezeCurrentOrUpcomingWindowArgs', 'ManualFreezeCurrentOrUpcomingWindowArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            freeze_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManualFreezeFreezeWindowArgs', 'ManualFreezeFreezeWindowArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            yaml: Optional[pulumi.Input[builtins.str]] = None) -> 'ManualFreeze':
        """
        Get an existing ManualFreeze resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier of the freeze
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManualFreezeCurrentOrUpcomingWindowArgs', 'ManualFreezeCurrentOrUpcomingWindowArgsDict']]]] current_or_upcoming_windows: Current or upcoming windows
        :param pulumi.Input[builtins.str] description: Description of the freeze
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManualFreezeFreezeWindowArgs', 'ManualFreezeFreezeWindowArgsDict']]]] freeze_windows: Freeze windows in the freeze response
        :param pulumi.Input[builtins.str] identifier: Identifier of the freeze
        :param pulumi.Input[builtins.str] name: Name of the freeze
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the freeze
        :param pulumi.Input[builtins.str] project_id: Project identifier of the freeze
        :param pulumi.Input[builtins.str] scope: Scope of the freeze
        :param pulumi.Input[builtins.str] status: Status of the freeze
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags associated with the freeze
        :param pulumi.Input[builtins.str] type: Type of freeze
        :param pulumi.Input[builtins.str] yaml: Yaml of the freeze
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManualFreezeState.__new__(_ManualFreezeState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["current_or_upcoming_windows"] = current_or_upcoming_windows
        __props__.__dict__["description"] = description
        __props__.__dict__["freeze_windows"] = freeze_windows
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["scope"] = scope
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["yaml"] = yaml
        return ManualFreeze(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account Identifier of the freeze
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="currentOrUpcomingWindows")
    def current_or_upcoming_windows(self) -> pulumi.Output[Sequence['outputs.ManualFreezeCurrentOrUpcomingWindow']]:
        """
        Current or upcoming windows
        """
        return pulumi.get(self, "current_or_upcoming_windows")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the freeze
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freezeWindows")
    def freeze_windows(self) -> pulumi.Output[Sequence['outputs.ManualFreezeFreezeWindow']]:
        """
        Freeze windows in the freeze response
        """
        return pulumi.get(self, "freeze_windows")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the freeze
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the freeze
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Organization identifier of the freeze
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Project identifier of the freeze
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        Scope of the freeze
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the freeze
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Tags associated with the freeze
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of freeze
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def yaml(self) -> pulumi.Output[builtins.str]:
        """
        Yaml of the freeze
        """
        return pulumi.get(self, "yaml")

