# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 git_details: Optional[pulumi.Input['PipelineGitDetailsArgs']] = None,
                 git_import_info: Optional[pulumi.Input['PipelineGitImportInfoArgs']] = None,
                 import_from_git: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_import_request: Optional[pulumi.Input['PipelinePipelineImportRequestArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_applied: Optional[pulumi.Input[builtins.bool]] = None,
                 template_applied_pipeline_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input['PipelineGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input['PipelineGitImportInfoArgs'] git_import_info: Contains Git Information for importing entities from Git
        :param pulumi.Input[builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input['PipelinePipelineImportRequestArgs'] pipeline_import_request: Contains parameters for importing a pipeline
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        :param pulumi.Input[builtins.bool] template_applied: If true, returns Pipeline YAML with Templates applied on it.
        :param pulumi.Input[builtins.str] template_applied_pipeline_yaml: Pipeline YAML after resolving Templates (returned as a String).
        :param pulumi.Input[builtins.str] yaml: YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if git_import_info is not None:
            pulumi.set(__self__, "git_import_info", git_import_info)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_import_request is not None:
            pulumi.set(__self__, "pipeline_import_request", pipeline_import_request)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_applied is not None:
            pulumi.set(__self__, "template_applied", template_applied)
        if template_applied_pipeline_yaml is not None:
            pulumi.set(__self__, "template_applied_pipeline_yaml", template_applied_pipeline_yaml)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['PipelineGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['PipelineGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter(name="gitImportInfo")
    def git_import_info(self) -> Optional[pulumi.Input['PipelineGitImportInfoArgs']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_info")

    @git_import_info.setter
    def git_import_info(self, value: Optional[pulumi.Input['PipelineGitImportInfoArgs']]):
        pulumi.set(self, "git_import_info", value)

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineImportRequest")
    def pipeline_import_request(self) -> Optional[pulumi.Input['PipelinePipelineImportRequestArgs']]:
        """
        Contains parameters for importing a pipeline
        """
        return pulumi.get(self, "pipeline_import_request")

    @pipeline_import_request.setter
    def pipeline_import_request(self, value: Optional[pulumi.Input['PipelinePipelineImportRequestArgs']]):
        pulumi.set(self, "pipeline_import_request", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateApplied")
    def template_applied(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, returns Pipeline YAML with Templates applied on it.
        """
        return pulumi.get(self, "template_applied")

    @template_applied.setter
    def template_applied(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "template_applied", value)

    @property
    @pulumi.getter(name="templateAppliedPipelineYaml")
    def template_applied_pipeline_yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pipeline YAML after resolving Templates (returned as a String).
        """
        return pulumi.get(self, "template_applied_pipeline_yaml")

    @template_applied_pipeline_yaml.setter
    def template_applied_pipeline_yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_applied_pipeline_yaml", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 git_details: Optional[pulumi.Input['PipelineGitDetailsArgs']] = None,
                 git_import_info: Optional[pulumi.Input['PipelineGitImportInfoArgs']] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_import_request: Optional[pulumi.Input['PipelinePipelineImportRequestArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_applied: Optional[pulumi.Input[builtins.bool]] = None,
                 template_applied_pipeline_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input['PipelineGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input['PipelineGitImportInfoArgs'] git_import_info: Contains Git Information for importing entities from Git
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input['PipelinePipelineImportRequestArgs'] pipeline_import_request: Contains parameters for importing a pipeline
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        :param pulumi.Input[builtins.bool] template_applied: If true, returns Pipeline YAML with Templates applied on it.
        :param pulumi.Input[builtins.str] template_applied_pipeline_yaml: Pipeline YAML after resolving Templates (returned as a String).
        :param pulumi.Input[builtins.str] yaml: YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if git_import_info is not None:
            pulumi.set(__self__, "git_import_info", git_import_info)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if pipeline_import_request is not None:
            pulumi.set(__self__, "pipeline_import_request", pipeline_import_request)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_applied is not None:
            pulumi.set(__self__, "template_applied", template_applied)
        if template_applied_pipeline_yaml is not None:
            pulumi.set(__self__, "template_applied_pipeline_yaml", template_applied_pipeline_yaml)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['PipelineGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['PipelineGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter(name="gitImportInfo")
    def git_import_info(self) -> Optional[pulumi.Input['PipelineGitImportInfoArgs']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_info")

    @git_import_info.setter
    def git_import_info(self, value: Optional[pulumi.Input['PipelineGitImportInfoArgs']]):
        pulumi.set(self, "git_import_info", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="pipelineImportRequest")
    def pipeline_import_request(self) -> Optional[pulumi.Input['PipelinePipelineImportRequestArgs']]:
        """
        Contains parameters for importing a pipeline
        """
        return pulumi.get(self, "pipeline_import_request")

    @pipeline_import_request.setter
    def pipeline_import_request(self, value: Optional[pulumi.Input['PipelinePipelineImportRequestArgs']]):
        pulumi.set(self, "pipeline_import_request", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateApplied")
    def template_applied(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, returns Pipeline YAML with Templates applied on it.
        """
        return pulumi.get(self, "template_applied")

    @template_applied.setter
    def template_applied(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "template_applied", value)

    @property
    @pulumi.getter(name="templateAppliedPipelineYaml")
    def template_applied_pipeline_yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pipeline YAML after resolving Templates (returned as a String).
        """
        return pulumi.get(self, "template_applied_pipeline_yaml")

    @template_applied_pipeline_yaml.setter
    def template_applied_pipeline_yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_applied_pipeline_yaml", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.type_token("harness:platform/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 git_details: Optional[pulumi.Input[Union['PipelineGitDetailsArgs', 'PipelineGitDetailsArgsDict']]] = None,
                 git_import_info: Optional[pulumi.Input[Union['PipelineGitImportInfoArgs', 'PipelineGitImportInfoArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_import_request: Optional[pulumi.Input[Union['PipelinePipelineImportRequestArgs', 'PipelinePipelineImportRequestArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_applied: Optional[pulumi.Input[builtins.bool]] = None,
                 template_applied_pipeline_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Pipeline("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            name="name",
            git_details={
                "branch_name": "branchName",
                "commit_message": "commitMessage",
                "file_path": "filePath",
                "connector_ref": "connectorRef",
                "store_type": "REMOTE",
                "repo_name": "repoName",
            },
            tags={},
            yaml=\"\"\"pipeline:
            name: name
            identifier: identifier
            allowStageExecutions: false
            projectIdentifier: projectIdentifier
            orgIdentifier: orgIdentifier
            tags: {}
            stages:
                - stage:
                    name: dep
                    identifier: dep
                    description: ""
                    type: Deployment
                    spec:
                        serviceConfig:
                            serviceRef: service
                            serviceDefinition:
                                type: Kubernetes
                                spec:
                                    variables: []
                        infrastructure:
                            environmentRef: testenv
                            infrastructureDefinition:
                                type: KubernetesDirect
                                spec:
                                    connectorRef: testconf
                                    namespace: test
                                    releaseName: release-<+INFRA_KEY>
                            allowSimultaneousDeployments: false
                        execution:
                            steps:
                                - stepGroup:
                                        name: Canary Deployment
                                        identifier: canaryDepoyment
                                        steps:
                                            - step:
                                                name: Canary Deployment
                                                identifier: canaryDeployment
                                                type: K8sCanaryDeploy
                                                timeout: 10m
                                                spec:
                                                    instanceSelection:
                                                        type: Count
                                                        spec:
                                                            count: 1
                                                    skipDryRun: false
                                            - step:
                                                name: Canary Delete
                                                identifier: canaryDelete
                                                type: K8sCanaryDelete
                                                timeout: 10m
                                                spec: {}
                                        rollbackSteps:
                                            - step:
                                                name: Canary Delete
                                                identifier: rollbackCanaryDelete
                                                type: K8sCanaryDelete
                                                timeout: 10m
                                                spec: {}
                                - stepGroup:
                                        name: Primary Deployment
                                        identifier: primaryDepoyment
                                        steps:
                                            - step:
                                                name: Rolling Deployment
                                                identifier: rollingDeployment
                                                type: K8sRollingDeploy
                                                timeout: 10m
                                                spec:
                                                    skipDryRun: false
                                        rollbackSteps:
                                            - step:
                                                name: Rolling Rollback
                                                identifier: rollingRollback
                                                type: K8sRollingRollback
                                                timeout: 10m
                                                spec: {}
                            rollbackSteps: []
                    tags: {}
                    failureStrategies:
                        - onFailure:
                                errors:
                                    - AllErrors
                                action:
                                    type: StageRollback
        \"\"\")
        ### Importing Pipeline from Git
        test = harness.platform.Organization("test",
            identifier="identifier",
            name="name")
        test_pipeline = harness.platform.Pipeline("test",
            identifier="gitx",
            org_id="default",
            project_id="V",
            name="gitx",
            import_from_git=True,
            git_import_info={
                "branch_name": "main",
                "file_path": ".harness/gitx.yaml",
                "connector_ref": "account.DoNotDeleteGithub",
                "repo_name": "open-repo",
            },
            pipeline_import_request={
                "pipeline_name": "gitx",
                "pipeline_description": "Pipeline Description",
            })
        ```

        ## Import

        Import pipeline

        ```sh
        $ pulumi import harness:platform/pipeline:Pipeline example <org_id>/<project_id>/<pipeline_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['PipelineGitDetailsArgs', 'PipelineGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[Union['PipelineGitImportInfoArgs', 'PipelineGitImportInfoArgsDict']] git_import_info: Contains Git Information for importing entities from Git
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Union['PipelinePipelineImportRequestArgs', 'PipelinePipelineImportRequestArgsDict']] pipeline_import_request: Contains parameters for importing a pipeline
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        :param pulumi.Input[builtins.bool] template_applied: If true, returns Pipeline YAML with Templates applied on it.
        :param pulumi.Input[builtins.str] template_applied_pipeline_yaml: Pipeline YAML after resolving Templates (returned as a String).
        :param pulumi.Input[builtins.str] yaml: YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Pipeline("example",
            identifier="identifier",
            org_id="orgIdentifier",
            project_id="projectIdentifier",
            name="name",
            git_details={
                "branch_name": "branchName",
                "commit_message": "commitMessage",
                "file_path": "filePath",
                "connector_ref": "connectorRef",
                "store_type": "REMOTE",
                "repo_name": "repoName",
            },
            tags={},
            yaml=\"\"\"pipeline:
            name: name
            identifier: identifier
            allowStageExecutions: false
            projectIdentifier: projectIdentifier
            orgIdentifier: orgIdentifier
            tags: {}
            stages:
                - stage:
                    name: dep
                    identifier: dep
                    description: ""
                    type: Deployment
                    spec:
                        serviceConfig:
                            serviceRef: service
                            serviceDefinition:
                                type: Kubernetes
                                spec:
                                    variables: []
                        infrastructure:
                            environmentRef: testenv
                            infrastructureDefinition:
                                type: KubernetesDirect
                                spec:
                                    connectorRef: testconf
                                    namespace: test
                                    releaseName: release-<+INFRA_KEY>
                            allowSimultaneousDeployments: false
                        execution:
                            steps:
                                - stepGroup:
                                        name: Canary Deployment
                                        identifier: canaryDepoyment
                                        steps:
                                            - step:
                                                name: Canary Deployment
                                                identifier: canaryDeployment
                                                type: K8sCanaryDeploy
                                                timeout: 10m
                                                spec:
                                                    instanceSelection:
                                                        type: Count
                                                        spec:
                                                            count: 1
                                                    skipDryRun: false
                                            - step:
                                                name: Canary Delete
                                                identifier: canaryDelete
                                                type: K8sCanaryDelete
                                                timeout: 10m
                                                spec: {}
                                        rollbackSteps:
                                            - step:
                                                name: Canary Delete
                                                identifier: rollbackCanaryDelete
                                                type: K8sCanaryDelete
                                                timeout: 10m
                                                spec: {}
                                - stepGroup:
                                        name: Primary Deployment
                                        identifier: primaryDepoyment
                                        steps:
                                            - step:
                                                name: Rolling Deployment
                                                identifier: rollingDeployment
                                                type: K8sRollingDeploy
                                                timeout: 10m
                                                spec:
                                                    skipDryRun: false
                                        rollbackSteps:
                                            - step:
                                                name: Rolling Rollback
                                                identifier: rollingRollback
                                                type: K8sRollingRollback
                                                timeout: 10m
                                                spec: {}
                            rollbackSteps: []
                    tags: {}
                    failureStrategies:
                        - onFailure:
                                errors:
                                    - AllErrors
                                action:
                                    type: StageRollback
        \"\"\")
        ### Importing Pipeline from Git
        test = harness.platform.Organization("test",
            identifier="identifier",
            name="name")
        test_pipeline = harness.platform.Pipeline("test",
            identifier="gitx",
            org_id="default",
            project_id="V",
            name="gitx",
            import_from_git=True,
            git_import_info={
                "branch_name": "main",
                "file_path": ".harness/gitx.yaml",
                "connector_ref": "account.DoNotDeleteGithub",
                "repo_name": "open-repo",
            },
            pipeline_import_request={
                "pipeline_name": "gitx",
                "pipeline_description": "Pipeline Description",
            })
        ```

        ## Import

        Import pipeline

        ```sh
        $ pulumi import harness:platform/pipeline:Pipeline example <org_id>/<project_id>/<pipeline_id>
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 git_details: Optional[pulumi.Input[Union['PipelineGitDetailsArgs', 'PipelineGitDetailsArgsDict']]] = None,
                 git_import_info: Optional[pulumi.Input[Union['PipelineGitImportInfoArgs', 'PipelineGitImportInfoArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_import_request: Optional[pulumi.Input[Union['PipelinePipelineImportRequestArgs', 'PipelinePipelineImportRequestArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_applied: Optional[pulumi.Input[builtins.bool]] = None,
                 template_applied_pipeline_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["git_details"] = git_details
            __props__.__dict__["git_import_info"] = git_import_info
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["import_from_git"] = import_from_git
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["pipeline_import_request"] = pipeline_import_request
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_applied"] = template_applied
            __props__.__dict__["template_applied_pipeline_yaml"] = template_applied_pipeline_yaml
            __props__.__dict__["yaml"] = yaml
        super(Pipeline, __self__).__init__(
            'harness:platform/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            git_details: Optional[pulumi.Input[Union['PipelineGitDetailsArgs', 'PipelineGitDetailsArgsDict']]] = None,
            git_import_info: Optional[pulumi.Input[Union['PipelineGitImportInfoArgs', 'PipelineGitImportInfoArgsDict']]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            import_from_git: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_import_request: Optional[pulumi.Input[Union['PipelinePipelineImportRequestArgs', 'PipelinePipelineImportRequestArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            template_applied: Optional[pulumi.Input[builtins.bool]] = None,
            template_applied_pipeline_yaml: Optional[pulumi.Input[builtins.str]] = None,
            yaml: Optional[pulumi.Input[builtins.str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['PipelineGitDetailsArgs', 'PipelineGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[Union['PipelineGitImportInfoArgs', 'PipelineGitImportInfoArgsDict']] git_import_info: Contains Git Information for importing entities from Git
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Union['PipelinePipelineImportRequestArgs', 'PipelinePipelineImportRequestArgsDict']] pipeline_import_request: Contains parameters for importing a pipeline
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        :param pulumi.Input[builtins.bool] template_applied: If true, returns Pipeline YAML with Templates applied on it.
        :param pulumi.Input[builtins.str] template_applied_pipeline_yaml: Pipeline YAML after resolving Templates (returned as a String).
        :param pulumi.Input[builtins.str] yaml: YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["description"] = description
        __props__.__dict__["git_details"] = git_details
        __props__.__dict__["git_import_info"] = git_import_info
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["import_from_git"] = import_from_git
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["pipeline_import_request"] = pipeline_import_request
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_applied"] = template_applied
        __props__.__dict__["template_applied_pipeline_yaml"] = template_applied_pipeline_yaml
        __props__.__dict__["yaml"] = yaml
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> pulumi.Output['outputs.PipelineGitDetails']:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @property
    @pulumi.getter(name="gitImportInfo")
    def git_import_info(self) -> pulumi.Output[Optional['outputs.PipelineGitImportInfo']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_info")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="pipelineImportRequest")
    def pipeline_import_request(self) -> pulumi.Output[Optional['outputs.PipelinePipelineImportRequest']]:
        """
        Contains parameters for importing a pipeline
        """
        return pulumi.get(self, "pipeline_import_request")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags to associate with the resource. These should match the tag value passed in the YAML; if this parameter is null or not passed, the tags specified in YAML should also be null.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateApplied")
    def template_applied(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, returns Pipeline YAML with Templates applied on it.
        """
        return pulumi.get(self, "template_applied")

    @property
    @pulumi.getter(name="templateAppliedPipelineYaml")
    def template_applied_pipeline_yaml(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Pipeline YAML after resolving Templates (returned as a String).
        """
        return pulumi.get(self, "template_applied_pipeline_yaml")

    @property
    @pulumi.getter
    def yaml(self) -> pulumi.Output[builtins.str]:
        """
        YAML of the pipeline. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

