# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 user_groups: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_bindings: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] email: The email of the user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_groups: The user group of the user.
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the user.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]] role_bindings: Role Bindings of the user. Cannot be updated.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "user_groups", user_groups)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role_bindings is not None:
            pulumi.set(__self__, "role_bindings", role_bindings)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The user group of the user.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "user_groups", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the user.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the user.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleBindings")
    def role_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]]:
        """
        Role Bindings of the user. Cannot be updated.
        """
        return pulumi.get(self, "role_bindings")

    @role_bindings.setter
    def role_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]]):
        pulumi.set(self, "role_bindings", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 externally_managed: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_bindings: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.bool] disabled: Whether or not the user account is disabled.
        :param pulumi.Input[builtins.str] email: The email of the user.
        :param pulumi.Input[builtins.bool] externally_managed: Whether or not the user account is externally managed.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the user.
        :param pulumi.Input[builtins.bool] locked: Whether or not the user account is locked.
        :param pulumi.Input[builtins.str] name: Name of the user.
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the user.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]] role_bindings: Role Bindings of the user. Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_groups: The user group of the user.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if externally_managed is not None:
            pulumi.set(__self__, "externally_managed", externally_managed)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role_bindings is not None:
            pulumi.set(__self__, "role_bindings", role_bindings)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the user account is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="externallyManaged")
    def externally_managed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the user account is externally managed.
        """
        return pulumi.get(self, "externally_managed")

    @externally_managed.setter
    def externally_managed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "externally_managed", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the user.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the user account is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization identifier of the user.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project identifier of the user.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleBindings")
    def role_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]]:
        """
        Role Bindings of the user. Cannot be updated.
        """
        return pulumi.get(self, "role_bindings")

    @role_bindings.setter
    def role_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleBindingArgs']]]]):
        pulumi.set(self, "role_bindings", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The user group of the user.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_groups", value)


@pulumi.type_token("harness:platform/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleBindingArgs', 'UserRoleBindingArgsDict']]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Import account level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>
        ```

        Import org level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>/<org_id>
        ```

        Import project level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>/<org_id>/<project_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: The email of the user.
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the user.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserRoleBindingArgs', 'UserRoleBindingArgsDict']]]] role_bindings: Role Bindings of the user. Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_groups: The user group of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Import account level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>
        ```

        Import org level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>/<org_id>
        ```

        Import project level

        ```sh
        $ pulumi import harness:platform/user:User john_doe <email_id>/<org_id>/<project_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleBindingArgs', 'UserRoleBindingArgsDict']]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["role_bindings"] = role_bindings
            if user_groups is None and not opts.urn:
                raise TypeError("Missing required property 'user_groups'")
            __props__.__dict__["user_groups"] = user_groups
            __props__.__dict__["disabled"] = None
            __props__.__dict__["externally_managed"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["name"] = None
        super(User, __self__).__init__(
            'harness:platform/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            externally_managed: Optional[pulumi.Input[builtins.bool]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            locked: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            role_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleBindingArgs', 'UserRoleBindingArgsDict']]]]] = None,
            user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] disabled: Whether or not the user account is disabled.
        :param pulumi.Input[builtins.str] email: The email of the user.
        :param pulumi.Input[builtins.bool] externally_managed: Whether or not the user account is externally managed.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the user.
        :param pulumi.Input[builtins.bool] locked: Whether or not the user account is locked.
        :param pulumi.Input[builtins.str] name: Name of the user.
        :param pulumi.Input[builtins.str] org_id: Organization identifier of the user.
        :param pulumi.Input[builtins.str] project_id: Project identifier of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserRoleBindingArgs', 'UserRoleBindingArgsDict']]]] role_bindings: Role Bindings of the user. Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_groups: The user group of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["email"] = email
        __props__.__dict__["externally_managed"] = externally_managed
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role_bindings"] = role_bindings
        __props__.__dict__["user_groups"] = user_groups
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not the user account is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="externallyManaged")
    def externally_managed(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not the user account is externally managed.
        """
        return pulumi.get(self, "externally_managed")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the user.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not the user account is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Organization identifier of the user.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Project identifier of the user.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="roleBindings")
    def role_bindings(self) -> pulumi.Output[Optional[Sequence['outputs.UserRoleBinding']]]:
        """
        Role Bindings of the user. Cannot be updated.
        """
        return pulumi.get(self, "role_bindings")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The user group of the user.
        """
        return pulumi.get(self, "user_groups")

