# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserGroupPermissionsInitArgs', 'UserGroupPermissions']

@pulumi.input_type
class UserGroupPermissionsInitArgs:
    def __init__(__self__, *,
                 user_group_id: pulumi.Input[builtins.str],
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_permissions: Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']] = None):
        """
        The set of arguments for constructing a UserGroupPermissions resource.
        :param pulumi.Input[builtins.str] user_group_id: Unique identifier of the user group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] account_permissions: The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        :param pulumi.Input['UserGroupPermissionsAppPermissionsArgs'] app_permissions: Application specific permissions
        """
        pulumi.set(__self__, "user_group_id", user_group_id)
        if account_permissions is not None:
            pulumi.set(__self__, "account_permissions", account_permissions)
        if app_permissions is not None:
            pulumi.set(__self__, "app_permissions", app_permissions)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the user group.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_group_id", value)

    @property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        """
        return pulumi.get(self, "account_permissions")

    @account_permissions.setter
    def account_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "account_permissions", value)

    @property
    @pulumi.getter(name="appPermissions")
    def app_permissions(self) -> Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']]:
        """
        Application specific permissions
        """
        return pulumi.get(self, "app_permissions")

    @app_permissions.setter
    def app_permissions(self, value: Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']]):
        pulumi.set(self, "app_permissions", value)


@pulumi.input_type
class _UserGroupPermissionsState:
    def __init__(__self__, *,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_permissions: Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserGroupPermissions resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] account_permissions: The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        :param pulumi.Input['UserGroupPermissionsAppPermissionsArgs'] app_permissions: Application specific permissions
        :param pulumi.Input[builtins.str] user_group_id: Unique identifier of the user group.
        """
        if account_permissions is not None:
            pulumi.set(__self__, "account_permissions", account_permissions)
        if app_permissions is not None:
            pulumi.set(__self__, "app_permissions", app_permissions)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        """
        return pulumi.get(self, "account_permissions")

    @account_permissions.setter
    def account_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "account_permissions", value)

    @property
    @pulumi.getter(name="appPermissions")
    def app_permissions(self) -> Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']]:
        """
        Application specific permissions
        """
        return pulumi.get(self, "app_permissions")

    @app_permissions.setter
    def app_permissions(self, value: Optional[pulumi.Input['UserGroupPermissionsAppPermissionsArgs']]):
        pulumi.set(self, "app_permissions", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the user group.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_group_id", value)


@pulumi.type_token("harness:index/userGroupPermissions:UserGroupPermissions")
class UserGroupPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_permissions: Optional[pulumi.Input[Union['UserGroupPermissionsAppPermissionsArgs', 'UserGroupPermissionsAppPermissionsArgsDict']]] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for adding permissions to an existing Harness user group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] account_permissions: The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        :param pulumi.Input[Union['UserGroupPermissionsAppPermissionsArgs', 'UserGroupPermissionsAppPermissionsArgsDict']] app_permissions: Application specific permissions
        :param pulumi.Input[builtins.str] user_group_id: Unique identifier of the user group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGroupPermissionsInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for adding permissions to an existing Harness user group.

        :param str resource_name: The name of the resource.
        :param UserGroupPermissionsInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGroupPermissionsInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_permissions: Optional[pulumi.Input[Union['UserGroupPermissionsAppPermissionsArgs', 'UserGroupPermissionsAppPermissionsArgsDict']]] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGroupPermissionsInitArgs.__new__(UserGroupPermissionsInitArgs)

            __props__.__dict__["account_permissions"] = account_permissions
            __props__.__dict__["app_permissions"] = app_permissions
            if user_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_group_id'")
            __props__.__dict__["user_group_id"] = user_group_id
        super(UserGroupPermissions, __self__).__init__(
            'harness:index/userGroupPermissions:UserGroupPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            app_permissions: Optional[pulumi.Input[Union['UserGroupPermissionsAppPermissionsArgs', 'UserGroupPermissionsAppPermissionsArgsDict']]] = None,
            user_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'UserGroupPermissions':
        """
        Get an existing UserGroupPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] account_permissions: The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        :param pulumi.Input[Union['UserGroupPermissionsAppPermissionsArgs', 'UserGroupPermissionsAppPermissionsArgsDict']] app_permissions: Application specific permissions
        :param pulumi.Input[builtins.str] user_group_id: Unique identifier of the user group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGroupPermissionsState.__new__(_UserGroupPermissionsState)

        __props__.__dict__["account_permissions"] = account_permissions
        __props__.__dict__["app_permissions"] = app_permissions
        __props__.__dict__["user_group_id"] = user_group_id
        return UserGroupPermissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        """
        return pulumi.get(self, "account_permissions")

    @property
    @pulumi.getter(name="appPermissions")
    def app_permissions(self) -> pulumi.Output[Optional['outputs.UserGroupPermissionsAppPermissions']]:
        """
        Application specific permissions
        """
        return pulumi.get(self, "app_permissions")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the user group.
        """
        return pulumi.get(self, "user_group_id")

