/*
 * Decompiled with CFR 0.152.
 */
package com.tecton.udfs.spark3;

import com.tecton.udfs.spark3.PercentileValue;
import com.tecton.udfs.spark3.TDigest;
import com.tecton.udfs.spark3.TDigestProcessed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.expressions.Aggregator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u001a\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/tecton/udfs/spark3/ApproxPercentilePartialAgg;", "Lorg/apache/spark/sql/expressions/Aggregator;", "Lcom/tecton/udfs/spark3/PercentileValue;", "Lcom/tecton/udfs/spark3/TDigest;", "Lcom/tecton/udfs/spark3/TDigestProcessed;", "compression", "", "(I)V", "getCompression", "()I", "bufferEncoder", "Lorg/apache/spark/sql/Encoder;", "finish", "tDigest", "merge", "tDigest1", "tDigest2", "outputEncoder", "reduce", "percentileValue", "zero", "java_com_tecton_udfs_spark3-tecton-udfs-lib"})
public final class ApproxPercentilePartialAgg
extends Aggregator<PercentileValue, TDigest, TDigestProcessed> {
    private final int compression;

    public ApproxPercentilePartialAgg(int compression) {
        this.compression = compression;
    }

    public final int getCompression() {
        return this.compression;
    }

    @NotNull
    public TDigest zero() {
        return new TDigest();
    }

    @NotNull
    public Encoder<TDigest> bufferEncoder() {
        Encoder encoder = Encoders.bean(TDigest.class);
        Intrinsics.checkNotNullExpressionValue(encoder, "bean(...)");
        return encoder;
    }

    @NotNull
    public Encoder<TDigestProcessed> outputEncoder() {
        Encoder encoder = Encoders.bean(TDigestProcessed.class);
        Intrinsics.checkNotNullExpressionValue(encoder, "bean(...)");
        return encoder;
    }

    @NotNull
    public TDigest reduce(@NotNull TDigest tDigest, @Nullable PercentileValue percentileValue) {
        Intrinsics.checkNotNullParameter(tDigest, "tDigest");
        if (percentileValue == null) {
            return tDigest;
        }
        if (percentileValue.getValue() == null) {
            return tDigest;
        }
        Double d = percentileValue.getValue();
        Intrinsics.checkNotNull(d);
        tDigest.addUnprocessed(d, 1.0, this.compression);
        return tDigest;
    }

    @NotNull
    public TDigest merge(@NotNull TDigest tDigest1, @NotNull TDigest tDigest2) {
        Intrinsics.checkNotNullParameter(tDigest1, "tDigest1");
        Intrinsics.checkNotNullParameter(tDigest2, "tDigest2");
        return tDigest1.merge(tDigest2, this.compression);
    }

    @NotNull
    public TDigestProcessed finish(@NotNull TDigest tDigest) {
        Intrinsics.checkNotNullParameter(tDigest, "tDigest");
        tDigest.finish(this.compression);
        return new TDigestProcessed(tDigest.currentProcessedMeans(), tDigest.currentProcessedWeights());
    }
}

