// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.packages', ['core']);

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('core').config(function($routeProvider) {
    return $routeProvider.when('/view/packages/:managerId', {
      templateUrl: '/packages:resources/partial/index.html',
      controller: 'PackagesIndexController'
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.packages').controller('PackagesIndexController', function($scope, $routeParams, $location, notify, pageTitle, urlPrefix, packages, terminals, gettext) {
    pageTitle.set(gettext('Packages'));
    $scope.managerId = $routeParams.managerId;
    $scope.searchQuery = '';
    $scope.results = [];
    $scope.selection = [];
    $scope.selectionVisible = false;
    $scope.$watch('searchQuery', function() {
      if ($scope.searchQuery.length < 3) {
        return;
      }
      $scope.results = null;
      return packages.list($scope.managerId, $scope.searchQuery).then(function(data) {
        return $scope.results = data;
      })["catch"](function(err) {
        notify.error(gettext('Could not find packages'), err.message);
        return $scope.results = [];
      });
    });
    $scope.updateLists = function() {
      return packages.updateLists($scope.managerId).then(function(data) {
        return notify.info(gettext('Package list update started'));
      })["catch"](function(err) {
        return notify.error(gettext('Package list update failed'), err.message);
      });
    };
    $scope.mark = function(pkg, op) {
      var sel, _i, _len, _ref;
      _ref = $scope.selection;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        sel = _ref[_i];
        if (sel["package"].id === pkg.id) {
          $scope.selection.remove(sel);
        }
      }
      return $scope.selection.push({
        "package": pkg,
        operation: op
      });
    };
    $scope.markForInstallation = function(pkg) {
      return $scope.mark(pkg, 'install');
    };
    $scope.markForUpgrade = function(pkg) {
      return $scope.mark(pkg, 'upgrade');
    };
    $scope.markForRemoval = function(pkg) {
      return $scope.mark(pkg, 'remove');
    };
    $scope.showSelection = function() {
      return $scope.selectionVisible = true;
    };
    $scope.hideSelection = function() {
      return $scope.selectionVisible = false;
    };
    return $scope.doApply = function() {
      return packages.applySelection($scope.managerId, $scope.selection).then(function(data) {
        var cmd;
        $scope.selection = [];
        cmd = data.terminalCommand;
        return terminals.create({
          command: cmd,
          autoclose: true
        }).then(function(id) {
          return $location.path("" + urlPrefix + "/view/terminal/" + id);
        });
      })["catch"](function() {
        return notify.error(gettext('Could not apply changes'));
      });
    };
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.packages').service('packages', function($http, $q, tasks) {
    this.getManagers = function() {
      var q;
      q = $q.defer();
      $http.get("/api/packages/managers").success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    this.list = function(managerId, query) {
      var q;
      q = $q.defer();
      $http.get("/api/packages/list/" + managerId + "?query=" + query).success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    this.get = function(managerId, packageId) {
      var q;
      q = $q.defer();
      $http.get("/api/packages/get/" + managerId + "/" + packageId).success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    this.updateLists = function(managerId) {
      var q;
      q = $q.defer();
      tasks.start('aj.plugins.packages.tasks.UpdateLists', [], {
        manager_id: managerId
      }).then(function(data) {
        return q.resolve(data);
      })["catch"](function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    this.applySelection = function(managerId, selection) {
      var q;
      q = $q.defer();
      $http.post("/api/packages/apply/" + managerId, selection).success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    return this;
  });

}).call(this);

