# coding: utf-8

"""
    RCS Rest API 1.0

    IDEA StatiCa RCS API, used for the automated design and calculation of reinforced concrete sections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_rcs_api.models.check_result_type import CheckResultType
from ideastatica_rcs_api.models.concrete_check_result_base import ConcreteCheckResultBase
from typing import Optional, Set
from typing_extensions import Self

class ConcreteCheckResult(BaseModel):
    """
    Concrete Check results
    """ # noqa: E501
    result_type: Optional[CheckResultType] = Field(default=None, alias="resultType")
    check_results: Optional[List[ConcreteCheckResultBase]] = Field(default=None, description="All results - first is extreme", alias="checkResults")
    __properties: ClassVar[List[str]] = ["resultType", "checkResults"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConcreteCheckResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in check_results (list)
        _items = []
        if self.check_results:
            for _item_check_results in self.check_results:
                if _item_check_results:
                    _items.append(_item_check_results.to_dict())
            _dict['checkResults'] = _items
        # set to None if check_results (nullable) is None
        # and model_fields_set contains the field
        if self.check_results is None and "check_results" in self.model_fields_set:
            _dict['checkResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConcreteCheckResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resultType": obj.get("resultType"),
            "checkResults": [ConcreteCheckResultBase.from_dict(_item) for _item in obj["checkResults"]] if obj.get("checkResults") is not None else None
        })
        return _obj


