# coding: utf-8

"""
    RCS Rest API 1.0

    IDEA StatiCa RCS API, used for the automated design and calculation of reinforced concrete sections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from ideastatica_rcs_api.models.calculation_type import CalculationType
from ideastatica_rcs_api.models.check_result import CheckResult
from ideastatica_rcs_api.models.non_conformity import NonConformity
from ideastatica_rcs_api.models.result_of_internal_forces import ResultOfInternalForces
from typing import Optional, Set
from typing_extensions import Self

class ConcreteCheckResultBase(BaseModel):
    """
    Concrete result base class
    """ # noqa: E501
    internal_fores: Optional[ResultOfInternalForces] = Field(default=None, alias="internalFores")
    non_conformities: Optional[List[NonConformity]] = Field(default=None, description="Returns nonconformity in section", alias="nonConformities")
    result: Optional[CheckResult] = None
    check_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="calculated limited value, calculated as strain to limit strain", alias="checkValue")
    limit_check_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="limit check value for result check", alias="limitCheckValue")
    check: Optional[CalculationType] = None
    __properties: ClassVar[List[str]] = ["internalFores", "nonConformities", "result", "checkValue", "limitCheckValue", "check"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConcreteCheckResultBase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of internal_fores
        if self.internal_fores:
            _dict['internalFores'] = self.internal_fores.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in non_conformities (list)
        _items = []
        if self.non_conformities:
            for _item_non_conformities in self.non_conformities:
                if _item_non_conformities:
                    _items.append(_item_non_conformities.to_dict())
            _dict['nonConformities'] = _items
        # set to None if non_conformities (nullable) is None
        # and model_fields_set contains the field
        if self.non_conformities is None and "non_conformities" in self.model_fields_set:
            _dict['nonConformities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConcreteCheckResultBase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "internalFores": ResultOfInternalForces.from_dict(obj["internalFores"]) if obj.get("internalFores") is not None else None,
            "nonConformities": [NonConformity.from_dict(_item) for _item in obj["nonConformities"]] if obj.get("nonConformities") is not None else None,
            "result": obj.get("result"),
            "checkValue": obj.get("checkValue"),
            "limitCheckValue": obj.get("limitCheckValue"),
            "check": obj.get("check")
        })
        return _obj


