# coding: utf-8

"""
    RCS Rest API 1.0

    IDEA StatiCa RCS API, used for the automated design and calculation of reinforced concrete sections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_rcs_api.models.rcs_check_member import RcsCheckMember
from ideastatica_rcs_api.models.rcs_project_data import RcsProjectData
from ideastatica_rcs_api.models.rcs_reinforced_cross_section import RcsReinforcedCrossSection
from ideastatica_rcs_api.models.rcs_section import RcsSection
from typing import Optional, Set
from typing_extensions import Self

class RcsProject(BaseModel):
    """
    RcsProject
    """ # noqa: E501
    sections: Optional[List[RcsSection]] = None
    check_members: Optional[List[RcsCheckMember]] = Field(default=None, alias="checkMembers")
    reinforced_cross_sections: Optional[List[RcsReinforcedCrossSection]] = Field(default=None, alias="reinforcedCrossSections")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    project_data: Optional[RcsProjectData] = Field(default=None, alias="projectData")
    __properties: ClassVar[List[str]] = ["sections", "checkMembers", "reinforcedCrossSections", "projectId", "projectData"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RcsProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sections (list)
        _items = []
        if self.sections:
            for _item_sections in self.sections:
                if _item_sections:
                    _items.append(_item_sections.to_dict())
            _dict['sections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in check_members (list)
        _items = []
        if self.check_members:
            for _item_check_members in self.check_members:
                if _item_check_members:
                    _items.append(_item_check_members.to_dict())
            _dict['checkMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reinforced_cross_sections (list)
        _items = []
        if self.reinforced_cross_sections:
            for _item_reinforced_cross_sections in self.reinforced_cross_sections:
                if _item_reinforced_cross_sections:
                    _items.append(_item_reinforced_cross_sections.to_dict())
            _dict['reinforcedCrossSections'] = _items
        # override the default output from pydantic by calling `to_dict()` of project_data
        if self.project_data:
            _dict['projectData'] = self.project_data.to_dict()
        # set to None if sections (nullable) is None
        # and model_fields_set contains the field
        if self.sections is None and "sections" in self.model_fields_set:
            _dict['sections'] = None

        # set to None if check_members (nullable) is None
        # and model_fields_set contains the field
        if self.check_members is None and "check_members" in self.model_fields_set:
            _dict['checkMembers'] = None

        # set to None if reinforced_cross_sections (nullable) is None
        # and model_fields_set contains the field
        if self.reinforced_cross_sections is None and "reinforced_cross_sections" in self.model_fields_set:
            _dict['reinforcedCrossSections'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RcsProject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sections": [RcsSection.from_dict(_item) for _item in obj["sections"]] if obj.get("sections") is not None else None,
            "checkMembers": [RcsCheckMember.from_dict(_item) for _item in obj["checkMembers"]] if obj.get("checkMembers") is not None else None,
            "reinforcedCrossSections": [RcsReinforcedCrossSection.from_dict(_item) for _item in obj["reinforcedCrossSections"]] if obj.get("reinforcedCrossSections") is not None else None,
            "projectId": obj.get("projectId"),
            "projectData": RcsProjectData.from_dict(obj["projectData"]) if obj.get("projectData") is not None else None
        })
        return _obj


