# coding: utf-8

"""
    RCS Rest API 1.0

    IDEA StatiCa RCS API, used for the automated design and calculation of reinforced concrete sections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RcsProjectData(BaseModel):
    """
    RcsProjectData
    """ # noqa: E501
    project_name: Optional[StrictStr] = Field(default=None, alias="projectName")
    date_of_create: Optional[datetime] = Field(default=None, alias="dateOfCreate")
    description: Optional[StrictStr] = None
    author: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    project_no: Optional[StrictStr] = Field(default=None, alias="projectNo")
    type_bridge: Optional[StrictStr] = Field(default=None, alias="typeBridge")
    type_of_structure: Optional[StrictStr] = Field(default=None, alias="typeOfStructure")
    fire_resistance_check: Optional[StrictBool] = Field(default=None, alias="fireResistanceCheck")
    __properties: ClassVar[List[str]] = ["projectName", "dateOfCreate", "description", "author", "code", "projectNo", "typeBridge", "typeOfStructure", "fireResistanceCheck"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RcsProjectData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if project_name (nullable) is None
        # and model_fields_set contains the field
        if self.project_name is None and "project_name" in self.model_fields_set:
            _dict['projectName'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if project_no (nullable) is None
        # and model_fields_set contains the field
        if self.project_no is None and "project_no" in self.model_fields_set:
            _dict['projectNo'] = None

        # set to None if type_bridge (nullable) is None
        # and model_fields_set contains the field
        if self.type_bridge is None and "type_bridge" in self.model_fields_set:
            _dict['typeBridge'] = None

        # set to None if type_of_structure (nullable) is None
        # and model_fields_set contains the field
        if self.type_of_structure is None and "type_of_structure" in self.model_fields_set:
            _dict['typeOfStructure'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RcsProjectData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "projectName": obj.get("projectName"),
            "dateOfCreate": obj.get("dateOfCreate"),
            "description": obj.get("description"),
            "author": obj.get("author"),
            "code": obj.get("code"),
            "projectNo": obj.get("projectNo"),
            "typeBridge": obj.get("typeBridge"),
            "typeOfStructure": obj.get("typeOfStructure"),
            "fireResistanceCheck": obj.get("fireResistanceCheck")
        })
        return _obj


