# coding: utf-8

"""
    RCS Rest API 1.0

    IDEA StatiCa RCS API, used for the automated design and calculation of reinforced concrete sections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_rcs_api.models.non_conformity_issue import NonConformityIssue
from ideastatica_rcs_api.models.section_concrete_check_result import SectionConcreteCheckResult
from typing import Optional, Set
from typing_extensions import Self

class RcsSectionResultDetailed(BaseModel):
    """
    RcsSectionResultDetailed
    """ # noqa: E501
    id: Optional[StrictInt] = None
    section_result: Optional[SectionConcreteCheckResult] = Field(default=None, alias="sectionResult")
    issues: Optional[List[NonConformityIssue]] = None
    __properties: ClassVar[List[str]] = ["id", "sectionResult", "issues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RcsSectionResultDetailed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of section_result
        if self.section_result:
            _dict['sectionResult'] = self.section_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        # set to None if issues (nullable) is None
        # and model_fields_set contains the field
        if self.issues is None and "issues" in self.model_fields_set:
            _dict['issues'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RcsSectionResultDetailed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "sectionResult": SectionConcreteCheckResult.from_dict(obj["sectionResult"]) if obj.get("sectionResult") is not None else None,
            "issues": [NonConformityIssue.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None
        })
        return _obj


