

DEFAULT_CONFIG = {
    'Global': {
        'char_only': False,
        'recognition_only': False,
        'skip_line_detection': False,
        'single_model_training': None,
        'wandb_project': None,
        'hf_username_for_upload': None,
        'hf_token_for_upload': None,
        'min_word_sim': 0.8
    },
    'Recognizer': {
        'char': {
            'model_dir': './char_model',
            'model_backend': 'timm',
            'timm_model_name': 'mobilenetv3_small_050.lamb_in1k',
            'hf_repo_id': None,
            'num_cores': None,
            'providers': None,
            'device': 'cpu',
            'training': {
                'render_dict': None,
                'font_dir_path': None,
                'hns_txt_path': None,
                'ready_to_go_data_dir_path': None,
                'train_set_from_coco_json': None,
                'val_set_from_coco_json': None,
                'test_set_from_coco_json': None,
                'train_val_test_split': [0.7, 0.15, 0.15],
                'batch_size': 128,
                'num_epochs': 10,
                'num_passes': 1,
                'start_epoch': 1,
                'char_trans_version': 2,
                'dec_lr_factor': 0.9,
                'expansion_factor': 1,
                'hardneg_k': 8,
                'imsize': 224,
                'lr': 0.002,
                'm': 4,
                'adamw_beta1': 0.9, 
                'adamw_beta2': 0.999,
                'temp': 0.1,
                'weight_decay': 0.0005,
                'epoch_viz_dir': None,
                'few_shot': None,
                'int_eval_steps': None,
                'ascender': True,
                'aug_paired': False,
                'char_only_sampler': False,
                'diff_sizes': False,
                'finetune': False,
                'high_blur': False,
                'latin_suggested_augs': True,
                'lr_schedule': False,
                'no_aug': False,
                'pretrain': False,
                'test_at_end': True,
                'default_font_name': 'Noto',
            }
        },
        'word': {
            'model_dir': './word_model',
            'model_backend': 'timm',
            'timm_model_name': 'mobilenetv3_small_050.lamb_in1k',
            'hf_repo_id': None,
            'num_cores': None,
            'providers': None,
            'device': 'cpu',
            'training': {
                'render_dict': None,
                'font_dir_path': None,
                'hns_txt_path': None,
                'ready_to_go_data_dir_path': None,
                'train_set_from_coco_json': None,
                'val_set_from_coco_json': None,
                'test_set_from_coco_json': None,
                'train_val_test_split': [0.7, 0.15, 0.15],
                'batch_size': 128,
                'num_epochs': 10,
                'num_passes': 1,
                'start_epoch': 1,
                'char_trans_version': 2,
                'dec_lr_factor': 0.9,
                'expansion_factor': 1,
                'hardneg_k': 8,
                'imsize': 224,
                'lr': 0.002,
                'm': 4,
                'adamw_beta1': 0.9, 
                'adamw_beta2': 0.999,
                'temp': 0.1,
                'weight_decay': 0.0005,
                'epoch_viz_dir': None,
                'few_shot': None,
                'int_eval_steps': None,
                'ascender': True,
                'aug_paired': False,
                'char_only_sampler': False,
                'diff_sizes': False,
                'finetune': False,
                'high_blur': False,
                'latin_suggested_augs': True,
                'lr_schedule': False,
                'no_aug': False,
                'pretrain': False,
                'test_at_end': True,
                'default_font_name': 'Noto',
            },
        },
    },
    'Localizer': {
        'model_dir': './localizer_model',
        'model_backend': 'yolov5',
        'device': 'cpu',
        'vertical': False,
        'hf_repo_id': None,
        'mmdet_config': None,
        'num_cores': None,
        'providers': None,
        'visualize': None,
        'training': {
            'training_data_dir': None,
            'batch_size': 16,
            'conf_thresh': 0.25,
            'epochs': 10,
            'input_shape': [640, 640],
            'iou_thresh': 0.1,
            'max_det': 200,
            'device': 'cpu'
        }
    },
    'Line': {
        'model_dir': './line_model',
        'model_backend': 'yolov5',
        'device': 'cpu',
        'hf_repo_id': None,
        'num_cores': None,
        'onnx': None,
        'providers': None,
        'visualize': None,
        'training': {
            'training_data_dir': None,
            'batch_size': 16,
            'conf_thresh': 0.2,
            'epochs': 10,
            'input_shape': [640, 640],
            'iou_thresh': 0.15,
            'max_det': 200,
            'min_seg_ratio': 2,
            'device': 'cpu'
        }
    },
}

