import { ITable } from '@aws-cdk/aws-dynamodb';
import { IGrantable, IPrincipal, IRole } from '@aws-cdk/aws-iam';
import { IFunction } from '@aws-cdk/aws-lambda';
import { IDatabaseCluster } from '@aws-cdk/aws-rds';
import { ISecret } from '@aws-cdk/aws-secretsmanager';
import { IResolvable } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BaseAppsyncFunctionProps, AppsyncFunction } from './appsync-function';
import { CfnDataSource } from './appsync.generated';
import { IGraphqlApi } from './graphqlapi-base';
import { BaseResolverProps, Resolver } from './resolver';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Base properties for an AppSync datasource.
 *
 * @experimental
 */
export interface BaseDataSourceProps {
    /**
     * (experimental) The API to attach this data source to.
     *
     * @experimental
     */
    readonly api: IGraphqlApi;
    /**
     * (experimental) The name of the data source.
     *
     * @default - id of data source
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) the description of the data source.
     *
     * @default - None
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) properties for an AppSync datasource backed by a resource.
 *
 * @experimental
 */
export interface BackedDataSourceProps extends BaseDataSourceProps {
    /**
     * (experimental) The IAM service role to be assumed by AppSync to interact with the data source.
     *
     * @default -  Create a new role
     * @experimental
     */
    readonly serviceRole?: IRole;
}
/**
 * (experimental) props used by implementations of BaseDataSource to provide configuration.
 *
 * Should not be used directly.
 *
 * @experimental
 */
export interface ExtendedDataSourceProps {
    /**
     * (experimental) the type of the AppSync datasource.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) configuration for DynamoDB Datasource.
     *
     * @default - No config
     * @experimental
     */
    readonly dynamoDbConfig?: CfnDataSource.DynamoDBConfigProperty | IResolvable;
    /**
     * (experimental) configuration for Elasticsearch Datasource.
     *
     * @default - No config
     * @experimental
     */
    readonly elasticsearchConfig?: CfnDataSource.ElasticsearchConfigProperty | IResolvable;
    /**
     * (experimental) configuration for HTTP Datasource.
     *
     * @default - No config
     * @experimental
     */
    readonly httpConfig?: CfnDataSource.HttpConfigProperty | IResolvable;
    /**
     * (experimental) configuration for Lambda Datasource.
     *
     * @default - No config
     * @experimental
     */
    readonly lambdaConfig?: CfnDataSource.LambdaConfigProperty | IResolvable;
    /**
     * (experimental) configuration for RDS Datasource.
     *
     * @default - No config
     * @experimental
     */
    readonly relationalDatabaseConfig?: CfnDataSource.RelationalDatabaseConfigProperty | IResolvable;
}
/**
 * (experimental) Abstract AppSync datasource implementation.
 *
 * Do not use directly but use subclasses for concrete datasources
 *
 * @experimental
 */
export declare abstract class BaseDataSource extends CoreConstruct {
    /**
     * (experimental) the name of the data source.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the underlying CFN data source resource.
     *
     * @experimental
     */
    readonly ds: CfnDataSource;
    /**
     * @experimental
     */
    protected api: IGraphqlApi;
    /**
     * @experimental
     */
    protected serviceRole?: IRole;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BackedDataSourceProps, extended: ExtendedDataSourceProps);
    /**
     * (experimental) creates a new resolver for this datasource and API using the given properties.
     *
     * @experimental
     */
    createResolver(props: BaseResolverProps): Resolver;
    /**
     * (experimental) creates a new appsync function for this datasource and API using the given properties.
     *
     * @experimental
     */
    createFunction(props: BaseAppsyncFunctionProps): AppsyncFunction;
}
/**
 * (experimental) Abstract AppSync datasource implementation.
 *
 * Do not use directly but use subclasses for resource backed datasources
 *
 * @experimental
 */
export declare abstract class BackedDataSource extends BaseDataSource implements IGrantable {
    /**
     * (experimental) the principal of the data source to be IGrantable.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BackedDataSourceProps, extended: ExtendedDataSourceProps);
}
/**
 * (experimental) Properties for an AppSync dummy datasource.
 *
 * @experimental
 */
export interface NoneDataSourceProps extends BaseDataSourceProps {
}
/**
 * (experimental) An AppSync dummy datasource.
 *
 * @experimental
 */
export declare class NoneDataSource extends BaseDataSource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NoneDataSourceProps);
}
/**
 * (experimental) Properties for an AppSync DynamoDB datasource.
 *
 * @experimental
 */
export interface DynamoDbDataSourceProps extends BackedDataSourceProps {
    /**
     * (experimental) The DynamoDB table backing this data source.
     *
     * @experimental
     */
    readonly table: ITable;
    /**
     * (experimental) Specify whether this DS is read only or has read and write permissions to the DynamoDB table.
     *
     * @default false
     * @experimental
     */
    readonly readOnlyAccess?: boolean;
    /**
     * (experimental) use credentials of caller to access DynamoDB.
     *
     * @default false
     * @experimental
     */
    readonly useCallerCredentials?: boolean;
}
/**
 * (experimental) An AppSync datasource backed by a DynamoDB table.
 *
 * @experimental
 */
export declare class DynamoDbDataSource extends BackedDataSource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DynamoDbDataSourceProps);
}
/**
 * (experimental) The authorization config in case the HTTP endpoint requires authorization.
 *
 * @experimental
 */
export interface AwsIamConfig {
    /**
     * (experimental) The signing region for AWS IAM authorization.
     *
     * @experimental
     */
    readonly signingRegion: string;
    /**
     * (experimental) The signing service name for AWS IAM authorization.
     *
     * @experimental
     */
    readonly signingServiceName: string;
}
/**
 * (experimental) Properties for an AppSync http datasource.
 *
 * @experimental
 */
export interface HttpDataSourceProps extends BaseDataSourceProps {
    /**
     * (experimental) The http endpoint.
     *
     * @experimental
     */
    readonly endpoint: string;
    /**
     * (experimental) The authorization config in case the HTTP endpoint requires authorization.
     *
     * @default - none
     * @experimental
     */
    readonly authorizationConfig?: AwsIamConfig;
}
/**
 * (experimental) An AppSync datasource backed by a http endpoint.
 *
 * @experimental
 */
export declare class HttpDataSource extends BackedDataSource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpDataSourceProps);
}
/**
 * (experimental) Properties for an AppSync Lambda datasource.
 *
 * @experimental
 */
export interface LambdaDataSourceProps extends BackedDataSourceProps {
    /**
     * (experimental) The Lambda function to call to interact with this data source.
     *
     * @experimental
     */
    readonly lambdaFunction: IFunction;
}
/**
 * (experimental) An AppSync datasource backed by a Lambda function.
 *
 * @experimental
 */
export declare class LambdaDataSource extends BackedDataSource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LambdaDataSourceProps);
}
/**
 * (experimental) Properties for an AppSync RDS datasource.
 *
 * @experimental
 */
export interface RdsDataSourceProps extends BackedDataSourceProps {
    /**
     * (experimental) The database cluster to call to interact with this data source.
     *
     * @experimental
     */
    readonly databaseCluster: IDatabaseCluster;
    /**
     * (experimental) The secret containing the credentials for the database.
     *
     * @experimental
     */
    readonly secretStore: ISecret;
}
/**
 * (experimental) An AppSync datasource backed by RDS.
 *
 * @experimental
 */
export declare class RdsDataSource extends BackedDataSource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RdsDataSourceProps);
}
