import { CfnGraphQLSchema } from './appsync.generated';
import { GraphqlApi } from './graphqlapi';
import { IIntermediateType } from './schema-base';
import { ResolvableField } from './schema-field';
import { ObjectType } from './schema-intermediate';
/**
 * (experimental) The options for configuring a schema.
 *
 * If no options are specified, then the schema will
 * be generated code-first.
 *
 * @experimental
 */
export interface SchemaOptions {
    /**
     * (experimental) The file path for the schema.
     *
     * When this option is
     * configured, then the schema will be generated from an
     * existing file from disk.
     *
     * @default - schema not configured through disk asset
     * @experimental
     */
    readonly filePath?: string;
}
/**
 * (experimental) The Schema for a GraphQL Api.
 *
 * If no options are configured, schema will be generated
 * code-first.
 *
 * @experimental
 */
export declare class Schema {
    /**
     * (experimental) Generate a Schema from file.
     *
     * @param filePath the file path of the schema file.
     * @returns `SchemaAsset` with immutable schema defintion
     * @experimental
     */
    static fromAsset(filePath: string): Schema;
    /**
     * (experimental) The definition for this schema.
     *
     * @experimental
     */
    definition: string;
    private query?;
    private mutation?;
    private subscription?;
    private schema?;
    private mode;
    private types;
    /**
     * @experimental
     */
    constructor(options?: SchemaOptions);
    /**
     * (experimental) Called when the GraphQL Api is initialized to allow this object to bind to the stack.
     *
     * @param api The binding GraphQL Api.
     * @experimental
     */
    bind(api: GraphqlApi): CfnGraphQLSchema;
    /**
     * (experimental) Escape hatch to add to Schema as desired.
     *
     * Will always result
     * in a newline.
     *
     * @param addition the addition to add to schema.
     * @param delimiter the delimiter between schema and addition.
     * @default - ''
     * @experimental
     */
    addToSchema(addition: string, delimiter?: string): void;
    /**
     * (experimental) Add a query field to the schema's Query. CDK will create an Object Type called 'Query'. For example,.
     *
     * type Query {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the query.
     * @param field the resolvable field to for this query.
     * @experimental
     */
    addQuery(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * (experimental) Add a mutation field to the schema's Mutation. CDK will create an Object Type called 'Mutation'. For example,.
     *
     * type Mutation {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Mutation.
     * @param field the resolvable field to for this Mutation.
     * @experimental
     */
    addMutation(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * (experimental) Add a subscription field to the schema's Subscription. CDK will create an Object Type called 'Subscription'. For example,.
     *
     * type Subscription {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Subscription.
     * @param field the resolvable field to for this Subscription.
     * @experimental
     */
    addSubscription(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * (experimental) Add type to the schema.
     *
     * @param type the intermediate type to add to the schema.
     * @experimental
     */
    addType(type: IIntermediateType): IIntermediateType;
    /**
     * Set the root types of this schema if they are defined.
     *
     * For example:
     * schema {
     *   query: Query
     *   mutation: Mutation
     *   subscription: Subscription
     * }
     */
    private declareSchema;
}
