# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

if TYPE_CHECKING:
    from earnix_elevate.clients.data.models.add_dataset_data_table_node_request import (
        AddDatasetDataTableNodeRequest,
    )
    from earnix_elevate.clients.data.models.add_dataset_recipe_node_request import (
        AddDatasetRecipeNodeRequest,
    )


class AddDatasetNodeRequest(BaseModel):
    """
    `AddDatasetNodeRequest`
    """

    node_type: StrictStr = Field(
        default=...,
        alias="nodeType",
        description="Type of node in the transformation graph (TABLE for DataTable references, RECIPE for transformation logic)",
    )
    dataset_id: StrictInt = Field(
        default=...,
        alias="datasetId",
        description="Unique identifier of the Dataset that contains this node",
    )
    __properties = ["nodeType", "datasetId"]

    @validator("node_type")
    def node_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "TABLE",
            "RECIPE",
        ):
            raise ValueError("must be one of enum values ('TABLE', 'RECIPE')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "nodeType"

    # discriminator mappings
    __discriminator_value_class_map = {
        "RECIPE": "AddDatasetRecipeNodeRequest",
        "TABLE": "AddDatasetDataTableNodeRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[AddDatasetDataTableNodeRequest, AddDatasetRecipeNodeRequest]:
        """Create an instance of AddDatasetNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[AddDatasetDataTableNodeRequest, AddDatasetRecipeNodeRequest]:
        """Create an instance of AddDatasetNodeRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "AddDatasetRecipeNodeRequest":
            return import_module(
                "earnix_elevate.clients.data.models.add_dataset_recipe_node_request"
            ).AddDatasetRecipeNodeRequest.from_dict(obj)
        if object_type == "AddDatasetDataTableNodeRequest":
            return import_module(
                "earnix_elevate.clients.data.models.add_dataset_data_table_node_request"
            ).AddDatasetDataTableNodeRequest.from_dict(obj)
        raise ValueError(
            "AddDatasetNodeRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
