# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr


class ConnectionDetailsResponse(BaseModel):
    """
    `ConnectionDetailsResponse`

    Details about the connection configuration used by a DataTable to access its associated DataSource
    """

    connection_id: Optional[StrictInt] = Field(
        default=None,
        alias="connectionId",
        description="Unique identifier of the connection used by this DataTable",
    )
    data_source_id: Optional[StrictInt] = Field(
        default=None,
        alias="dataSourceId",
        description="Unique identifier of the DataSource configuration",
    )
    connection_name: Optional[StrictStr] = Field(
        default=None,
        alias="connectionName",
        description="Human-readable name of the connection",
    )
    connection_type: Optional[StrictStr] = Field(
        default=None,
        alias="connectionType",
        description="Type of connection (e.g., S3, Snowflake, etc.)",
    )
    __properties = ["connectionId", "dataSourceId", "connectionName", "connectionType"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConnectionDetailsResponse:
        """Create an instance of ConnectionDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConnectionDetailsResponse:
        """Create an instance of ConnectionDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConnectionDetailsResponse.parse_obj(obj)

        _obj = ConnectionDetailsResponse.parse_obj(
            {
                "connection_id": obj.get("connectionId"),
                "data_source_id": obj.get("dataSourceId"),
                "connection_name": obj.get("connectionName"),
                "connection_type": obj.get("connectionType"),
            }
        )
        return _obj
