# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr, validator


class ConversationMessageResponse(BaseModel):
    """
    `ConversationMessageResponse`

    Represents a single message within a conversation in the AI assistant service, containing the message content, author, and timestamp
    """

    conversation_id: Optional[StrictStr] = Field(
        default=None,
        alias="conversationId",
        description="Unique identifier for the containing conversation",
    )
    type: Optional[StrictStr] = Field(
        default=None, description="Type of the message in LLM chat"
    )
    content: Optional[StrictStr] = Field(
        default=None, description="Content of the message"
    )
    timestamp: Optional[datetime] = Field(
        default=None, description="Date and time when the message was sent"
    )
    __properties = ["conversationId", "type", "content", "timestamp"]

    @validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "SYSTEM",
            "USER",
            "ASSISTANT",
            "TOOL",
        ):
            raise ValueError(
                "must be one of enum values ('SYSTEM', 'USER', 'ASSISTANT', 'TOOL')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConversationMessageResponse:
        """Create an instance of ConversationMessageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConversationMessageResponse:
        """Create an instance of ConversationMessageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConversationMessageResponse.parse_obj(obj)

        _obj = ConversationMessageResponse.parse_obj(
            {
                "conversation_id": obj.get("conversationId"),
                "type": obj.get("type"),
                "content": obj.get("content"),
                "timestamp": obj.get("timestamp"),
            }
        )
        return _obj
