# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictInt

from earnix_elevate.clients.data.models.data_version_status_response import (
    DataVersionStatusResponse,
)
from earnix_elevate.clients.data.models.metadata_response import MetadataResponse
from earnix_elevate.clients.data.models.user_response import UserResponse


class DataVersionResponse(BaseModel):
    """
    `DataVersionResponse`

    Represents a specific version of data within a DataTable. Each version contains imported data from the associated DataSource along with processing status, metadata, and schema information
    """

    data_table_id: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableId",
        description="Unique identifier of the DataTable that contains this data version",
    )
    version_number: Optional[StrictInt] = Field(
        default=None,
        alias="versionNumber",
        description="Sequential version number of this data within the DataTable",
    )
    status: Optional[DataVersionStatusResponse] = None
    metadata: Optional[MetadataResponse] = None
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="Date and time when this entity was created",
    )
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="Date and time when this entity was last modified",
    )
    __properties = [
        "dataTableId",
        "versionNumber",
        "status",
        "metadata",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataVersionResponse:
        """Create an instance of DataVersionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict["metadata"] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataVersionResponse:
        """Create an instance of DataVersionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataVersionResponse.parse_obj(obj)

        _obj = DataVersionResponse.parse_obj(
            {
                "data_table_id": obj.get("dataTableId"),
                "version_number": obj.get("versionNumber"),
                "status": DataVersionStatusResponse.from_dict(obj.get("status"))
                if obj.get("status") is not None
                else None,
                "metadata": MetadataResponse.from_dict(obj.get("metadata"))
                if obj.get("metadata") is not None
                else None,
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
            }
        )
        return _obj
