# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, StrictInt, conlist

from earnix_elevate.clients.data.models.data_version_response import DataVersionResponse
from earnix_elevate.clients.data.models.dataset_node_response import DatasetNodeResponse


class DatasetDataTableNodeResponse(DatasetNodeResponse):
    """
    `DatasetDataTableNodeResponse`
    """

    data_versions: Optional[conlist(DataVersionResponse)] = Field(
        default=None,
        alias="dataVersions",
        description="Collection of data version objects representing all versions within a specific DataTable",
    )
    data_table_id: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableId",
        description="Unique identifier of the referenced DataTable",
    )
    data_table_version_number: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableVersionNumber",
        description="Specific version number of the DataTable to use in the transformation",
    )
    __properties = [
        "nodeType",
        "name",
        "description",
        "tags",
        "id",
        "lockVersion",
        "dataTableId",
        "dataTableVersionNumber",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatasetDataTableNodeResponse:
        """Create an instance of DatasetDataTableNodeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DatasetDataTableNodeResponse:
        """Create an instance of DatasetDataTableNodeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DatasetDataTableNodeResponse.parse_obj(obj)

        _obj = DatasetDataTableNodeResponse.parse_obj(
            {
                "node_type": obj.get("nodeType"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "data_table_id": obj.get("dataTableId"),
                "data_table_version_number": obj.get("dataTableVersionNumber"),
            }
        )
        return _obj
