# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist


class ExportS3Request(BaseModel):
    """
    `ExportS3Request`
    """

    endpoint: StrictStr = Field(
        default=...,
        description="S3-compatible endpoint URL for the target storage service",
    )
    access_key: StrictStr = Field(
        default=...,
        alias="accessKey",
        description="AWS access key ID for authentication with the S3 service",
    )
    secret_key: StrictStr = Field(
        default=...,
        alias="secretKey",
        description="AWS secret access key for authentication with the S3 service",
    )
    session_token: StrictStr = Field(
        default=...,
        alias="sessionToken",
        description="AWS session token for temporary credentials (required for STS-based authentication)",
    )
    columns: Optional[conlist(StrictStr)] = Field(
        default=None,
        description="List of specific column names to include in the export. If not specified, all columns will be exported",
    )
    cast_boolean_to_integer: Optional[StrictBool] = Field(
        default=False,
        alias="castBooleanToInteger",
        description="Whether to convert boolean values to integers (true=1, false=0) in the exported data for compatibility with systems that don't support boolean types",
    )
    use_sample: Optional[StrictBool] = Field(
        default=False,
        alias="useSample",
        description="Whether to export only a sample of the data instead of the complete dataset. Useful for testing and preview purposes",
    )
    validate_release: Optional[StrictBool] = Field(
        default=True,
        alias="validateRelease",
        description="Whether to validate that the transformation graph has been released before allowing the export operation",
    )
    bucket: StrictStr = Field(
        default=..., description="Name of the S3 bucket where the data will be exported"
    )
    key: StrictStr = Field(
        default=...,
        description="S3 object key (path) where the exported data will be stored",
    )
    total_files: Optional[StrictInt] = Field(
        default=None,
        alias="totalFiles",
        description="Total number of files that will be created during the export process",
    )
    uploaded_files: Optional[conlist(StrictStr)] = Field(
        default=None,
        alias="uploadedFiles",
        description="List of file names that have been successfully uploaded to S3",
    )
    __properties = ["bucket", "key", "totalFiles", "uploadedFiles"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportS3Request:
        """Create an instance of ExportS3Request from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportS3Request:
        """Create an instance of ExportS3Request from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportS3Request.parse_obj(obj)

        _obj = ExportS3Request.parse_obj(
            {
                "bucket": obj.get("bucket"),
                "key": obj.get("key"),
                "total_files": obj.get("totalFiles"),
                "uploaded_files": obj.get("uploadedFiles"),
            }
        )
        return _obj
