# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr, conint


class ListQuery(BaseModel):
    """
    `ListQuery`
    """

    offset: Optional[conint(strict=True, ge=0)] = Field(
        default=0,
        description="Number of records to skip before starting to collect the result set",
    )
    limit: Optional[conint(strict=True, le=1000, ge=1)] = Field(
        default=1000, description="Number of records to retrieve in result set"
    )
    sort: Optional[StrictStr] = Field(
        default=None, description="Sorting criteria for result set"
    )
    filter: Optional[StrictStr] = Field(
        default=None, description="Expression describing a filter for result set"
    )
    __properties = ["offset", "limit", "sort", "filter"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ListQuery:
        """Create an instance of ListQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ListQuery:
        """Create an instance of ListQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ListQuery.parse_obj(obj)

        _obj = ListQuery.parse_obj(
            {
                "offset": obj.get("offset") if obj.get("offset") is not None else 0,
                "limit": obj.get("limit") if obj.get("limit") is not None else 1000,
                "sort": obj.get("sort"),
                "filter": obj.get("filter"),
            }
        )
        return _obj
