# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, conlist

from earnix_elevate.clients.data.models.dataset_edge_response import DatasetEdgeResponse
from earnix_elevate.clients.data.models.dataset_node_response import DatasetNodeResponse
from earnix_elevate.clients.data.models.user_response import UserResponse


class TransformationGraphResponse(BaseModel):
    """
    `TransformationGraphResponse`
    """

    dataset_id: Optional[StrictInt] = Field(
        default=None,
        alias="datasetId",
        description="Unique identifier of the Dataset that contains this transformation graph",
    )
    version_number: Optional[StrictInt] = Field(
        default=None,
        alias="versionNumber",
        description="Version number of this transformation graph within the Dataset",
    )
    output_dataset_recipe_node_id: Optional[StrictInt] = Field(
        default=None,
        alias="outputDatasetRecipeNodeId",
        description="Identifier of the final recipe node that produces the output of this transformation graph",
    )
    release_status: Optional[StrictBool] = Field(
        default=None,
        alias="releaseStatus",
        description="Indicates whether this transformation graph version has been released for production use",
    )
    lock_version: Optional[StrictInt] = Field(
        default=None,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="Date and time when this entity was created",
    )
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="Date and time when this entity was last modified",
    )
    id: Optional[StrictInt] = Field(
        default=None, description="Unique identifier of the entity"
    )
    nodes: Optional[conlist(DatasetNodeResponse)] = Field(
        default=None,
        description="List of all nodes (DataTables and recipes) within the transformation graph",
    )
    edges: Optional[conlist(DatasetEdgeResponse)] = Field(
        default=None,
        description="List of all connections between nodes in the transformation graph, defining the data flow",
    )
    __properties = [
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "id",
        "lockVersion",
        "nodes",
        "edges",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransformationGraphResponse:
        """Create an instance of TransformationGraphResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nodes (list)
        _items = []
        if self.nodes:
            for _item in self.nodes:
                if _item:
                    _items.append(_item.to_dict())
            _dict["nodes"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in edges (list)
        _items = []
        if self.edges:
            for _item in self.edges:
                if _item:
                    _items.append(_item.to_dict())
            _dict["edges"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransformationGraphResponse:
        """Create an instance of TransformationGraphResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransformationGraphResponse.parse_obj(obj)

        _obj = TransformationGraphResponse.parse_obj(
            {
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "nodes": [
                    DatasetNodeResponse.from_dict(_item) for _item in obj.get("nodes")
                ]
                if obj.get("nodes") is not None
                else None,
                "edges": [
                    DatasetEdgeResponse.from_dict(_item) for _item in obj.get("edges")
                ]
                if obj.get("edges") is not None
                else None,
            }
        )
        return _obj
