# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import (
    BaseModel,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    conlist,
    constr,
)


class UpdateDataTableRequest(BaseModel):
    """
    `UpdateDataTableRequest`
    """

    name: constr(strict=True, max_length=100, min_length=3) = Field(
        default=...,
        description="Name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="List of unique tags for categorizing and organizing the entity",
    )
    id: StrictInt = Field(default=..., description="Unique identifier of the entity")
    lock_version: StrictInt = Field(
        default=...,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    data_source_id: StrictInt = Field(
        default=...,
        alias="dataSourceId",
        description="Unique identifier of the DataSource from which this DataTable imports data",
    )
    data_version_exist: Optional[StrictBool] = Field(
        default=None,
        alias="dataVersionExist",
        description="Indicates whether this DataTable has any data versions available",
    )
    __properties = [
        "name",
        "description",
        "tags",
        "id",
        "lockVersion",
        "dataSourceId",
        "dataVersionExist",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateDataTableRequest:
        """Create an instance of UpdateDataTableRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateDataTableRequest:
        """Create an instance of UpdateDataTableRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateDataTableRequest.parse_obj(obj)

        _obj = UpdateDataTableRequest.parse_obj(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "data_source_id": obj.get("dataSourceId"),
                "data_version_exist": obj.get("dataVersionExist"),
            }
        )
        return _obj
