# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, StrictInt

from earnix_elevate.clients.data.models.update_dataset_node_request import (
    UpdateDatasetNodeRequest,
)


class UpdateDatasetDataTableNodeRequest(UpdateDatasetNodeRequest):
    """
    `UpdateDatasetDataTableNodeRequest`

    Updates the configuration of an existing DataTable node within the transformation graph. This allows modification of node properties.
    """

    data_table_id: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableId",
        description="Unique identifier of the referenced DataTable",
    )
    data_table_version_number: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableVersionNumber",
        description="Specific version number of the DataTable to use in the transformation",
    )
    __properties = [
        "nodeType",
        "datasetId",
        "id",
        "lockVersion",
        "dataTableId",
        "dataTableVersionNumber",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateDatasetDataTableNodeRequest:
        """Create an instance of UpdateDatasetDataTableNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateDatasetDataTableNodeRequest:
        """Create an instance of UpdateDatasetDataTableNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateDatasetDataTableNodeRequest.parse_obj(obj)

        _obj = UpdateDatasetDataTableNodeRequest.parse_obj(
            {
                "node_type": obj.get("nodeType"),
                "dataset_id": obj.get("datasetId"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "data_table_id": obj.get("dataTableId"),
                "data_table_version_number": obj.get("dataTableVersionNumber"),
            }
        )
        return _obj
