# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import List

from pydantic.v1 import Field, StrictInt, StrictStr, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.imx.api_client import ApiClient
from earnix_elevate.clients.imx.api_response import ApiResponse
from earnix_elevate.clients.imx.exceptions import ApiTypeError
from earnix_elevate.clients.imx.models.create_data_target_request import (
    CreateDataTargetRequest,
)
from earnix_elevate.clients.imx.models.data_target_response import DataTargetResponse
from earnix_elevate.clients.imx.models.update_data_target_request import (
    UpdateDataTargetRequest,
)


class DataTargetServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_data_target(
        self,
        create_data_target_request: Annotated[
            CreateDataTargetRequest, Field(..., description="Create DataTarget Request")
        ],
        **kwargs,
    ) -> DataTargetResponse:
        """Creates a new DataTarget that defines how to export data to an external data system.

        :param create_data_target_request: Create DataTarget Request (required)
        :type create_data_target_request: CreateDataTargetRequest
        :return: Returns the result object.
        :rtype: DataTargetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_data_target_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_data_target_with_http_info(
            create_data_target_request, **kwargs
        )

    @validate_arguments
    def create_data_target_with_http_info(
        self,
        create_data_target_request: Annotated[
            CreateDataTargetRequest, Field(..., description="Create DataTarget Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new DataTarget that defines how to export data to an external data system.

        :param create_data_target_request: Create DataTarget Request (required)
        :type create_data_target_request: CreateDataTargetRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTargetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_data_target_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_target" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_data_target_request"] is not None:
            _body_params = _params["create_data_target_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTargetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-targets",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_target(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        **kwargs,
    ) -> None:
        """Removes a DataTarget from your workspace. This operation will fail if there are Exports currently using this DataTarget. Returns NOT_FOUND if the DataTarget does not exist.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_target_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_target_with_http_info(data_target_id, **kwargs)

    @validate_arguments
    def delete_data_target_with_http_info(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Removes a DataTarget from your workspace. This operation will fail if there are Exports currently using this DataTarget. Returns NOT_FOUND if the DataTarget does not exist.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_target_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_target" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_target_id"] is not None:
            _path_params["data-target-id"] = _params["data_target_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-targets/{data-target-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_target(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        **kwargs,
    ) -> DataTargetResponse:
        """Retrieves detailed information about a specific DataTarget including its configuration and metadata. Returns NOT_FOUND if the DataTarget does not exist.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :return: Returns the result object.
        :rtype: DataTargetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_target_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_target_with_http_info(data_target_id, **kwargs)

    @validate_arguments
    def get_data_target_with_http_info(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific DataTarget including its configuration and metadata. Returns NOT_FOUND if the DataTarget does not exist.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTargetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_target_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_target" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_target_id"] is not None:
            _path_params["data-target-id"] = _params["data_target_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTargetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-targets/{data-target-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def is_data_target_name_available(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataTarget to check for availability (case-insensitive)",
            ),
        ],
        **kwargs,
    ) -> bool:
        """Validates whether a DataTarget name is available for use within the current workspace. Name validation is case-insensitive. Returns true if the name can be used for creating a new DataTarget, false if it already exists.

        :param name: The proposed name for the DataTarget to check for availability (case-insensitive) (required)
        :type name: str
        :return: Returns the result object.
        :rtype: bool
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the is_data_target_name_available_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.is_data_target_name_available_with_http_info(name, **kwargs)

    @validate_arguments
    def is_data_target_name_available_with_http_info(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataTarget to check for availability (case-insensitive)",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Validates whether a DataTarget name is available for use within the current workspace. Name validation is case-insensitive. Returns true if the name can be used for creating a new DataTarget, false if it already exists.

        :param name: The proposed name for the DataTarget to check for availability (case-insensitive) (required)
        :type name: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(bool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_data_target_name_available" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["name"] is not None:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "bool",
        }

        return self.api_client.call_api(
            "/v1/data-target-utils/is-name-available/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_data_targets(self, **kwargs) -> List[DataTargetResponse]:
        """Retrieves a list of all DataTargets. Targets represent the destination for an export process.
        :return: Returns the result object.
        :rtype: List[DataTargetResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_data_targets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_data_targets_with_http_info(**kwargs)

    @validate_arguments
    def list_data_targets_with_http_info(self, **kwargs) -> ApiResponse:
        """Retrieves a list of all DataTargets. Targets represent the destination for an export process.
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[DataTargetResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_targets" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[DataTargetResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-targets",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_data_target(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        update_data_target_request: Annotated[
            UpdateDataTargetRequest, Field(..., description="Update DataTarget Request")
        ],
        **kwargs,
    ) -> DataTargetResponse:
        """Updates the complete configuration of an existing DataTarget including connnection of the some type. The operation requires the current lock version to prevent concurrent modifications.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :param update_data_target_request: Update DataTarget Request (required)
        :type update_data_target_request: UpdateDataTargetRequest
        :return: Returns the result object.
        :rtype: DataTargetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_data_target_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_data_target_with_http_info(
            data_target_id, update_data_target_request, **kwargs
        )

    @validate_arguments
    def update_data_target_with_http_info(
        self,
        data_target_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTarget to operate on"),
        ],
        update_data_target_request: Annotated[
            UpdateDataTargetRequest, Field(..., description="Update DataTarget Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the complete configuration of an existing DataTarget including connnection of the some type. The operation requires the current lock version to prevent concurrent modifications.

        :param data_target_id: Unique identifier of the DataTarget to operate on (required)
        :type data_target_id: int
        :param update_data_target_request: Update DataTarget Request (required)
        :type update_data_target_request: UpdateDataTargetRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTargetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_target_id", "update_data_target_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_target" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_target_id"] is not None:
            _path_params["data-target-id"] = _params["data_target_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_data_target_request"] is not None:
            _body_params = _params["update_data_target_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTargetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-targets/{data-target-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
