# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.data_source_response import DataSourceResponse
from earnix_elevate.clients.imx.models.user_response import UserResponse


class BucketDataSourceResponse(DataSourceResponse):
    """
    `BucketDataSourceResponse`

    Response for a bucket-based DataSource that imports data from cloud storage systems, including the configured storage path and connection details.
    """

    path: Optional[constr(strict=True, max_length=1000)] = Field(
        default=None,
        description="The path within the bucket where the data files are located",
    )
    __properties = [
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "connectionId",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "type",
        "path",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BucketDataSourceResponse:
        """Create an instance of BucketDataSourceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BucketDataSourceResponse:
        """Create an instance of BucketDataSourceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BucketDataSourceResponse.parse_obj(obj)

        _obj = BucketDataSourceResponse.parse_obj(
            {
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connection_id": obj.get("connectionId"),
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
                "type": obj.get("type"),
                "path": obj.get("path"),
            }
        )
        return _obj
