# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import (
    BaseModel,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    conlist,
    constr,
)

from earnix_elevate.clients.imx.models.user_response import UserResponse

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.delta_sharing_connection_response import (
        DeltaSharingConnectionResponse,
    )
    from earnix_elevate.clients.imx.models.price_it_dim_connection_response import (
        PriceItDimConnectionResponse,
    )
    from earnix_elevate.clients.imx.models.s3_connection_response import (
        S3ConnectionResponse,
    )
    from earnix_elevate.clients.imx.models.snowflake_connection_response import (
        SnowflakeConnectionResponse,
    )


class ConnectionResponse(BaseModel):
    """
    `ConnectionResponse`

    Response containing Connection information including its configuration, authentication details, and metadata. Connections define how to authenticate and connect to external data systems.
    """

    read: Optional[StrictBool] = Field(
        default=True,
        description="If true, the connection has read permission for import.",
    )
    write: Optional[StrictBool] = Field(
        default=False,
        description="If true, the connection has write permission for export.",
    )
    id: StrictInt = Field(
        default=..., description="The unique identifier of the entity"
    )
    lock_version: StrictInt = Field(
        default=...,
        alias="lockVersion",
        description="The current version of the entity used for optimistic locking to prevent concurrent modifications",
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="The name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="A list of unique tags for categorizing and organizing the entity",
    )
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="The date and time when the entity was created",
    )
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="The date and time when the entity was last modified",
    )
    type: StrictStr = Field(
        default=...,
        description="The type of Connection (s3, snowflake, or delta sharing)",
    )
    __properties = [
        "read",
        "write",
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "type",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "type"

    # discriminator mappings
    __discriminator_value_class_map = {
        "delta_sharing": "DeltaSharingConnectionResponse",
        "priceit_dim": "PriceItDimConnectionResponse",
        "s3": "S3ConnectionResponse",
        "snowflake": "SnowflakeConnectionResponse",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        DeltaSharingConnectionResponse,
        PriceItDimConnectionResponse,
        S3ConnectionResponse,
        SnowflakeConnectionResponse,
    ]:
        """Create an instance of ConnectionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        DeltaSharingConnectionResponse,
        PriceItDimConnectionResponse,
        S3ConnectionResponse,
        SnowflakeConnectionResponse,
    ]:
        """Create an instance of ConnectionResponse from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "DeltaSharingConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.delta_sharing_connection_response"
            ).DeltaSharingConnectionResponse.from_dict(obj)
        if object_type == "PriceItDimConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.price_it_dim_connection_response"
            ).PriceItDimConnectionResponse.from_dict(obj)
        if object_type == "S3ConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.s3_connection_response"
            ).S3ConnectionResponse.from_dict(obj)
        if object_type == "SnowflakeConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.snowflake_connection_response"
            ).SnowflakeConnectionResponse.from_dict(obj)
        raise ValueError(
            "ConnectionResponse failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
