# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import (
    BaseModel,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    conlist,
    validator,
)


class CreateExportRequest(BaseModel):
    """
    `CreateExportRequest`
    """

    target_id: StrictInt = Field(
        default=...,
        alias="targetId",
        description="The dataTarget ID that specifies the location to export the data",
    )
    source_type: StrictStr = Field(
        default=...,
        alias="sourceType",
        description="The type of data source to export (dataset for DataSet, datatable for DataTable)",
    )
    source_id: StrictInt = Field(
        default=...,
        alias="sourceId",
        description="The ID of the source to export (DataSet ID or DataTable ID)",
    )
    source_version: StrictInt = Field(
        default=...,
        alias="sourceVersion",
        description="The specific version of the source to export.",
    )
    use_sample: Optional[StrictBool] = Field(
        default=False,
        alias="useSample",
        description="Whether to export a sample of the data (true) or the full data (false). Default is false.",
    )
    validate_to_release: Optional[StrictBool] = Field(
        default=True,
        alias="validateToRelease",
        description="Whether to validate the data before exporting. Default is true.",
    )
    cast_boolean_to_integer: Optional[StrictBool] = Field(
        default=False,
        alias="castBooleanToInteger",
        description="Whether to cast boolean columns to integer (1/0) during export. Default is false.",
    )
    columns: Optional[conlist(StrictStr)] = Field(
        default=None,
        description="Optional list of specific columns to include in the export. If not provided, all columns are exported.",
    )
    __properties = [
        "targetId",
        "sourceType",
        "sourceId",
        "sourceVersion",
        "useSample",
        "validateToRelease",
        "castBooleanToInteger",
        "columns",
    ]

    @validator("source_type")
    def source_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "dataset",
            "datatable",
            "datasetNode",
        ):
            raise ValueError(
                "must be one of enum values ('dataset', 'datatable', 'datasetNode')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateExportRequest:
        """Create an instance of CreateExportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateExportRequest:
        """Create an instance of CreateExportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateExportRequest.parse_obj(obj)

        _obj = CreateExportRequest.parse_obj(
            {
                "target_id": obj.get("targetId"),
                "source_type": obj.get("sourceType"),
                "source_id": obj.get("sourceId"),
                "source_version": obj.get("sourceVersion"),
                "use_sample": obj.get("useSample")
                if obj.get("useSample") is not None
                else False,
                "validate_to_release": obj.get("validateToRelease")
                if obj.get("validateToRelease") is not None
                else True,
                "cast_boolean_to_integer": obj.get("castBooleanToInteger")
                if obj.get("castBooleanToInteger") is not None
                else False,
                "columns": obj.get("columns"),
            }
        )
        return _obj
