# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import Field, StrictStr

from earnix_elevate.clients.imx.models.delta_sharing_auth_response import (
    DeltaSharingAuthResponse,
)


class DeltaSharingJsonProfileAuthResponse(DeltaSharingAuthResponse):
    """
    `DeltaSharingJsonProfileAuthResponse`

    Delta Sharing connection authentication response using json profile.
    """

    delta_sharing_profile_name: Optional[StrictStr] = Field(
        default=None,
        alias="deltaSharingProfileName",
        description="The name of Delta Sharing profile configuration.",
    )
    shared_data_endpoint: Optional[StrictStr] = Field(
        default=None,
        alias="sharedDataEndpoint",
        description="The endpoint URL for accessing shared data in DeltaSharing.",
    )
    token_expiration_time: Optional[datetime] = Field(
        default=None,
        alias="tokenExpirationTime",
        description="The expiration timestamp of the authentication token.",
    )
    __properties = [
        "authType",
        "deltaSharingProfileName",
        "sharedDataEndpoint",
        "tokenExpirationTime",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DeltaSharingJsonProfileAuthResponse:
        """Create an instance of DeltaSharingJsonProfileAuthResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeltaSharingJsonProfileAuthResponse:
        """Create an instance of DeltaSharingJsonProfileAuthResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DeltaSharingJsonProfileAuthResponse.parse_obj(obj)

        _obj = DeltaSharingJsonProfileAuthResponse.parse_obj(
            {
                "auth_type": obj.get("authType"),
                "delta_sharing_profile_name": obj.get("deltaSharingProfileName"),
                "shared_data_endpoint": obj.get("sharedDataEndpoint"),
                "token_expiration_time": obj.get("tokenExpirationTime"),
            }
        )
        return _obj
