# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist

from earnix_elevate.clients.imx.models.user_response import UserResponse


class ExportResponse(BaseModel):
    """
    `ExportResponse`

    Response containing Export
    """

    id: Optional[StrictInt] = Field(
        default=None, description="Unique identifier for the export operation"
    )
    job_id: Optional[StrictStr] = Field(
        default=None,
        alias="jobId",
        description="The job ID associated with the export operation",
    )
    target_id: Optional[StrictInt] = Field(
        default=None,
        alias="targetId",
        description="The dataTarget ID that specifies the location to export the data",
    )
    target_name: Optional[StrictStr] = Field(
        default=None,
        alias="targetName",
        description="The name of the dataTarget that specifies the location to export the data",
    )
    data_target_details: Optional[StrictStr] = Field(
        default=None,
        alias="dataTargetDetails",
        description="The details of the data target (e.g., S3 bucket path or PriceIt table path)",
    )
    exported_table_name: Optional[StrictStr] = Field(
        default=None,
        alias="exportedTableName",
        description="The name of the exported table",
    )
    source_type: Optional[StrictStr] = Field(
        default=None,
        alias="sourceType",
        description="The type of data source to export (dataset for DataSet, datatable for DataTable)",
    )
    source_id: Optional[StrictInt] = Field(
        default=None,
        alias="sourceId",
        description="The ID of the source to export (DataSet ID or DataTable ID)",
    )
    source_version: Optional[StrictInt] = Field(
        default=None,
        alias="sourceVersion",
        description="The specific version of the source to export.",
    )
    use_sample: Optional[StrictBool] = Field(
        default=False,
        alias="useSample",
        description="Whether to export a sample of the data (true) or the full data (false). Default is false.",
    )
    validate_to_release: Optional[StrictBool] = Field(
        default=True,
        alias="validateToRelease",
        description="Whether to validate the data before exporting. Default is true.",
    )
    cast_boolean_to_integer: Optional[StrictBool] = Field(
        default=False,
        alias="castBooleanToInteger",
        description="Whether to cast boolean columns to integer (1/0) during export. Default is false.",
    )
    columns: Optional[conlist(StrictStr)] = Field(
        default=None,
        description="Optional list of specific columns to include in the export. If not provided, all columns are exported.",
    )
    connection_id: Optional[StrictInt] = Field(
        default=None,
        alias="connectionId",
        description="The unique identifier of the Connection used for this export",
    )
    connection_name: Optional[StrictStr] = Field(
        default=None,
        alias="connectionName",
        description="The name of the Connection used for this export",
    )
    status: Optional[StrictStr] = Field(
        default=None,
        description="The current status of the export operation (e.g., pending, in_progress, completed, failed)",
    )
    message: Optional[StrictStr] = Field(
        default=None,
        description="Additional information or error message related to the export operation",
    )
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="The date and time when the entity was created",
    )
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="The date and time when the entity was last modified",
    )
    __properties = [
        "id",
        "jobId",
        "targetId",
        "targetName",
        "dataTargetDetails",
        "exportedTableName",
        "sourceType",
        "sourceId",
        "sourceVersion",
        "useSample",
        "validateToRelease",
        "castBooleanToInteger",
        "columns",
        "connectionId",
        "connectionName",
        "status",
        "message",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportResponse:
        """Create an instance of ExportResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportResponse:
        """Create an instance of ExportResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportResponse.parse_obj(obj)

        _obj = ExportResponse.parse_obj(
            {
                "id": obj.get("id"),
                "job_id": obj.get("jobId"),
                "target_id": obj.get("targetId"),
                "target_name": obj.get("targetName"),
                "data_target_details": obj.get("dataTargetDetails"),
                "exported_table_name": obj.get("exportedTableName"),
                "source_type": obj.get("sourceType"),
                "source_id": obj.get("sourceId"),
                "source_version": obj.get("sourceVersion"),
                "use_sample": obj.get("useSample")
                if obj.get("useSample") is not None
                else False,
                "validate_to_release": obj.get("validateToRelease")
                if obj.get("validateToRelease") is not None
                else True,
                "cast_boolean_to_integer": obj.get("castBooleanToInteger")
                if obj.get("castBooleanToInteger") is not None
                else False,
                "columns": obj.get("columns"),
                "connection_id": obj.get("connectionId"),
                "connection_name": obj.get("connectionName"),
                "status": obj.get("status"),
                "message": obj.get("message"),
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
            }
        )
        return _obj
