# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re
from typing import Optional

from pydantic.v1 import Field, constr, validator

from earnix_elevate.clients.imx.models.connection_response import ConnectionResponse
from earnix_elevate.clients.imx.models.s3_auth_response import S3AuthResponse
from earnix_elevate.clients.imx.models.user_response import UserResponse


class S3ConnectionResponse(ConnectionResponse):
    """
    `S3ConnectionResponse`

    Response for an S3 Connection that provides access to cloud storage services, including authentication details and path restrictions.
    """

    auth: Optional[S3AuthResponse] = None
    path_restriction: Optional[constr(strict=True, max_length=1000)] = Field(
        default=None,
        alias="pathRestriction",
        description="Optional path restriction to limit access to specific paths within the S3 bucket",
    )
    __properties = [
        "read",
        "write",
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "type",
        "pathRestriction",
    ]

    @validator("path_restriction")
    def path_restriction_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(
            r"^(s3:\/\/)?([a-z0-9][a-z0-9.-]{1,61}[a-z0-9]|[a-z0-9]{3})(\/\S*)?$", value
        ):
            raise ValueError(
                r"must validate the regular expression /^(s3:\/\/)?([a-z0-9][a-z0-9.-]{1,61}[a-z0-9]|[a-z0-9]{3})(\/\S*)?$/"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> S3ConnectionResponse:
        """Create an instance of S3ConnectionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        # set to None if path_restriction (nullable) is None
        # and __fields_set__ contains the field
        if self.path_restriction is None and "path_restriction" in self.__fields_set__:
            _dict["pathRestriction"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> S3ConnectionResponse:
        """Create an instance of S3ConnectionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return S3ConnectionResponse.parse_obj(obj)

        _obj = S3ConnectionResponse.parse_obj(
            {
                "read": obj.get("read") if obj.get("read") is not None else True,
                "write": obj.get("write") if obj.get("write") is not None else False,
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
                "type": obj.get("type"),
                "path_restriction": obj.get("pathRestriction"),
            }
        )
        return _obj
