# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.snowflake_auth_request import (
    SnowflakeAuthRequest,
)
from earnix_elevate.clients.imx.models.test_connection_request import (
    TestConnectionRequest,
)


class TestSnowflakeConnectionRequest(TestConnectionRequest):
    """
    `TestSnowflakeConnectionRequest`

    Request to test a Snowflake Connection by attempting to authenticate and connect to the Snowflake database using the provided credentials and connection settings.
    """

    auth: SnowflakeAuthRequest = Field(...)
    database: Optional[constr(strict=True, max_length=500, min_length=1)] = Field(
        default=None, description="The Snowflake database to connect to"
    )
    var_schema: Optional[constr(strict=True, max_length=500, min_length=1)] = Field(
        default=None, alias="schema", description="The Snowflake schema to use"
    )
    warehouse: Optional[constr(strict=True, max_length=500, min_length=1)] = Field(
        default=None, description="The Snowflake warehouse to use for query execution"
    )
    __properties = ["type", "database", "schema", "warehouse"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestSnowflakeConnectionRequest:
        """Create an instance of TestSnowflakeConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if database (nullable) is None
        # and __fields_set__ contains the field
        if self.database is None and "database" in self.__fields_set__:
            _dict["database"] = None

        # set to None if var_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.var_schema is None and "var_schema" in self.__fields_set__:
            _dict["schema"] = None

        # set to None if warehouse (nullable) is None
        # and __fields_set__ contains the field
        if self.warehouse is None and "warehouse" in self.__fields_set__:
            _dict["warehouse"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestSnowflakeConnectionRequest:
        """Create an instance of TestSnowflakeConnectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestSnowflakeConnectionRequest.parse_obj(obj)

        _obj = TestSnowflakeConnectionRequest.parse_obj(
            {
                "type": obj.get("type"),
                "database": obj.get("database"),
                "var_schema": obj.get("schema"),
                "warehouse": obj.get("warehouse"),
            }
        )
        return _obj
