# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Union

from pydantic.v1 import BaseModel, Field, StrictStr

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.test_updated_delta_sharing_connection_request import (
        TestUpdatedDeltaSharingConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.test_updated_price_it_dim_connection_request import (
        TestUpdatedPriceItDimConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.test_updated_s3_connection_request import (
        TestUpdatedS3ConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.test_updated_snowflake_connection_request import (
        TestUpdatedSnowflakeConnectionRequest,
    )


class TestUpdatedConnectionRequest(BaseModel):
    """
    `TestUpdatedConnectionRequest`

    Request to test an updated Connection configuration by attempting to establish a connection using the current settings stored in the system.
    """

    type: StrictStr = Field(
        default=..., description="The type of Connection to test (s3 or snowflake)"
    )
    __properties = ["type"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "type"

    # discriminator mappings
    __discriminator_value_class_map = {
        "delta_sharing": "TestUpdatedDeltaSharingConnectionRequest",
        "priceit_dim": "TestUpdatedPriceItDimConnectionRequest",
        "s3": "TestUpdatedS3ConnectionRequest",
        "snowflake": "TestUpdatedSnowflakeConnectionRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        TestUpdatedDeltaSharingConnectionRequest,
        TestUpdatedPriceItDimConnectionRequest,
        TestUpdatedS3ConnectionRequest,
        TestUpdatedSnowflakeConnectionRequest,
    ]:
        """Create an instance of TestUpdatedConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        TestUpdatedDeltaSharingConnectionRequest,
        TestUpdatedPriceItDimConnectionRequest,
        TestUpdatedS3ConnectionRequest,
        TestUpdatedSnowflakeConnectionRequest,
    ]:
        """Create an instance of TestUpdatedConnectionRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "TestUpdatedDeltaSharingConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.test_updated_delta_sharing_connection_request"
            ).TestUpdatedDeltaSharingConnectionRequest.from_dict(obj)
        if object_type == "TestUpdatedPriceItDimConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.test_updated_price_it_dim_connection_request"
            ).TestUpdatedPriceItDimConnectionRequest.from_dict(obj)
        if object_type == "TestUpdatedS3ConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.test_updated_s3_connection_request"
            ).TestUpdatedS3ConnectionRequest.from_dict(obj)
        if object_type == "TestUpdatedSnowflakeConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.test_updated_snowflake_connection_request"
            ).TestUpdatedSnowflakeConnectionRequest.from_dict(obj)
        raise ValueError(
            "TestUpdatedConnectionRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
