# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.update_data_target_request import (
    UpdateDataTargetRequest,
)


class UpdateS3DataTargetRequest(UpdateDataTargetRequest):
    """
    `UpdateS3DataTargetRequest`

    Request to update S3 DataTarget parameters and replacing a connection from the some type.
    """

    endpoint: Optional[constr(strict=True, max_length=256)] = Field(
        default=None, description="The endpoint URL for the S3 service"
    )
    path: Optional[constr(strict=True, max_length=256)] = Field(
        default=None,
        description="The path within the S3 bucket where the data will be exported",
    )
    bucket: Optional[constr(strict=True, max_length=256)] = Field(
        default=None,
        description="The name of the S3 bucket where the data will be exported",
    )
    __properties = [
        "type",
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "connectionId",
        "endpoint",
        "path",
        "bucket",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateS3DataTargetRequest:
        """Create an instance of UpdateS3DataTargetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateS3DataTargetRequest:
        """Create an instance of UpdateS3DataTargetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateS3DataTargetRequest.parse_obj(obj)

        _obj = UpdateS3DataTargetRequest.parse_obj(
            {
                "type": obj.get("type"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connection_id": obj.get("connectionId"),
                "endpoint": obj.get("endpoint"),
                "path": obj.get("path"),
                "bucket": obj.get("bucket"),
            }
        )
        return _obj
