
proteins = [{'accession': u'sp|Q13449|LSAMP_HUMAN Limbic system-associated membrane protein',
             'id': 1,
             'search_database_id': 1,
             'sequence': u'MVRRVQPDRKQLPLVLLRLLCLLPTGLPVRSVDFNRGTDNITVRQGDTAILRCVVEDKNSKVAWLNRSGIIFAGHDKWSLDPRVELEKRHSLEYSLRIQKVDVYDEGSYTCSVQTQHEPKTSQVYLIVQVPPKISNISSDVTVNEGSNVTLVCMANGRPEPVITWRHLTPTGREFEGEEEYLEILGITREQSGKYECKAANEVSSADVKQVKVTVNYPPTITESKSNEATTGRQASLKCEASAVPAPDFEWYRDDTRINSANGLEIKSTEGQSSLTVTNVTEEHYGNYTCVAANKLGVTNASLVLFRPGSVRGINGSISLAVPLWLLAASLLCLLSKC'},
            {'accession': u'sp|P24821|TENA_HUMAN Tenascin',
             'id': 2,
             'search_database_id': 1,
             'sequence': u'MGAMTQLLAGVFLAFLALATEGGVLKKVIRHKRQSGVNATLPEENQPVVFNHVYNIKLPVGSQCSVDLESASGEKDLAPPSEPSESFQEHTVDGENQIVFTHRINIPRRACGCAAAPDVKELLSRLEELENLVSSLREQCTAGAGCCLQPATGRLDTRPFCSGRGNFSTEGCGCVCEPGWKGPNCSEPECPGNCHLRGRCIDGQCICDDGFTGEDCSQLACPSDCNDQGKCVNGVCICFEGYAGADCSREICPVPCSEEHGTCVDGLCVCHDGFAGDDCNKPLCLNNCYNRGRCVENECVCDEGFTGEDCSELICPNDCFDRGRCINGTCYCEEGFTGEDCGKPTCPHACHTQGRCEEGQCVCDEGFAGVDCSEKRCPADCHNRGRCVDGRCECDDGFTGADCGELKCPNGCSGHGRCVNGQCVCDEGYTGEDCSQLRCPNDCHSRGRCVEGKCVCEQGFKGYDCSDMSCPNDCHQHGRCVNGMCVCDDGYTGEDCRDRQCPRDCSNRGLCVDGQCVCEDGFTGPDCAELSCPNDCHGQGRCVNGQCVCHEGFMGKDCKEQRCPSDCHGQGRCVDGQCICHEGFTGLDCGQHSCPSDCNNLGQCVSGRCICNEGYSGEDCSEVSPPKDLVVTEVTEETVNLAWDNEMRVTEYLVVYTPTHEGGLEMQFRVPGDQTSTIIQELEPGVEYFIRVFAILENKKSIPVSARVATYLPAPEGLKFKSIKETSVEVEWDPLDIAFETWEIIFRNMNKEDEGEITKSLRRPETSYRQTGLAPGQEYEISLHIVKNNTRGPGLKRVTTTRLDAPSQIEVKDVTDTTALITWFKPLAEIDGIELTYGIKDVPGDRTTIDLTEDENQYSIGNLKPDTEYEVSLISRRGDMSSNPAKETFTTGLDAPRNLRRVSQTDNSITLEWRNGKAAIDSYRIKYAPISGGDHAEVDVPKSQQATTKTTLTGLRPGTEYGIGVSAVKEDKESNPATINAATELDTPKDLQVSETAETSLTLLWKTPLAKFDRYRLNYSLPTGQWVGVQLPRNTTSYVLRGLEPGQEYNVLLTAEKGRHKSKPARVKASTEQAPELENLTVTEVGWDGLRLNWTAADQAYEHFIIQVQEANKVEAARNLTVPGSLRAVDIPGLKAATPYTVSIYGVIQGYRTPVLSAEASTGETPNLGEVVVAEVGWDALKLNWTAPEGAYEYFFIQVQEADTVEAAQNLTVPGGLRSTDLPGLKAATHYTITIRGVTQDFSTTPLSVEVLTEEVPDMGNLTVTEVSWDALRLNWTTPDGTYDQFTIQVQEADQVEEAHNLTVPGSLRSMEIPGLRAGTPYTVTLHGEVRGHSTRPLAVEVVTEDLPQLGDLAVSEVGWDGLRLNWTAADNAYEHFVIQVQEVNKVEAAQNLTLPGSLRAVDIPGLEAATPYRVSIYGVIRGYRTPVLSAEASTAKEPEIGNLNVSDITPESFNLSWMATDGIFETFTIEIIDSNRLLETVEYNISGAERTAHISGLPPSTDFIVYLSGLAPSIRTKTISATATTEALPLLENLTISDINPYGFTVSWMASENAFDSFLVTVVDSGKLLDPQEFTLSGTQRKLELRGLITGIGYEVMVSGFTQGHQTKPLRAEIVTEAEPEVDNLLVSDATPDGFRLSWTADEGVFDNFVLKIRDTKKQSEPLEITLLAPERTRDITGLREATEYEIELYGISKGRRSQTVSAIATTAMGSPKEVIFSDITENSATVSWRAPTAQVESFRITYVPITGGTPSMVTVDGTKTQTRLVKLIPGVEYLVSIIAMKGFEESEPVSGSFTTALDGPSGLVTANITDSEALARWQPAIATVDSYVISYTGEKVPEITRTVSGNTVEYALTDLEPATEYTLRIFAEKGPQKSSTITAKFTTDLDSPRDLTATEVQSETALLTWRPPRASVTGYLLVYESVDGTVKEVIVGPDTTSYSLADLSPSTHYTAKIQALNGPLRSNMIQTIFTTIGLLYPFPKDCSQAMLNGDTTSGLYTIYLNGDKAEALEVFCDMTSDGGGWIVFLRRKNGRENFYQNWKAYAAGFGDRREEFWLGLDNLNKITAQGQYELRVDLRDHGETAFAVYDKFSVGDAKTRYKLKVEGYSGTAGDSMAYHNGRSFSTFDKDTDSAITNCALSYKGAFWYRNCHRVNLMGRYGDNNHSQGVNWFHWKGHEHSIQFAEMKLRPSNFRNLEGRRKRA'},
            {'accession': u'sp|P04216|THY1_HUMAN Thy-1 membrane glycoprotein',
             'id': 3,
             'search_database_id': 1,
             'sequence': u'MNLAISIALLLTVLQVSRGQKVTSLTACLVDQSLRLDCRHENTSSSPIQYEFSLTRETKKHVLFGTVGVPEHTYRSRTNFTSKYNMKVLYLSAFTSKDEGTYTCALHHSGHSPPISSQNVTVLRDKLVKCEGISLLAQNTSWLLLLLLSLSLLQATDFMSL'},
            {'accession': u'sp|P19022|CADH2_HUMAN Cadherin-2',
             'id': 5,
             'search_database_id': 1,
             'sequence': u'MCRIAGALRTLLPLLAALLQASVEASGEIALCKTGFPEDVYSAVLSKDVHEGQPLLNVKFSNCNGKRKVQYESSEPADFKVDEDGMVYAVRSFPLSSEHAKFLIYAQDKETQEKWQVAVKLSLKPTLTEESVKESAEVEEIVFPRQFSKHSGHLQRQKRDWVIPPINLPENSRGPFPQELVRIRSDRDKNLSLRYSVTGPGADQPPTGIFIINPISGQLSVTKPLDREQIARFHLRAHAVDINGNQVENPIDIVINVIDMNDNRPEFLHQVWNGTVPEGSKPGTYVMTVTAIDADDPNALNGMLRYRIVSQAPSTPSPNMFTINNETGDIITVAAGLDREKVQQYTLIIQATDMEGNPTYGLSNTATAVITVTDVNDNPPEFTAMTFYGEVPENRVDIIVANLTVTDKDQPHTPAWNAVYRISGGDPTGRFAIQTDPNSNDGLVTVVKPIDFETNRMFVLTVAAENQVPLAKGIQHPPQSTATVSVTVIDVNENPYFAPNPKIIRQEEGLHAGTMLTTFTAQDPDRYMQQNIRYTKLSDPANWLKIDPVNGQITTIAVLDRESPNVKNNIYNATFLASDNGIPPMSGTGTLQIYLLDINDNAPQVLPQEAETCETPDPNSINITALDYDIDPNAGPFAFDLPLSPVTIKRNWTITRLNGDFAQLNLKIKFLEAGIYEVPIIITDSGNPPKSNISILRVKVCQCDSNGDCTDVDRIVGAGLGTGAIIAILLCIIILLILVLMFVVWMKRRDKERQAKQLLIDPEDDVRDNILKYDEEGGGEEDQDYDLSQLQQPDTVEPDAIKPVGIRRMDERPIHAEPQYPVRSAAPHPGDIGDFINEGLKAADNDPTAPPYDSLLVFDYEGSGSTAGSLSSLNSSSSGGEQDYDYLNDWGPRFKKLADMYGGGDD'},
            {'accession': u'sp|P02679|FIBG_HUMAN Fibrinogen gamma chain',
             'id': 6,
             'search_database_id': 1,
             'sequence': u'MSWSLHPRNLILYFYALLFLSSTCVAYVATRDNCCILDERFGSYCPTTCGIADFLSTYQTKVDKDLQSLEDILHQVENKTSEVKQLIKAIQLTYNPDESSKPNMIDAATLKSRKMLEEIMKYEASILTHDSSIRYLQEIYNSNNQKIVNLKEKVAQLEAQCQEPCKDTVQIHDITGKDCQDIANKGAKQSGLYFIKPLKANQQFLVYCEIDGSGNGWTVFQKRLDGSVDFKKNWIQYKEGFGHLSPTGTTEFWLGNEKIHLISTQSAIPYALRVELEDWNGRTSTADYAMFKVGPEADKYRLTYAYFAGGDAGDAFDGFDFGDDPSDKFFTSHNGMQFSTWDNDNDKFEGNCAEQDGSGWWMNKCHAGHLNGVYYQGGTYSKASTPNGYDNGIIWATWKTRWYSMKKTTMKIIPFNRLTIGEGQQHHLGGAKQVRPEHPAETEYDSLYPEDDL'},
            {'accession': u'sp|P13611|CSPG2_HUMAN Versican core protein',
             'id': 7,
             'search_database_id': 1,
             'sequence': u'MFINIKSILWMCSTLIVTHALHKVKVGKSPPVRGSLSGKVSLPCHFSTMPTLPPSYNTSEFLRIKWSKIEVDKNGKDLKETTVLVAQNGNIKIGQDYKGRVSVPTHPEAVGDASLTVVKLLASDAGLYRCDVMYGIEDTQDTVSLTVDGVVFHYRAATSRYTLNFEAAQKACLDVGAVIATPEQLFAAYEDGFEQCDAGWLADQTVRYPIRAPRVGCYGDKMGKAGVRTYGFRSPQETYDVYCYVDHLDGDVFHLTVPSKFTFEEAAKECENQDARLATVGELQAAWRNGFDQCDYGWLSDASVRHPVTVARAQCGGGLLGVRTLYRFENQTGFPPPDSRFDAYCFKPKEATTIDLSILAETASPSLSKEPQMVSDRTTPIIPLVDELPVIPTEFPPVGNIVSFEQKATVQPQAITDSLATKLPTPTGSTKKPWDMDDYSPSASGPLGKLDISEIKEEVLQSTTGVSHYATDSWDGVVEDKQTQESVTQIEQIEVGPLVTSMEILKHIPSKEFPVTETPLVTARMILESKTEKKMVSTVSELVTTGHYGFTLGEEDDEDRTLTVGSDESTLIFDQIPEVITVSKTSEDTIHTHLEDLESVSASTTVSPLIMPDNNGSSMDDWEERQTSGRITEEFLGKYLSTTPFPSQHRTEIELFPYSGDKILVEGISTVIYPSLQTEMTHRRERTETLIPEMRTDTYTDEIQEEITKSPFMGKTEEEVFSGMKLSTSLSEPIHVTESSVEMTKSFDFPTLITKLSAEPTEVRDMEEDFTATPGTTKYDENITTVLLAHGTLSVEAATVSKWSWDEDNTTSKPLESTEPSASSKLPPALLTTVGMNGKDKDIPSFTEDGADEFTLIPDSTQKQLEEVTDEDIAAHGKFTIRFQPTTSTGIAEKSTLRDSTTEEKVPPITSTEGQVYATMEGSALGEVEDVDLSKPVSTVPQFAHTSEVEGLAFVSYSSTQEPTTYVDSSHTIPLSVIPKTDWGVLVPSVPSEDEVLGEPSQDILVIDQTRLEATISPETMRTTKITEGTTQEEFPWKEQTAEKPVPALSSTAWTPKEAVTPLDEQEGDGSAYTVSEDELLTGSERVPVLETTPVGKIDHSVSYPPGAVTEHKVKTDEVVTLTPRIGPKVSLSPGPEQKYETEGSSTTGFTSSLSPFSTHITQLMEETTTEKTSLEDIDLGSGLFEKPKATELIEFSTIKVTVPSDITTAFSSVDRLHTTSAFKPSSAITKKPPLIDREPGEETTSDMVIIGESTSHVPPTTLEDIVAKETETDIDREYFTTSSPPATQPTRPPTVEDKEAFGPQALSTPQPPASTKFHPDINVYIIEVRENKTGRMSDLSVIGHPIDSESKEDEPCSEETDPVHDLMAEILPEFPDIIEIDLYHSEENEEEEEECANATDVTTTPSVQYINGKHLVTTVPKDPEAAEARRGQFESVAPSQNFSDSSESDTHPFVIAKTELSTAVQPNESTETTESLEVTWKPETYPETSEHFSGGEPDVFPTVPFHEEFESGTAKKGAESVTERDTEVGHQAHEHTEPVSLFPEESSGEIAIDQESQKIAFARATEVTFGEEVEKSTSVTYTPTIVPSSASAYVSEEEAVTLIGNPWPDDLLSTKESWVEATPRQVVELSGSSSIPITEGSGEAEEDEDTMFTMVTDLSQRNTTDTLITLDTSRIITESFFEVPATTIYPVSEQPSAKVVPTKFVSETDTSEWISSTTVEEKKRKEEEGTTGTASTFEVYSSTQRSDQLILPFELESPNVATSSDSGTRKSFMSLTTPTQSEREMTDSTPVFTETNTLENLGAQTTEHSSIHQPGVQEGLTTLPRSPASVFMEQGSGEAAADPETTTVSSFSLNVEYAIQAEKEVAGTLSPHVETTFSTEPTGLVLSTVMDRVVAENITQTSREIVISERLGEPNYGAEIRGFSTGFPLEEDFSGDFREYSTVSHPIAKEETVMMEGSGDAAFRDTQTSPSTVPTSVHISHISDSEGPSSTMVSTSAFPWEEFTSSAEGSGEQLVTVSSSVVPVLPSAVQKFSGTASSIIDEGLGEVGTVNEIDRRSTILPTAEVEGTKAPVEKEEVKVSGTVSTNFPQTIEPAKLWSRQEVNPVRQEIESETTSEEQIQEEKSFESPQNSPATEQTIFDSQTFTETELKTTDYSVLTTKKTYSDDKEMKEEDTSLVNMSTPDPDANGLESYTTLPEATEKSHFFLATALVTESIPAEHVVTDSPIKKEESTKHFPKGMRPTIQESDTELLFSGLGSGEEVLPTLPTESVNFTEVEQINNTLYPHTSQVESTSSDKIEDFNRMENVAKEVGPLVSQTDIFEGSGSVTSTTLIEILSDTGAEGPTVAPLPFSTDIGHPQNQTVRWAEEIQTSRPQTITEQDSNKNSSTAEINETTTSSTDFLARAYGFEMAKEFVTSAPKPSDLYYEPSGEGSGEVDIVDSFHTSATTQATRQESSTTFVSDGSLEKHPEVPSAKAVTADGFPTVSVMLPLHSEQNKSSPDPTSTLSNTVSYERSTDGSFQDRFREFEDSTLKPNRKKPTENIIIDLDKEDKDLILTITESTILEILPELTSDKNTIIDIDHTKPVYEDILGMQTDIDTEVPSEPHDSNDESNDDSTQVQEIYEAAVNLSLTEETFEGSADVLASYTQATHDESMTYEDRSQLDHMGFHFTTGIPAPSTETELDVLLPTATSLPIPRKSATVIPEIEGIKAEAKALDDMFESSTLSDGQAIADQSEIIPTLGQFERTQEEYEDKKHAGPSFQPEFSSGAEEALVDHTPYLSIATTHLMDQSVTEVPDVMEGSNPPYYTDTTLAVSTFAKLSSQTPSSPLTIYSGSEASGHTEIPQPSALPGIDVGSSVMSPQDSFKEIHVNIEATFKPSSEEYLHITEPPSLSPDTKLEPSEDDGKPELLEEMEASPTELIAVEGTEILQDFQNKTDGQVSGEAIKMFPTIKTPEAGTVITTADEIELEGATQWPHSTSASATYGVEAGVVPWLSPQTSERPTLSSSPEINPETQAALIRGQDSTIAASEQQVAARILDSNDQATVNPVEFNTEVATPPFSLLETSNETDFLIGINEESVEGTAIYLPGPDRCKMNPCLNGGTCYPTETSYVCTCVPGYSGDQCELDFDECHSNPCRNGATCVDGFNTFRCLCLPSYVGALCEQDTETCDYGWHKFQGQCYKYFAHRRTWDAAERECRLQGAHLTSILSHEEQMFVNRVGHDYQWIGLNDKMFEHDFRWTDGSTLQYENWRPNQPDSFFSAGEDCVVIIWHENGQWNDVPCNYHLTYTCKKGTVACGQPPVVENAKTFGKMKPRYEINSLIRYHCKDGFIQRHLPTIRCLGNGRWAIPKITCMNPSAYQRTYSMKYFKNSSSAKDNSINTSKHDHRWSRRWQESRR'},
            {'accession': u'sp|Q92823|NRCAM_HUMAN Neuronal cell adhesion molecule',
             'id': 8,
             'search_database_id': 1,
             'sequence': u'MQLKIMPKKKRLSAGRVPLILFLCQMISALEVPLDPKLLEDLVQPPTITQQSPKDYIIDPRENIVIQCEAKGKPPPSFSWTRNGTHFDIDKDPLVTMKPGTGTLIINIMSEGKAETYEGVYQCTARNERGAAVSNNIVVRPSRSPLWTKEKLEPITLQSGQSLVLPCRPPIGLPPPIIFWMDNSFQRLPQSERVSQGLNGDLYFSNVLPEDTREDYICYARFNHTQTIQQKQPISVKVISVDELNDTIAANLSDTEFYGAKSSRERPPTFLTPEGNASNKEELRGNVLSLECIAEGLPTPIIYWAKEDGMLPKNRTVYKNFEKTLQIIHVSEADSGNYQCIAKNALGAIHHTISVRVKAAPYWITAPQNLVLSPGEDGTLICRANGNPKPRISWLTNGVPIEIAPDDPSRKIDGDTIIFSNVQERSSAVYQCNASNEYGYLLANAFVNVLAEPPRILTPANTLYQVIANRPALLDCAFFGSPLPTIEWFKGAKGSALHEDIYVLHENGTLEIPVAQKDSTGTYTCVARNKLGMAKNEVHLEIKDPTWIVKQPEYAVVQRGSMVSFECKVKHDHTLSLTVLWLKDNRELPSDERFTVDKDHLVVADVSDDDSGTYTCVANTTLDSVSASAVLSVVAPTPTPAPVYDVPNPPFDLELTDQLDKSVQLSWTPGDDNNSPITKFIIEYEDAMHKPGLWHHQTEVSGTQTTAQLKLSPYVNYSFRVMAVNSIGKSLPSEASEQYLTKASEPDKNPTAVEGLGSEPDNLVITWKPLNGFESNGPGLQYKVSWRQKDGDDEWTSVVVANVSKYIVSGTPTFVPYLIKVQALNDMGFAPEPAVVMGHSGEDLPMVAPGNVRVNVVNSTLAEVHWDPVPLKSIRGHLQGYRIYYWKTQSSSKRNRRHIEKKILTFQGSKTHGMLPGLEPFSHYTLNVRVVNGKGEGPASPDRVFNTPEGVPSAPSSLKIVNPTLDSLTLEWDPPSHPNGILTEYTLKYQPINSTHELGPLVDLKIPANKTRWTLKNLNFSTRYKFYFYAQTSAGSGSQITEEAVTTVDEAGILPPDVGAGKVQAVNPRISNLTAAAAETYANISWEYEGPEHVNFYVEYGVAGSKEEWRKEIVNGSRSFFGLKGLMPGTAYKVRVGAVGDSGFVSSEDVFETGPAMASRQVDIATQGWFIGLMCAVALLILILLIVCFIRRNKGGKYPVKEKEDAHADPEIQPMKEDDGTFGEYSDAEDHKPLKKGSRTPSDRTVKKEDSDDSLVDYGEGVNGQFNEDGSFIGQYSGKKEKEPAEGNESSEAPSPVNAMNSFV'},
            {'accession': u'sp|P01857|IGHG1_HUMAN Ig gamma-1 chain C region',
             'id': 9,
             'search_database_id': 1,
             'sequence': u'ASTKGPSVFPLAPSSKSTSGGTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSSLGTQTYICNVNHKPSNTKVDKKVEPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK'},
            {'accession': u'sp|O14594|NCAN_HUMAN Neurocan core protein',
             'id': 10,
             'search_database_id': 1,
             'sequence': u'MGAPFVWALGLLMLQMLLFVAGEQGTQDITDASERGLHMQKLGSGSVQAALAELVALPCLFTLQPRPSAARDAPRIKWTKVRTASGQRQDLPILVAKDNVVRVAKSWQGRVSLPSYPRRRANATLLLGPLRASDSGLYRCQVVRGIEDEQDLVPLEVTGVVFHYRSARDRYALTFAEAQEACRLSSAIIAAPRHLQAAFEDGFDNCDAGWLSDRTVRYPITQSRPGCYGDRSSLPGVRSYGRRNPQELYDVYCFARELGGEVFYVGPARRLTLAGARAQCRRQGAALASVGQLHLAWHEGLDQCDPGWLADGSVRYPIQTPRRRCGGPAPGVRTVYRFANRTGFPSPAERFDAYCFRAHHPTSQHGDLETPSSGDEGEILSAEGPPVRELEPTLEEEEVVTPDFQEPLVSSGEEETLILEEKQESQQTLSPTPGDPMLASWPTGEVWLSTVAPSPSDMGAGTAASSHTEVAPTDPMPRRRGRFKGLNGRYFQQQEPEPGLQGGMEASAQPPTSEAAVNQMEPPLAMAVTEMLGSGQSRSPWADLTNEVDMPGAGSAGGKSSPEPWLWPPTMVPPSISGHSRAPVLELEKAEGPSARPATPDLFWSPLEATVSAPSPAPWEAFPVATSPDLPMMAMLRGPKEWMLPHPTPISTEANRVEAHGEATATAPPSPAAETKVYSLPLSLTPTGQGGEAMPTTPESPRADFRETGETSPAQVNKAEHSSSSPWPSVNRNVAVGFVPTETATEPTGLRGIPGSESGVFDTAESPTSGLQATVDEVQDPWPSVYSKGLDASSPSAPLGSPGVFLVPKVTPNLEPWVATDEGPTVNPMDSTVTPAPSDASGIWEPGSQVFEEAESTTLSPQVALDTSIVTPLTTLEQGDKVGVPAMSTLGSSSSQPHPEPEDQVETQGTSGASVPPHQSSPLGKPAVPPGTPTAASVGESASVSSGEPTVPWDPSSTLLPVTLGIEDFELEVLAGSPGVESFWEEVASGEEPALPGTPMNAGAEEVHSDPCENNPCLHGGTCNANGTMYGCSCDQGFAGENCEIDIDDCLCSPCENGGTCIDEVNGFVCLCLPSYGGSFCEKDTEGCDRGWHKFQGHCYRYFAHRRAWEDAEKDCRRRSGHLTSVHSPEEHSFINSFGHENTWIGLNDRIVERDFQWTDNTGLQFENWRENQPDNFFAGGEDCVVMVAHESGRWNDVPCNYNLPYVCKKGTVLCGPPPAVENASLIGARKAKYNVHATVRYQCNEGFAQHHVATIRCRSNGKWDRPQIVCTKPRRSHRMRRHHHHHQHHHQHHHHKSRKERRKHKKHPTEDWEKDEGNFC'},
            {'accession': u'sp|P14415|AT1B2_HUMAN Sodium/potassium-transporting ATPase subunit beta-2',
             'id': 11,
             'search_database_id': 1,
             'sequence': u'MVIQKEKKSCGQVVEEWKEFVWNPRTHQFMGRTGTSWAFILLFYLVFYGFLTAMFTLTMWVMLQTVSDHTPKYQDRLATPGLMIRPKTENLDVIVNVSDTESWDQHVQKLNKFLEPYNDSIQAQKNDVCRPGRYYEQPDNGVLNYPKRACQFNRTQLGNCSGIGDSTHYGYSTGQPCVFIKMNRVINFYAGANQSMNVTCAGKRDEDAENLGNFVMFPANGNIDLMYFPYYGKKFHVNYTQPLVAVKFLNVTPNVEVNVECRINAANIATDDERDKFAGRVAFKLRINKT'},
            {'accession': u'sp|Q12860|CNTN1_HUMAN Contactin-1',
             'id': 13,
             'search_database_id': 1,
             'sequence': u'MKMWLLVSHLVIISITTCLAEFTWYRRYGHGVSEEDKGFGPIFEEQPINTIYPEESLEGKVSLNCRARASPFPVYKWRMNNGDVDLTSDRYSMVGGNLVINNPDKQKDAGIYYCLASNNYGMVRSTEATLSFGYLDPFPPEERPEVRVKEGKGMVLLCDPPYHFPDDLSYRWLLNEFPVFITMDKRRFVSQTNGNLYIANVEASDKGNYSCFVSSPSITKSVFSKFIPLIPIPERTTKPYPADIVVQFKDVYALMGQNVTLECFALGNPVPDIRWRKVLEPMPSTAEISTSGAVLKIFNIQLEDEGIYECEAENIRGKDKHQARIYVQAFPEWVEHINDTEVDIGSDLYWPCVATGKPIPTIRWLKNGYAYHKGELRLYDVTFENAGMYQCIAENTYGAIYANAELKILALAPTFEMNPMKKKILAAKGGRVIIECKPKAAPKPKFSWSKGTEWLVNSSRILIWEDGSLEINNITRNDGGIYTCFAENNRGKANSTGTLVITDPTRIILAPINADITVGENATMQCAASFDPALDLTFVWSFNGYVIDFNKENIHYQRNFMLDSNGELLIRNAQLKHAGRYTCTAQTIVDNSSASADLVVRGPPGPPGGLRIEDIRATSVALTWSRGSDNHSPISKYTIQTKTILSDDWKDAKTDPPIIEGNMEAARAVDLIPWMEYEFRVVATNTLGRGEPSIPSNRIKTDGAAPNVAPSDVGGGGGRNRELTITWAPLSREYHYGNNFGYIVAFKPFDGEEWKKVTVTNPDTGRYVHKDETMSPSTAFQVKVKAFNNKGDGPYSLVAVINSAQDAPSEAPTEVGVKVLSSSEISVHWEHVLEKIVESYQIRYWAAHDKEEAANRVQVTSQEYSARLENLLPDTQYFIEVGACNSAGCGPPSDMIEAFTKKAPPSQPPRIISSVRSGSRYIITWDHVVALSNESTVTGYKVLYRPDGQHDGKLYSTHKHSIEVPIPRDGEYVVEVRAHSDGGDGVVSQVKISGAPTLSPSLLGLLLPAFGILVYLEF'},
            {'accession': u'sp|P01024|CO3_HUMAN Complement C3 beta chain',
             'id': 14,
             'search_database_id': 1,
             'sequence': u'MGPTSGPSLLLLLLTHLPLALGSPMYSIITPNILRLESEETMVLEAHDAQGDVPVTVTVHDFPGKKLVLSSEKTVLTPATNHMGNVTFTIPANREFKSEKGRNKFVTVQATFGTQVVEKVVLVSLQSGYLFIQTDKTIYTPGSTVLYRIFTVNHKLLPVGRTVMVNIENPEGIPVKQDSLSSQNQLGVLPLSWDIPELVNMGQWKIRAYYENSPQQVFSTEFEVKEYVLPSFEVIVEPTEKFYYIYNEKGLEVTITARFLYGKKVEGTAFVIFGIQDGEQRISLPESLKRIPIEDGSGEVVLSRKVLLDGVQNPRAEDLVGKSLYVSATVILHSGSDMVQAERSGIPIVTSPYQIHFTKTPKYFKPGMPFDLMVFVTNPDGSPAYRVPVAVQGEDTVQSLTQGDGVAKLSINTHPSQKPLSITVRTKKQELSEAEQATRTMQALPYSTVGNSNNYLHLSVLRTELRPGETLNVNFLLRMDRAHEAKIRYYTYLIMNKGRLLKAGRQVREPGQDLVVLPLSITTDFIPSFRLVAYYTLIGASGQREVVADSVWVDVKDSCVGSLVVKSGQSEDRQPVPGQQMTLKIEGDHGARVVLVAVDKGVFVLNKKNKLTQSKIWDVVEKADIGCTPGSGKDYAGVFSDAGLTFTSSSGQQTAQRAELQCPQPAARRRRSVQLTEKRMDKVGKYPKELRKCCEDGMRENPMRFSCQRRTRFISLGEACKKVFLDCCNYITELRRQHARASHLGLARSNLDEDIIAEENIVSRSEFPESWLWNVEDLKEPPKNGISTKLMNIFLKDSITTWEILAVSMSDKKGICVADPFEVTVMQDFFIDLRLPYSVVRNEQVEIRAVLYNYRQNQELKVRVELLHNPAFCSLATTKRRHQQTVTIPPKSSLSVPYVIVPLKTGLQEVEVKAAVYHHFISDGVRKSLKVVPEGIRMNKTVAVRTLDPERLGREGVQKEDIPPADLSDQVPDTESETRILLQGTPVAQMTEDAVDAERLKHLIVTPSGCGEQNMIGMTPTVIAVHYLDETEQWEKFGLEKRQGALELIKKGYTQQLAFRQPSSAFAAFVKRAPSTWLTAYVVKVFSLAVNLIAIDSQVLCGAVKWLILEKQKPDGVFQEDAPVIHQEMIGGLRNNNEKDMALTAFVLISLQEAKDICEEQVNSLPGSITKAGDFLEANYMNLQRSYTVAIAGYALAQMGRLKGPLLNKFLTTAKDKNRWEDPGKQLYNVEATSYALLALLQLKDFDFVPPVVRWLNEQRYYGGGYGSTQATFMVFQALAQYQKDAPDHQELNLDVSLQLPSRSSKITHRIHWESASLLRSEETKENEGFTVTAEGKGQGTLSVVTMYHAKAKDQLTCNKFDLKVTIKPAPETEKRPQDAKNTMILEICTRYRGDQDATMSILDISMMTGFAPDTDDLKQLANGVDRYISKYELDKAFSDRNTLIIYLDKVSHSEDDCLAFKVHQYFNVELIQPGAVKVYAYYNLEESCTRFYHPEKEDGKLNKLCRDELCRCAEENCFIQKSDDKVTLEERLDKACEPGVDYVYKTRLVKVQLSNDFDEYIMAIEQTIKSGSDEVQVGQQRTFISPIKCREALKLEEKKHYLMWGLSSDFWGEKPNLSYIIGKDTWVEHWPEEDECQDEENQKQCQDLGAFTESMVVFGCPN'},
            {'accession': u'sp|P01859|IGHG2_HUMAN Ig gamma-2 chain C region',
             'id': 15,
             'search_database_id': 1,
             'sequence': u'ASTKGPSVFPLAPCSRSTSESTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSNFGTQTYTCNVDHKPSNTKVDKTVERKCCVECPPCPAPPVAGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVQFNWYVDGVEVHNAKTKPREEQFNSTFRVVSVLTVVHQDWLNGKEYKCKVSNKGLPAPIEKTISKTKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDISVEWESNGQPENNYKTTPPMLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK'},
            {'accession': u'sp|Q96GW7|PGCB_HUMAN Brevican core protein',
             'id': 16,
             'search_database_id': 1,
             'sequence': u'MAQLFLPLLAALVLAQAPAALADVLEGDSSEDRAFRVRIAGDAPLQGVLGGALTIPCHVHYLRPPPSRRAVLGSPRVKWTFLSRGREAEVLVARGVRVKVNEAYRFRVALPAYPASLTDVSLALSELRPNDSGIYRCEVQHGIDDSSDAVEVKVKGVVFLYREGSARYAFSFSGAQEACARIGAHIATPEQLYAAYLGGYEQCDAGWLSDQTVRYPIQTPREACYGDMDGFPGVRNYGVVDPDDLYDVYCYAEDLNGELFLGDPPEKLTLEEARAYCQERGAEIATTGQLYAAWDGGLDHCSPGWLADGSVRYPIVTPSQRCGGGLPGVKTLFLFPNQTGFPNKHSRFNVYCFRDSAQPSAIPEASNPASNPASDGLEAIVTVTETLEELQLPQEATESESRGAIYSIPIMEDGGGGSSTPEDPAEAPRTLLEFETQSMVPPTGFSEEEGKALEEEEKYEDEEEKEEEEEEEEVEDEALWAWPSELSSPGPEASLPTEPAAQEESLSQAPARAVLQPGASPLPDGESEASRPPRVHGPPTETLPTPRERNLASPSPSTLVEAREVGEATGGPELSGVPRGESEETGSSEGAPSLLPATRAPEGTRELEAPSEDNSGRTAPAGTSVQAQPVLPTDSASRGGVAVVPASGDCVPSPCHNGGTCLEEEEGVRCLCLPGYGGDLCDVGLRFCNPGWDAFQGACYKHFSTRRSWEEAETQCRMYGAHLASISTPEEQDFINNRYREYQWIGLNDRTIEGDFLWSDGVPLLYENWNPGQPDSYFLSGENCVVMVWHDQGQWSDVPCNYHLSYTCKMGLVSCGPPPELPLAQVFGRPRLRYEVDTVLRYRCREGLAQRNLPLIRCQENGRWEAPQISCVPRRPARALHPEEDPEGRQGRLLGRWKALLIPPSSPMPGP'}]

peptides = [{'id': 41,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'VSLSPGPEQK'},
            {'id': 52,
             'modifications': [{'location': 8,
                                'monoisotopic_mass_delta': 1095.39658781403,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:3; HexNAc:3}'},
                                           {'name': 'Formula',
                                            'value': 'C42H69N3O30'}]}],
             'peptide_sequence': 'TDEVVTLTPR'},
            {'id': 50,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1444.53386913248,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C56H92N4O39'}]}],
             'peptide_sequence': 'EEQYNSTYR'},
            {'id': 48,
             'modifications': [{'location': 7,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'VPVLETTPVGK'},
            {'id': 60,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 947.32302895095,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C36H57N3O26'}]}],
             'peptide_sequence': 'LSAEPTEVR'},
            {'id': 74,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'LNYSLPTGQWVGVQLPR'},
            {'id': 37,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 730.26439187602,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C28H46N2O20'}]}],
             'peptide_sequence': 'VPVLETTPVGK'},
            {'id': 15,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'ITEEFLGK'},
            {'id': 42,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1022.3802094739,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:2; Hex:2; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C40H66N2O28'}]}],
             'peptide_sequence': 'VSLSPGPEQK'},
            {'id': 21,
             'modifications': [{'location': 3,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'QTSGRITEEFLGK'},
            {'id': 9,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1540.52850896852,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:7; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C58H96N2O45'}]}],
             'peptide_sequence': 'VAWLNR'},
            {'id': 65,
             'modifications': [{'location': 23,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'VALPAYPASLTDVSLALSELRPNDSGIYR'},
            {'id': 11,
             'modifications': [{'location': 7,
                                'monoisotopic_mass_delta': 2263.83470608687,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:3; Hex:5; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C88H145N5O62'}]}],
             'peptide_sequence': 'TLFLFPNQTGFPNK'},
            {'id': 5,
             'modifications': [{'location': 23,
                                'monoisotopic_mass_delta': 1540.52850896852,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:7; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C58H96N2O45'}]}],
             'peptide_sequence': 'VALPAYPASLTDVSLALSELRPNDSGIYR'},
            {'id': 44,
             'modifications': [{'location': 12,
                                'monoisotopic_mass_delta': 656.22761244448,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C25H40N2O18'}]}],
             'peptide_sequence': 'EVGEATGGPELSGVPR'},
            {'id': 25,
             'modifications': [{'location': 12,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'EVGEATGGPELSGVPR'},
            {'id': 56,
             'modifications': [{'location': 1,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'NGTHFDIDK'},
            {'id': 62,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1378.47568555002,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:6; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C52H86N2O40'}]}],
             'peptide_sequence': 'FHVNYTQPLVAVK'},
            {'id': 30,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1021.35980838249,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C39H63N3O28'}]}],
             'peptide_sequence': 'VSLSPGPEQK'},
            {'id': 1,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'FNHTQTIQQK'},
            {'id': 22,
             'modifications': [{'location': 23,
                                'monoisotopic_mass_delta': 1378.47568555002,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:6; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C52H86N2O40'}]}],
             'peptide_sequence': 'VALPAYPASLTDVSLALSELRPNDSGIYR'},
            {'id': 66,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1768.63951596948,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:5; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C68H112N4O49'}]}],
             'peptide_sequence': 'EEQFNSTFR'},
            {'id': 64,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1606.58669255098,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:4; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C62H102N4O44'}]}],
             'peptide_sequence': 'EEQYNSTYR'},
            {'id': 72,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 947.32302895095,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C36H57N3O26'}]}],
             'peptide_sequence': 'LEATISPETMR'},
            {'id': 31,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1378.47568555002,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:6; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C52H86N2O40'}]}],
             'peptide_sequence': 'FNHTQTIQQK'},
            {'id': 32,
             'modifications': [{'location': 7,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'GTEWLVNSSR'},
            {'id': 13,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 947.32302895095,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C36H57N3O26'}]}],
             'peptide_sequence': 'EVGEATGGPELSGVPR'},
            {'id': 47,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 1021.35980838249,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C39H63N3O28'}]}],
             'peptide_sequence': 'VHGPPTETLPTPR'},
            {'id': 20,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1647.61324165199,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C64H105N5O44'}]}],
             'peptide_sequence': 'TNFTSK'},
            {'id': 75,
             'modifications': [{'location': 1,
                                'monoisotopic_mass_delta': 1647.61324165199,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C64H105N5O44'}]}],
             'peptide_sequence': 'TNFTSK'},
            {'id': 63,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1647.61324165199,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C64H105N5O44'}]}],
             'peptide_sequence': 'TNFTSK'},
            {'id': 70,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1606.58669255098,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:4; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C62H102N4O44'}]}],
             'peptide_sequence': 'EEQFNSTFR'},
            {'id': 16,
             'modifications': [{'location': 8,
                                'monoisotopic_mass_delta': 1021.35980838249,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C39H63N3O28'}]}],
             'peptide_sequence': 'TDEVVTLTPR'},
            {'id': 67,
             'modifications': [{'location': 8,
                                'monoisotopic_mass_delta': 730.26439187602,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C28H46N2O20'}]}],
             'peptide_sequence': 'TDEVVTLTPR'},
            {'id': 2,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1460.52878375204,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:4; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C56H92N4O40'}]}],
             'peptide_sequence': 'FQPTTSTGIAEK'},
            {'id': 46,
             'modifications': [{'location': 15,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'AVLQPGASPLPDGESEASRPPR'},
            {'id': 57,
             'modifications': [{'location': 9,
                                'monoisotopic_mass_delta': 947.32302895095,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C36H57N3O26'}]}],
             'peptide_sequence': 'SFDFPTLITK'},
            {'id': 3,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'QLEEVTDEDIAAHGK'},
            {'id': 35,
             'modifications': [{'location': 14,
                                'monoisotopic_mass_delta': 1913.6770236770099,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:4; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C73H119N5O53'}]}],
             'peptide_sequence': 'DLQSLEDILHQVENK'},
            {'id': 10,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'SNISILR'},
            {'id': 34,
             'modifications': [{'location': 12,
                                'monoisotopic_mass_delta': 1378.47568555002,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:6; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C52H86N2O40'}]}],
             'peptide_sequence': 'TVLTPATNHMGNVTFTIPANR'},
            {'id': 49,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'LSAEPTEVR'},
            {'id': 6,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'FLEPYNDSIQAQK'},
            {'id': 24,
             'modifications': [{'location': 2,
                                'monoisotopic_mass_delta': 1216.42286213152,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:5; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C46H76N2O35'}]}],
             'peptide_sequence': 'ANATLLLGPLR'},
            {'id': 14,
             'modifications': [{'location': 11,
                                'monoisotopic_mass_delta': 1387.51240541191,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:2; Hex:3; HexNAc:3}'},
                                           {'name': 'Formula',
                                            'value': 'C54H89N3O38'}]}],
             'peptide_sequence': 'VHGPPTETLPTPR'},
            {'id': 7,
             'modifications': [{'location': 7,
                                'monoisotopic_mass_delta': 1955.72397386943,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:2; Hex:4; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C76H125N5O53'}]}],
             'peptide_sequence': 'TLFLFPNQTGFPNK'},
            {'id': 53,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1021.35980838249,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C39H63N3O28'}]}],
             'peptide_sequence': 'VSLSPGPEQK'},
            {'id': 18,
             'modifications': [{'location': 15,
                                'monoisotopic_mass_delta': 1313.4756259803698,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:2; Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C51H83N3O36'}]}],
             'peptide_sequence': 'AVLQPGASPLPDGESEASRPPR'},
            {'id': 58,
             'modifications': [{'location': 11,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'VHGPPTETLPTPR'},
            {'id': 69,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 1386.4920043205,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:3; HexNAc:3; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C53H86N4O38'}]}],
             'peptide_sequence': 'NLASPSPSTLVEAR'},
            {'id': 39,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 1021.35980838249,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C39H63N3O28'}]}],
             'peptide_sequence': 'VPVLETTPVGK'},
            {'id': 68,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1751.62420025851,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:4; HexNAc:4; Neu5Ac:1}'},
                                           {'name': 'Formula',
                                            'value': 'C67H109N5O48'}]}],
             'peptide_sequence': 'FQPTTSTGIAEK'},
            {'id': 43,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 1752.6446013499199,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:2; Hex:4; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C68H112N4O48'}]}],
             'peptide_sequence': 'FQPTTSTGIAEK'},
            {'id': 28,
             'modifications': [{'location': 3,
                                'monoisotopic_mass_delta': 1647.61324165199,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:5}'},
                                           {'name': 'Formula',
                                            'value': 'C64H105N5O44'}]}],
             'peptide_sequence': 'FENQTGFPPPDSR'},
            {'id': 17,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 730.26439187602,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C28H46N2O20'}]}],
             'peptide_sequence': 'VHGPPTETLPTPR'},
            {'id': 59,
             'modifications': [{'location': 6,
                                'monoisotopic_mass_delta': 1312.45522488896,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2; Neu5Ac:2}'},
                                           {'name': 'Formula',
                                            'value': 'C50H80N4O36'}]}],
             'peptide_sequence': 'VHGPPTETLPTPR'},
            {'id': 29,
             'modifications': [{'location': 4,
                                'monoisotopic_mass_delta': 730.26439187602,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:2; HexNAc:2}'},
                                           {'name': 'Formula',
                                            'value': 'C28H46N2O20'}]}],
             'peptide_sequence': 'VSLSPGPEQK'},
            {'id': 8,
             'modifications': [{'location': 1,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'TEEEVFSGMK'},
            {'id': 33,
             'modifications': [{'location': 7,
                                'monoisotopic_mass_delta': 365.13219593801,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'O-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Hex:1; HexNAc:1}'},
                                           {'name': 'Formula',
                                            'value': 'C14H23N1O10'}]}],
             'peptide_sequence': 'TEEEVFSGMK'},
            {'id': 4,
             'modifications': [{'location': 5,
                                'monoisotopic_mass_delta': 1444.53386913248,
                                'name': 'unknown modification',
                                'params': [{'name': 'GlycosylationType',
                                            'value': 'N-Glycosylation'},
                                           {'name': 'GlycanComposition',
                                            'value': '{Fuc:1; Hex:3; HexNAc:4}'},
                                           {'name': 'Formula',
                                            'value': 'C56H92N4O39'}]}],
             'peptide_sequence': 'EEQFNSTFR'}]

peptide_evidence = [{'db_sequence_id': 7,
                     'end_position': 1139,
                     'id': 41,
                     'is_decoy': False,
                     'peptide_id': 41,
                     'start_position': 1129},
                    {'db_sequence_id': 7,
                     'end_position': 1125,
                     'id': 52,
                     'is_decoy': False,
                     'peptide_id': 52,
                     'start_position': 1115},
                    {'db_sequence_id': 9,
                     'end_position': 184,
                     'id': 50,
                     'is_decoy': False,
                     'peptide_id': 50,
                     'start_position': 175},
                    {'db_sequence_id': 7,
                     'end_position': 1097,
                     'id': 48,
                     'is_decoy': False,
                     'peptide_id': 48,
                     'start_position': 1086},
                    {'db_sequence_id': 7,
                     'end_position': 764,
                     'id': 60,
                     'is_decoy': False,
                     'peptide_id': 60,
                     'start_position': 755},
                    {'db_sequence_id': 2,
                     'end_position': 1033,
                     'id': 74,
                     'is_decoy': False,
                     'peptide_id': 74,
                     'start_position': 1016},
                    {'db_sequence_id': 7,
                     'end_position': 1097,
                     'id': 37,
                     'is_decoy': False,
                     'peptide_id': 37,
                     'start_position': 1086},
                    {'db_sequence_id': 7,
                     'end_position': 638,
                     'id': 15,
                     'is_decoy': False,
                     'peptide_id': 15,
                     'start_position': 630},
                    {'db_sequence_id': 7,
                     'end_position': 1139,
                     'id': 42,
                     'is_decoy': False,
                     'peptide_id': 42,
                     'start_position': 1129},
                    {'db_sequence_id': 7,
                     'end_position': 638,
                     'id': 21,
                     'is_decoy': False,
                     'peptide_id': 21,
                     'start_position': 625},
                    {'db_sequence_id': 1,
                     'end_position': 67,
                     'id': 9,
                     'is_decoy': False,
                     'peptide_id': 9,
                     'start_position': 61},
                    {'db_sequence_id': 16,
                     'end_position': 136,
                     'id': 65,
                     'is_decoy': False,
                     'peptide_id': 65,
                     'start_position': 107},
                    {'db_sequence_id': 16,
                     'end_position': 344,
                     'id': 11,
                     'is_decoy': False,
                     'peptide_id': 11,
                     'start_position': 330},
                    {'db_sequence_id': 16,
                     'end_position': 136,
                     'id': 5,
                     'is_decoy': False,
                     'peptide_id': 5,
                     'start_position': 107},
                    {'db_sequence_id': 16,
                     'end_position': 579,
                     'id': 44,
                     'is_decoy': False,
                     'peptide_id': 44,
                     'start_position': 563},
                    {'db_sequence_id': 16,
                     'end_position': 579,
                     'id': 25,
                     'is_decoy': False,
                     'peptide_id': 25,
                     'start_position': 563},
                    {'db_sequence_id': 8,
                     'end_position': 91,
                     'id': 56,
                     'is_decoy': False,
                     'peptide_id': 56,
                     'start_position': 82},
                    {'db_sequence_id': 11,
                     'end_position': 247,
                     'id': 62,
                     'is_decoy': False,
                     'peptide_id': 62,
                     'start_position': 234},
                    {'db_sequence_id': 7,
                     'end_position': 1139,
                     'id': 30,
                     'is_decoy': False,
                     'peptide_id': 30,
                     'start_position': 1129},
                    {'db_sequence_id': 8,
                     'end_position': 231,
                     'id': 1,
                     'is_decoy': False,
                     'peptide_id': 1,
                     'start_position': 221},
                    {'db_sequence_id': 16,
                     'end_position': 136,
                     'id': 22,
                     'is_decoy': False,
                     'peptide_id': 22,
                     'start_position': 107},
                    {'db_sequence_id': 15,
                     'end_position': 180,
                     'id': 66,
                     'is_decoy': False,
                     'peptide_id': 66,
                     'start_position': 171},
                    {'db_sequence_id': 9,
                     'end_position': 184,
                     'id': 64,
                     'is_decoy': False,
                     'peptide_id': 64,
                     'start_position': 175},
                    {'db_sequence_id': 7,
                     'end_position': 1022,
                     'id': 72,
                     'is_decoy': False,
                     'peptide_id': 72,
                     'start_position': 1011},
                    {'db_sequence_id': 8,
                     'end_position': 231,
                     'id': 31,
                     'is_decoy': False,
                     'peptide_id': 31,
                     'start_position': 221},
                    {'db_sequence_id': 13,
                     'end_position': 460,
                     'id': 32,
                     'is_decoy': False,
                     'peptide_id': 32,
                     'start_position': 450},
                    {'db_sequence_id': 16,
                     'end_position': 579,
                     'id': 13,
                     'is_decoy': False,
                     'peptide_id': 13,
                     'start_position': 563},
                    {'db_sequence_id': 16,
                     'end_position': 547,
                     'id': 47,
                     'is_decoy': False,
                     'peptide_id': 47,
                     'start_position': 534},
                    {'db_sequence_id': 3,
                     'end_position': 83,
                     'id': 20,
                     'is_decoy': False,
                     'peptide_id': 20,
                     'start_position': 77},
                    {'db_sequence_id': 3,
                     'end_position': 83,
                     'id': 75,
                     'is_decoy': False,
                     'peptide_id': 75,
                     'start_position': 77},
                    {'db_sequence_id': 3,
                     'end_position': 83,
                     'id': 63,
                     'is_decoy': False,
                     'peptide_id': 63,
                     'start_position': 77},
                    {'db_sequence_id': 15,
                     'end_position': 180,
                     'id': 70,
                     'is_decoy': False,
                     'peptide_id': 70,
                     'start_position': 171},
                    {'db_sequence_id': 7,
                     'end_position': 1125,
                     'id': 16,
                     'is_decoy': False,
                     'peptide_id': 16,
                     'start_position': 1115},
                    {'db_sequence_id': 7,
                     'end_position': 1125,
                     'id': 67,
                     'is_decoy': False,
                     'peptide_id': 67,
                     'start_position': 1115},
                    {'db_sequence_id': 7,
                     'end_position': 894,
                     'id': 2,
                     'is_decoy': False,
                     'peptide_id': 2,
                     'start_position': 882},
                    {'db_sequence_id': 16,
                     'end_position': 534,
                     'id': 46,
                     'is_decoy': False,
                     'peptide_id': 46,
                     'start_position': 512},
                    {'db_sequence_id': 7,
                     'end_position': 755,
                     'id': 57,
                     'is_decoy': False,
                     'peptide_id': 57,
                     'start_position': 745},
                    {'db_sequence_id': 7,
                     'end_position': 878,
                     'id': 3,
                     'is_decoy': False,
                     'peptide_id': 3,
                     'start_position': 863},
                    {'db_sequence_id': 6,
                     'end_position': 79,
                     'id': 35,
                     'is_decoy': False,
                     'peptide_id': 35,
                     'start_position': 64},
                    {'db_sequence_id': 5,
                     'end_position': 697,
                     'id': 10,
                     'is_decoy': False,
                     'peptide_id': 10,
                     'start_position': 690},
                    {'db_sequence_id': 14,
                     'end_position': 94,
                     'id': 34,
                     'is_decoy': False,
                     'peptide_id': 34,
                     'start_position': 73},
                    {'db_sequence_id': 7,
                     'end_position': 764,
                     'id': 49,
                     'is_decoy': False,
                     'peptide_id': 49,
                     'start_position': 755},
                    {'db_sequence_id': 11,
                     'end_position': 125,
                     'id': 6,
                     'is_decoy': False,
                     'peptide_id': 6,
                     'start_position': 112},
                    {'db_sequence_id': 10,
                     'end_position': 131,
                     'id': 24,
                     'is_decoy': False,
                     'peptide_id': 24,
                     'start_position': 120},
                    {'db_sequence_id': 16,
                     'end_position': 547,
                     'id': 14,
                     'is_decoy': False,
                     'peptide_id': 14,
                     'start_position': 534},
                    {'db_sequence_id': 16,
                     'end_position': 344,
                     'id': 7,
                     'is_decoy': False,
                     'peptide_id': 7,
                     'start_position': 330},
                    {'db_sequence_id': 7,
                     'end_position': 1139,
                     'id': 53,
                     'is_decoy': False,
                     'peptide_id': 53,
                     'start_position': 1129},
                    {'db_sequence_id': 16,
                     'end_position': 534,
                     'id': 18,
                     'is_decoy': False,
                     'peptide_id': 18,
                     'start_position': 512},
                    {'db_sequence_id': 16,
                     'end_position': 547,
                     'id': 58,
                     'is_decoy': False,
                     'peptide_id': 58,
                     'start_position': 534},
                    {'db_sequence_id': 16,
                     'end_position': 563,
                     'id': 69,
                     'is_decoy': False,
                     'peptide_id': 69,
                     'start_position': 549},
                    {'db_sequence_id': 7,
                     'end_position': 1097,
                     'id': 39,
                     'is_decoy': False,
                     'peptide_id': 39,
                     'start_position': 1086},
                    {'db_sequence_id': 7,
                     'end_position': 894,
                     'id': 68,
                     'is_decoy': False,
                     'peptide_id': 68,
                     'start_position': 882},
                    {'db_sequence_id': 7,
                     'end_position': 894,
                     'id': 43,
                     'is_decoy': False,
                     'peptide_id': 43,
                     'start_position': 882},
                    {'db_sequence_id': 7,
                     'end_position': 340,
                     'id': 28,
                     'is_decoy': False,
                     'peptide_id': 28,
                     'start_position': 327},
                    {'db_sequence_id': 16,
                     'end_position': 547,
                     'id': 17,
                     'is_decoy': False,
                     'peptide_id': 17,
                     'start_position': 534},
                    {'db_sequence_id': 16,
                     'end_position': 547,
                     'id': 59,
                     'is_decoy': False,
                     'peptide_id': 59,
                     'start_position': 534},
                    {'db_sequence_id': 7,
                     'end_position': 1139,
                     'id': 29,
                     'is_decoy': False,
                     'peptide_id': 29,
                     'start_position': 1129},
                    {'db_sequence_id': 7,
                     'end_position': 725,
                     'id': 8,
                     'is_decoy': False,
                     'peptide_id': 8,
                     'start_position': 715},
                    {'db_sequence_id': 7,
                     'end_position': 725,
                     'id': 33,
                     'is_decoy': False,
                     'peptide_id': 33,
                     'start_position': 715},
                    {'db_sequence_id': 15,
                     'end_position': 180,
                     'id': 4,
                     'is_decoy': False,
                     'peptide_id': 4,
                     'start_position': 171}]

software = [{'name': 'My Generic Software',
             'uri': 'https://www.github.com/',
             'version': '1.2.0rc'}]

protocol = {'enzymes': [{'missed_cleavages': 1, 'name': 'trypsin'}],
            'fragment_tolerance': (10, None, 'parts per million'),
            'id': 1}

analysis = [[1], [1]]

source_file = {'file_format': 'data stored in database',
               'id': 1,
               'location': 'file:///C:/Users/Joshua Klein/programming/deisotope/data/Glioblastoma/o-glycopeptide-test.db'}

search_database = {'file_format': 'fasta format',
                   'id': 1,
                   'location': 'file:///C:/Users/Joshua Klein/programming/deisotope/data/Glioblastoma/proteome.fa',
                   'name': 'Uniprot Human Proteins'}

spectra_data = {'file_format': 'mzML format',
                'id': 1,
                'location': 'file:///C:/Users/Joshua Klein/programming/deisotope/data/Glioblastoma/36_UCSFslide8_3A3 with 350fmol pepmix_120min_3.5ul injection.mzML',
                'spectrum_id_format': 'multiple peak list nativeID format'}

spectrum_identification_list = {'id': 1,
                                'identification_results': [{'id': 1,
                                                            'identifications': [{'calculated_mass_to_charge': 1177.51000111519,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1177.50960128,
                                                                                 'id': 1,
                                                                                 'peptide_evidence_id': 41,
                                                                                 'peptide_id': 41,
                                                                                 'score': 19.726126436266604}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=11123'},
                                                           {'id': 3,
                                                            'identifications': [{'calculated_mass_to_charge': 1113.5045218119299,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1113.50846947,
                                                                                 'id': 3,
                                                                                 'peptide_evidence_id': 52,
                                                                                 'peptide_id': 52,
                                                                                 'score': 21.496632090544267}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13220'},
                                                           {'id': 4,
                                                            'identifications': [{'calculated_mass_to_charge': 1317.52657641673,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1317.52543615,
                                                                                 'id': 4,
                                                                                 'peptide_evidence_id': 50,
                                                                                 'peptide_id': 50,
                                                                                 'score': 10.578392281263891}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8263'},
                                                           {'id': 5,
                                                            'identifications': [{'calculated_mass_to_charge': 878.6868097667433,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 878.686830425,
                                                                                 'id': 5,
                                                                                 'peptide_evidence_id': 50,
                                                                                 'peptide_id': 50,
                                                                                 'score': 75.86400139794236}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8262'},
                                                           {'id': 6,
                                                            'identifications': [{'calculated_mass_to_charge': 878.6868097667433,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 878.686724452,
                                                                                 'id': 6,
                                                                                 'peptide_evidence_id': 50,
                                                                                 'peptide_id': 50,
                                                                                 'score': 12.389267791877792}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8392'},
                                                           {'id': 7,
                                                            'identifications': [{'calculated_mass_to_charge': 1226.56477633968,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1226.56707596,
                                                                                 'id': 7,
                                                                                 'peptide_evidence_id': 48,
                                                                                 'peptide_id': 48,
                                                                                 'score': 107.2986310372166}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15802'},
                                                           {'id': 8,
                                                            'identifications': [{'calculated_mass_to_charge': 974.928253082045,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 974.928464807,
                                                                                 'id': 8,
                                                                                 'peptide_evidence_id': 60,
                                                                                 'peptide_id': 60,
                                                                                 'score': 113.426396211721}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13902'},
                                                           {'id': 9,
                                                            'identifications': [{'calculated_mass_to_charge': 974.928253082045,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 974.927551584,
                                                                                 'id': 9,
                                                                                 'peptide_evidence_id': 60,
                                                                                 'peptide_id': 60,
                                                                                 'score': 117.47514636028542}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13771'},
                                                           {'id': 11,
                                                            'identifications': [{'calculated_mass_to_charge': 1048.8254243140432,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1048.82919759,
                                                                                 'id': 11,
                                                                                 'peptide_evidence_id': 74,
                                                                                 'peptide_id': 74,
                                                                                 'score': 35.54251142256998}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=35521'},
                                                           {'id': 12,
                                                            'identifications': [{'calculated_mass_to_charge': 1048.8254243140432,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1048.83045202,
                                                                                 'id': 12,
                                                                                 'peptide_evidence_id': 74,
                                                                                 'peptide_id': 74,
                                                                                 'score': 91.66990833250306}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=35655'},
                                                           {'id': 13,
                                                            'identifications': [{'calculated_mass_to_charge': 623.9819987110634,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 623.981950453,
                                                                                 'id': 13,
                                                                                 'peptide_evidence_id': 37,
                                                                                 'peptide_id': 37,
                                                                                 'score': 109.58555048620178}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13514'},
                                                           {'id': 14,
                                                            'identifications': [{'calculated_mass_to_charge': 935.4693598332101,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 935.471489761,
                                                                                 'id': 14,
                                                                                 'peptide_evidence_id': 37,
                                                                                 'peptide_id': 37,
                                                                                 'score': 112.8059783753705}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13662'},
                                                           {'id': 15,
                                                            'identifications': [{'calculated_mass_to_charge': 935.4693598332101,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 935.470117999,
                                                                                 'id': 15,
                                                                                 'peptide_evidence_id': 37,
                                                                                 'peptide_id': 37,
                                                                                 'score': 119.1122066423096}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13427'},
                                                           {'id': 17,
                                                            'identifications': [{'calculated_mass_to_charge': 651.32157340071,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 651.3231871,
                                                                                 'id': 17,
                                                                                 'peptide_evidence_id': 15,
                                                                                 'peptide_id': 15,
                                                                                 'score': 83.89980256933096}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=16879'},
                                                           {'id': 19,
                                                            'identifications': [{'calculated_mass_to_charge': 1032.4724934076598,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1032.46411133,
                                                                                 'id': 19,
                                                                                 'peptide_evidence_id': 42,
                                                                                 'peptide_id': 42,
                                                                                 'score': 25.40868795880988}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=10528'},
                                                           {'id': 20,
                                                            'identifications': [{'calculated_mass_to_charge': 926.7447704470898,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 926.744808066,
                                                                                 'id': 20,
                                                                                 'peptide_evidence_id': 21,
                                                                                 'peptide_id': 21,
                                                                                 'score': 28.37468920505962}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18850'},
                                                           {'id': 21,
                                                            'identifications': [{'calculated_mass_to_charge': 1149.983284837595,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1149.9823902,
                                                                                 'id': 21,
                                                                                 'peptide_evidence_id': 9,
                                                                                 'peptide_id': 9,
                                                                                 'score': 93.3668782075466}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15525'},
                                                           {'id': 22,
                                                            'identifications': [{'calculated_mass_to_charge': 1149.983284837595,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1149.98317257,
                                                                                 'id': 22,
                                                                                 'peptide_evidence_id': 9,
                                                                                 'peptide_id': 9,
                                                                                 'score': 84.91055250880152}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15659'},
                                                           {'id': 23,
                                                            'identifications': [{'calculated_mass_to_charge': 1077.019008137895,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1077.02201791,
                                                                                 'id': 23,
                                                                                 'peptide_evidence_id': 65,
                                                                                 'peptide_id': 65,
                                                                                 'score': 7.3085014918526445}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=44110'},
                                                           {'id': 24,
                                                            'identifications': [{'calculated_mass_to_charge': 1435.6895853616033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1435.6907765999997,
                                                                                 'id': 24,
                                                                                 'peptide_evidence_id': 65,
                                                                                 'peptide_id': 65,
                                                                                 'score': 0.7965816326106697}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=44116'},
                                                           {'id': 25,
                                                            'identifications': [{'calculated_mass_to_charge': 1077.019008137895,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1077.0260773,
                                                                                 'id': 25,
                                                                                 'peptide_evidence_id': 65,
                                                                                 'peptide_id': 65,
                                                                                 'score': 31.774994446541417}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=43842'},
                                                           {'id': 26,
                                                            'identifications': [{'calculated_mass_to_charge': 1077.019008137895,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1077.02476265,
                                                                                 'id': 26,
                                                                                 'peptide_evidence_id': 65,
                                                                                 'peptide_id': 65,
                                                                                 'score': 96.2557566904316}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=43982'},
                                                           {'id': 27,
                                                            'identifications': [{'calculated_mass_to_charge': 1296.5674045402532,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1296.57031913,
                                                                                 'id': 27,
                                                                                 'peptide_evidence_id': 11,
                                                                                 'peptide_id': 11,
                                                                                 'score': 47.06351600378094}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=32197'},
                                                           {'id': 28,
                                                            'identifications': [{'calculated_mass_to_charge': 1158.045419847145,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1158.04558299,
                                                                                 'id': 28,
                                                                                 'peptide_evidence_id': 5,
                                                                                 'peptide_id': 5,
                                                                                 'score': 64.5357106694511}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=43793'},
                                                           {'id': 29,
                                                            'identifications': [{'calculated_mass_to_charge': 737.67266395216,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 737.6722278869998,
                                                                                 'id': 29,
                                                                                 'peptide_evidence_id': 44,
                                                                                 'peptide_id': 44,
                                                                                 'score': 26.529096352836362}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19980'},
                                                           {'id': 30,
                                                            'identifications': [{'calculated_mass_to_charge': 1106.005357694855,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1106.00478316,
                                                                                 'id': 30,
                                                                                 'peptide_evidence_id': 44,
                                                                                 'peptide_id': 44,
                                                                                 'score': 41.213818408532056}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19931'},
                                                           {'id': 32,
                                                            'identifications': [{'calculated_mass_to_charge': 1106.005357694855,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1106.00286855,
                                                                                 'id': 32,
                                                                                 'peptide_evidence_id': 44,
                                                                                 'peptide_id': 44,
                                                                                 'score': 28.8596238496309}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=20433'},
                                                           {'id': 33,
                                                            'identifications': [{'calculated_mass_to_charge': 960.45764944162,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 960.461132325,
                                                                                 'id': 33,
                                                                                 'peptide_evidence_id': 25,
                                                                                 'peptide_id': 25,
                                                                                 'score': 34.163831842483134}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18198'},
                                                           {'id': 34,
                                                            'identifications': [{'calculated_mass_to_charge': 754.9758548852932,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 754.9768037549999,
                                                                                 'id': 34,
                                                                                 'peptide_evidence_id': 56,
                                                                                 'peptide_id': 56,
                                                                                 'score': 25.717269335215857}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=10669'},
                                                           {'id': 35,
                                                            'identifications': [{'calculated_mass_to_charge': 965.4406879055033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 965.444298158,
                                                                                 'id': 35,
                                                                                 'peptide_evidence_id': 62,
                                                                                 'peptide_id': 62,
                                                                                 'score': 155.36950334249406}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=23968'},
                                                           {'id': 36,
                                                            'identifications': [{'calculated_mass_to_charge': 1031.962292861955,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1031.96172392,
                                                                                 'id': 36,
                                                                                 'peptide_evidence_id': 30,
                                                                                 'peptide_id': 30,
                                                                                 'score': 19.553316381465656}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=11199'},
                                                           {'id': 37,
                                                            'identifications': [{'calculated_mass_to_charge': 821.0252086239666,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 821.02568428,
                                                                                 'id': 37,
                                                                                 'peptide_evidence_id': 1,
                                                                                 'peptide_id': 1,
                                                                                 'score': 20.992169792168113}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7384'},
                                                           {'id': 38,
                                                            'identifications': [{'calculated_mass_to_charge': 1117.53221399252,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1117.53695831,
                                                                                 'id': 38,
                                                                                 'peptide_evidence_id': 22,
                                                                                 'peptide_id': 22,
                                                                                 'score': 65.9318526979243}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=43766'},
                                                           {'id': 39,
                                                            'identifications': [{'calculated_mass_to_charge': 1117.53221399252,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 1117.53338641,
                                                                                 'id': 39,
                                                                                 'peptide_evidence_id': 22,
                                                                                 'peptide_id': 22,
                                                                                 'score': 76.06692434142188}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=43897'},
                                                           {'id': 40,
                                                            'identifications': [{'calculated_mass_to_charge': 1463.58448521567,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1463.58611074,
                                                                                 'id': 40,
                                                                                 'peptide_evidence_id': 66,
                                                                                 'peptide_id': 66,
                                                                                 'score': 7.594460287854466}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14399'},
                                                           {'id': 41,
                                                            'identifications': [{'calculated_mass_to_charge': 976.0587489660365,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 976.057099817,
                                                                                 'id': 41,
                                                                                 'peptide_evidence_id': 66,
                                                                                 'peptide_id': 66,
                                                                                 'score': 54.44065299308576}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14340'},
                                                           {'id': 42,
                                                            'identifications': [{'calculated_mass_to_charge': 1398.5529881259802,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1398.54983359,
                                                                                 'id': 42,
                                                                                 'peptide_evidence_id': 64,
                                                                                 'peptide_id': 64,
                                                                                 'score': 15.71884336887276}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8175'},
                                                           {'id': 45,
                                                            'identifications': [{'calculated_mass_to_charge': 932.7044175729101,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 932.704826584,
                                                                                 'id': 45,
                                                                                 'peptide_evidence_id': 64,
                                                                                 'peptide_id': 64,
                                                                                 'score': 107.92170513118073}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8160'},
                                                           {'id': 46,
                                                            'identifications': [{'calculated_mass_to_charge': 1097.980159804815,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1097.9794543,
                                                                                 'id': 46,
                                                                                 'peptide_evidence_id': 72,
                                                                                 'peptide_id': 72,
                                                                                 'score': 99.53738536954096}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22459'},
                                                           {'id': 47,
                                                            'identifications': [{'calculated_mass_to_charge': 875.0428164301334,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 875.0431600409999,
                                                                                 'id': 47,
                                                                                 'peptide_evidence_id': 31,
                                                                                 'peptide_id': 31,
                                                                                 'score': 30.581377129748695}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7322'},
                                                           {'id': 48,
                                                            'identifications': [{'calculated_mass_to_charge': 1182.999800569485,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1183.00106723,
                                                                                 'id': 48,
                                                                                 'peptide_evidence_id': 32,
                                                                                 'peptide_id': 32,
                                                                                 'score': 129.60877638341407}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=17577'},
                                                           {'id': 49,
                                                            'identifications': [{'calculated_mass_to_charge': 1182.999800569485,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1182.99695233,
                                                                                 'id': 49,
                                                                                 'peptide_evidence_id': 32,
                                                                                 'peptide_id': 32,
                                                                                 'score': 109.34661993601156}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=17721'},
                                                           {'id': 50,
                                                            'identifications': [{'calculated_mass_to_charge': 834.7044694543165,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 834.707118031,
                                                                                 'id': 50,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 46.864149814857}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22773'},
                                                           {'id': 51,
                                                            'identifications': [{'calculated_mass_to_charge': 1251.5530659480899,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1251.55382445,
                                                                                 'id': 51,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 104.16355761699366}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22394'},
                                                           {'id': 53,
                                                            'identifications': [{'calculated_mass_to_charge': 1251.5530659480899,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1251.55311601,
                                                                                 'id': 53,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 115.19705334152204}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22529'},
                                                           {'id': 54,
                                                            'identifications': [{'calculated_mass_to_charge': 834.7044694543165,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 834.7046378190001,
                                                                                 'id': 54,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 110.11721865977651}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22517'},
                                                           {'id': 55,
                                                            'identifications': [{'calculated_mass_to_charge': 1251.5530659480899,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1251.5535354,
                                                                                 'id': 55,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 110.72969880331301}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22662'},
                                                           {'id': 56,
                                                            'identifications': [{'calculated_mass_to_charge': 834.7044694543165,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 834.7026242429998,
                                                                                 'id': 56,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 101.22813287328933}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22643'},
                                                           {'id': 57,
                                                            'identifications': [{'calculated_mass_to_charge': 834.7044694543165,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 834.703744882,
                                                                                 'id': 57,
                                                                                 'peptide_evidence_id': 13,
                                                                                 'peptide_id': 13,
                                                                                 'score': 88.54444134585646}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=22387'},
                                                           {'id': 58,
                                                            'identifications': [{'calculated_mass_to_charge': 1212.057787190535,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1212.05960873,
                                                                                 'id': 58,
                                                                                 'peptide_evidence_id': 47,
                                                                                 'peptide_id': 47,
                                                                                 'score': 38.45080008869102}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18627'},
                                                           {'id': 59,
                                                            'identifications': [{'calculated_mass_to_charge': 808.3742836159466,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 808.3721436290001,
                                                                                 'id': 59,
                                                                                 'peptide_evidence_id': 47,
                                                                                 'peptide_id': 47,
                                                                                 'score': 103.74098942020812}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18498'},
                                                           {'id': 60,
                                                            'identifications': [{'calculated_mass_to_charge': 808.3742836159466,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 808.373696384,
                                                                                 'id': 60,
                                                                                 'peptide_evidence_id': 47,
                                                                                 'peptide_id': 47,
                                                                                 'score': 94.79685948532482}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18640'},
                                                           {'id': 61,
                                                            'identifications': [{'calculated_mass_to_charge': 1212.057787190535,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1212.05597623,
                                                                                 'id': 61,
                                                                                 'peptide_evidence_id': 47,
                                                                                 'peptide_id': 47,
                                                                                 'score': 38.29163317722422}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18482'},
                                                           {'id': 62,
                                                            'identifications': [{'calculated_mass_to_charge': 782.326441815073,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 782.3262329100002,
                                                                                 'id': 62,
                                                                                 'peptide_evidence_id': 20,
                                                                                 'peptide_id': 20,
                                                                                 'score': 60.536404987592505},
                                                                                {'calculated_mass_to_charge': 782.326441815073,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 782.3262329100002,
                                                                                 'id': 63,
                                                                                 'peptide_evidence_id': 75,
                                                                                 'peptide_id': 75,
                                                                                 'score': 60.536404987592505},
                                                                                {'calculated_mass_to_charge': 782.326441815073,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 782.3262329100002,
                                                                                 'id': 64,
                                                                                 'peptide_evidence_id': 63,
                                                                                 'peptide_id': 63,
                                                                                 'score': 60.536404987592505}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7353'},
                                                           {'id': 63,
                                                            'identifications': [{'calculated_mass_to_charge': 1172.9860244892247,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1172.98838901,
                                                                                 'id': 65,
                                                                                 'peptide_evidence_id': 75,
                                                                                 'peptide_id': 75,
                                                                                 'score': 3.8552017521389397}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7372'},
                                                           {'id': 68,
                                                            'identifications': [{'calculated_mass_to_charge': 1382.55807350642,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1382.55926323,
                                                                                 'id': 74,
                                                                                 'peptide_evidence_id': 70,
                                                                                 'peptide_id': 70,
                                                                                 'score': 17.684515582753658}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14398'},
                                                           {'id': 69,
                                                            'identifications': [{'calculated_mass_to_charge': 922.0411411598699,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 922.043769634,
                                                                                 'id': 75,
                                                                                 'peptide_evidence_id': 70,
                                                                                 'peptide_id': 70,
                                                                                 'score': 79.94190625395802}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14452'},
                                                           {'id': 70,
                                                            'identifications': [{'calculated_mass_to_charge': 1076.48613209616,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1076.48572395,
                                                                                 'id': 76,
                                                                                 'peptide_evidence_id': 16,
                                                                                 'peptide_id': 16,
                                                                                 'score': 21.819694176177105}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15481'},
                                                           {'id': 71,
                                                            'identifications': [{'calculated_mass_to_charge': 1076.48613209616,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1076.48896579,
                                                                                 'id': 77,
                                                                                 'peptide_evidence_id': 16,
                                                                                 'peptide_id': 16,
                                                                                 'score': 35.86525733054467}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15623'},
                                                           {'id': 72,
                                                            'identifications': [{'calculated_mass_to_charge': 930.938423842925,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 930.939953703,
                                                                                 'id': 78,
                                                                                 'peptide_evidence_id': 67,
                                                                                 'peptide_id': 67,
                                                                                 'score': 118.42162962612812}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14356'},
                                                           {'id': 74,
                                                            'identifications': [{'calculated_mass_to_charge': 930.938423842925,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 930.937993128,
                                                                                 'id': 80,
                                                                                 'peptide_evidence_id': 67,
                                                                                 'peptide_id': 67,
                                                                                 'score': 119.21792502280037}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14622'},
                                                           {'id': 75,
                                                            'identifications': [{'calculated_mass_to_charge': 1370.59445901514,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1370.59703755,
                                                                                 'id': 81,
                                                                                 'peptide_evidence_id': 2,
                                                                                 'peptide_id': 2,
                                                                                 'score': 25.990643747506233}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7930'},
                                                           {'id': 76,
                                                            'identifications': [{'calculated_mass_to_charge': 914.0653981656833,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 914.065863252,
                                                                                 'id': 82,
                                                                                 'peptide_evidence_id': 2,
                                                                                 'peptide_id': 2,
                                                                                 'score': 27.136279214151255}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8050'},
                                                           {'id': 77,
                                                            'identifications': [{'calculated_mass_to_charge': 914.0653981656833,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 914.0659286690001,
                                                                                 'id': 83,
                                                                                 'peptide_evidence_id': 2,
                                                                                 'peptide_id': 2,
                                                                                 'score': 88.35269429977623}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=7909'},
                                                           {'id': 78,
                                                            'identifications': [{'calculated_mass_to_charge': 1181.8704209482664,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1181.87309246,
                                                                                 'id': 84,
                                                                                 'peptide_evidence_id': 46,
                                                                                 'peptide_id': 46,
                                                                                 'score': 29.43493961686777}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19026'},
                                                           {'id': 79,
                                                            'identifications': [{'calculated_mass_to_charge': 1181.8704209482664,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1181.87415771,
                                                                                 'id': 85,
                                                                                 'peptide_evidence_id': 46,
                                                                                 'peptide_id': 46,
                                                                                 'score': 15.155610625936582}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19530'},
                                                           {'id': 80,
                                                            'identifications': [{'calculated_mass_to_charge': 886.6546348278924,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 886.657423524,
                                                                                 'id': 86,
                                                                                 'peptide_evidence_id': 46,
                                                                                 'peptide_id': 46,
                                                                                 'score': 27.49683353291795}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19084'},
                                                           {'id': 81,
                                                            'identifications': [{'calculated_mass_to_charge': 886.6546348278924,
                                                                                 'charge_state': 4,
                                                                                 'experimental_mass_to_charge': 886.656259574,
                                                                                 'id': 87,
                                                                                 'peptide_evidence_id': 46,
                                                                                 'peptide_id': 46,
                                                                                 'score': 29.50361926182219}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19228'},
                                                           {'id': 83,
                                                            'identifications': [{'calculated_mass_to_charge': 1181.8704209482664,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1181.87176149,
                                                                                 'id': 89,
                                                                                 'peptide_evidence_id': 46,
                                                                                 'peptide_id': 46,
                                                                                 'score': 28.72423859032948}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19166'},
                                                           {'id': 88,
                                                            'identifications': [{'calculated_mass_to_charge': 1058.4775787881,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1058.47752701,
                                                                                 'id': 94,
                                                                                 'peptide_evidence_id': 57,
                                                                                 'peptide_id': 57,
                                                                                 'score': 137.28425557984892}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=37439'},
                                                           {'id': 89,
                                                            'identifications': [{'calculated_mass_to_charge': 1010.4656714351,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1010.46801472,
                                                                                 'id': 95,
                                                                                 'peptide_evidence_id': 3,
                                                                                 'peptide_id': 3,
                                                                                 'score': 75.81582475664634}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13849'},
                                                           {'id': 90,
                                                            'identifications': [{'calculated_mass_to_charge': 673.97953977899,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 673.979905754,
                                                                                 'id': 96,
                                                                                 'peptide_evidence_id': 3,
                                                                                 'peptide_id': 3,
                                                                                 'score': 72.6160094967426}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=13823'},
                                                           {'id': 91,
                                                            'identifications': [{'calculated_mass_to_charge': 1232.1997151781832,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1232.20709183,
                                                                                 'id': 97,
                                                                                 'peptide_evidence_id': 35,
                                                                                 'peptide_id': 35,
                                                                                 'score': 11.215110723857563}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=39439'},
                                                           {'id': 92,
                                                            'identifications': [{'calculated_mass_to_charge': 1232.1997151781832,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1232.20358949,
                                                                                 'id': 98,
                                                                                 'peptide_evidence_id': 35,
                                                                                 'peptide_id': 35,
                                                                                 'score': 21.743746320739753}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=39292'},
                                                           {'id': 93,
                                                            'identifications': [{'calculated_mass_to_charge': 1009.954133476715,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1009.95376464,
                                                                                 'id': 99,
                                                                                 'peptide_evidence_id': 10,
                                                                                 'peptide_id': 10,
                                                                                 'score': 69.05278438068137}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15982'},
                                                           {'id': 94,
                                                            'identifications': [{'calculated_mass_to_charge': 1211.8834502584866,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1211.88404277,
                                                                                 'id': 100,
                                                                                 'peptide_evidence_id': 34,
                                                                                 'peptide_id': 34,
                                                                                 'score': 38.66292587774992}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=27373'},
                                                           {'id': 95,
                                                            'identifications': [{'calculated_mass_to_charge': 683.832836575575,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 683.831721285,
                                                                                 'id': 101,
                                                                                 'peptide_evidence_id': 49,
                                                                                 'peptide_id': 49,
                                                                                 'score': 27.13307177829898}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=10290'},
                                                           {'id': 96,
                                                            'identifications': [{'calculated_mass_to_charge': 1385.097168881945,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1385.09620002,
                                                                                 'id': 102,
                                                                                 'peptide_evidence_id': 6,
                                                                                 'peptide_id': 6,
                                                                                 'score': 103.1247834326469}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=20019'},
                                                           {'id': 97,
                                                            'identifications': [{'calculated_mass_to_charge': 923.7338714102199,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 923.732649438,
                                                                                 'id': 103,
                                                                                 'peptide_evidence_id': 6,
                                                                                 'peptide_id': 6,
                                                                                 'score': 102.81819115965678}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=20035'},
                                                           {'id': 98,
                                                            'identifications': [{'calculated_mass_to_charge': 1178.062203864635,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1178.06369489,
                                                                                 'id': 104,
                                                                                 'peptide_evidence_id': 24,
                                                                                 'peptide_id': 24,
                                                                                 'score': 91.51663231949075}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=28311'},
                                                           {'id': 99,
                                                            'identifications': [{'calculated_mass_to_charge': 1178.062203864635,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1178.06911301,
                                                                                 'id': 105,
                                                                                 'peptide_evidence_id': 24,
                                                                                 'peptide_id': 24,
                                                                                 'score': 31.879623715417353}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=28438'},
                                                           {'id': 100,
                                                            'identifications': [{'calculated_mass_to_charge': 930.4251492924199,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 930.420635073,
                                                                                 'id': 106,
                                                                                 'peptide_evidence_id': 14,
                                                                                 'peptide_id': 14,
                                                                                 'score': 24.6293272715002}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=16818'},
                                                           {'id': 101,
                                                            'identifications': [{'calculated_mass_to_charge': 1193.8638271344398,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1193.86856214,
                                                                                 'id': 107,
                                                                                 'peptide_evidence_id': 7,
                                                                                 'peptide_id': 7,
                                                                                 'score': 29.512961938080487}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=32498'},
                                                           {'id': 102,
                                                            'identifications': [{'calculated_mass_to_charge': 1193.8638271344398,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1193.86538243,
                                                                                 'id': 108,
                                                                                 'peptide_evidence_id': 7,
                                                                                 'peptide_id': 7,
                                                                                 'score': 32.67810975008788}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=32346'},
                                                           {'id': 103,
                                                            'identifications': [{'calculated_mass_to_charge': 1031.962292861955,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1031.96137156,
                                                                                 'id': 109,
                                                                                 'peptide_evidence_id': 53,
                                                                                 'peptide_id': 53,
                                                                                 'score': 26.864763601077843}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=10542'},
                                                           {'id': 104,
                                                            'identifications': [{'calculated_mass_to_charge': 1182.2105546454031,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1182.20507812,
                                                                                 'id': 110,
                                                                                 'peptide_evidence_id': 18,
                                                                                 'peptide_id': 18,
                                                                                 'score': 21.918613627035192}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18983'},
                                                           {'id': 105,
                                                            'identifications': [{'calculated_mass_to_charge': 905.4060891181033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 905.405324676,
                                                                                 'id': 111,
                                                                                 'peptide_evidence_id': 58,
                                                                                 'peptide_id': 58,
                                                                                 'score': 33.81925600276645}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=18421'},
                                                           {'id': 106,
                                                            'identifications': [{'calculated_mass_to_charge': 1414.63190715302,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1414.62813612,
                                                                                 'id': 112,
                                                                                 'peptide_evidence_id': 69,
                                                                                 'peptide_id': 69,
                                                                                 'score': 20.132662466781078}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=16243'},
                                                           {'id': 107,
                                                            'identifications': [{'calculated_mass_to_charge': 943.4236969242698,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 943.425048828,
                                                                                 'id': 113,
                                                                                 'peptide_evidence_id': 69,
                                                                                 'peptide_id': 69,
                                                                                 'score': 30.85411480654944}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=16184'},
                                                           {'id': 108,
                                                            'identifications': [{'calculated_mass_to_charge': 1081.0170680864449,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1081.01729115,
                                                                                 'id': 114,
                                                                                 'peptide_evidence_id': 39,
                                                                                 'peptide_id': 39,
                                                                                 'score': 110.59198949441135}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14289'},
                                                           {'id': 109,
                                                            'identifications': [{'calculated_mass_to_charge': 1081.0170680864449,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1081.01702506,
                                                                                 'id': 115,
                                                                                 'peptide_evidence_id': 39,
                                                                                 'peptide_id': 39,
                                                                                 'score': 96.2266872598215}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15234'},
                                                           {'id': 110,
                                                            'identifications': [{'calculated_mass_to_charge': 1011.09720366784,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1011.0966790899998,
                                                                                 'id': 116,
                                                                                 'peptide_evidence_id': 68,
                                                                                 'peptide_id': 68,
                                                                                 'score': 36.81298882945378}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8336'},
                                                           {'id': 111,
                                                            'identifications': [{'calculated_mass_to_charge': 1011.4373373649765,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1011.43070022,
                                                                                 'id': 117,
                                                                                 'peptide_evidence_id': 43,
                                                                                 'peptide_id': 43,
                                                                                 'score': 21.480235094403024}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=8477'},
                                                           {'id': 112,
                                                            'identifications': [{'calculated_mass_to_charge': 1047.1046925945332,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1047.10479663,
                                                                                 'id': 118,
                                                                                 'peptide_evidence_id': 28,
                                                                                 'peptide_id': 28,
                                                                                 'score': 22.99347624285318}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15487'},
                                                           {'id': 113,
                                                            'identifications': [{'calculated_mass_to_charge': 1047.1046925945332,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1047.1061699,
                                                                                 'id': 119,
                                                                                 'peptide_evidence_id': 28,
                                                                                 'peptide_id': 28,
                                                                                 'score': 31.340611055789623}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15713'},
                                                           {'id': 114,
                                                            'identifications': [{'calculated_mass_to_charge': 1047.1046925945332,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 1047.10255947,
                                                                                 'id': 120,
                                                                                 'peptide_evidence_id': 28,
                                                                                 'peptide_id': 28,
                                                                                 'score': 21.080550621677435}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15276'},
                                                           {'id': 116,
                                                            'identifications': [{'calculated_mass_to_charge': 711.34247811379,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 711.342626746,
                                                                                 'id': 122,
                                                                                 'peptide_evidence_id': 17,
                                                                                 'peptide_id': 17,
                                                                                 'score': 130.97565744585046}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15730'},
                                                           {'id': 117,
                                                            'identifications': [{'calculated_mass_to_charge': 711.34247811379,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 711.342957017,
                                                                                 'id': 123,
                                                                                 'peptide_evidence_id': 17,
                                                                                 'peptide_id': 17,
                                                                                 'score': 137.1566916976607}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15862'},
                                                           {'id': 118,
                                                            'identifications': [{'calculated_mass_to_charge': 1066.5100789373,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1066.5108839,
                                                                                 'id': 124,
                                                                                 'peptide_evidence_id': 17,
                                                                                 'peptide_id': 17,
                                                                                 'score': 111.13540878395696}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15768'},
                                                           {'id': 120,
                                                            'identifications': [{'calculated_mass_to_charge': 1066.5100789373,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1066.50837516,
                                                                                 'id': 126,
                                                                                 'peptide_evidence_id': 17,
                                                                                 'peptide_id': 17,
                                                                                 'score': 107.3302571379739}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15908'},
                                                           {'id': 121,
                                                            'identifications': [{'calculated_mass_to_charge': 711.34247811379,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 711.343167949,
                                                                                 'id': 127,
                                                                                 'peptide_evidence_id': 17,
                                                                                 'peptide_id': 17,
                                                                                 'score': 119.40240844723567}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=15986'},
                                                           {'id': 122,
                                                            'identifications': [{'calculated_mass_to_charge': 905.4060891181033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 905.407085078,
                                                                                 'id': 128,
                                                                                 'peptide_evidence_id': 59,
                                                                                 'peptide_id': 59,
                                                                                 'score': 108.12891099588458}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19373'},
                                                           {'id': 123,
                                                            'identifications': [{'calculated_mass_to_charge': 905.4060891181033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 905.4064669599999,
                                                                                 'id': 129,
                                                                                 'peptide_evidence_id': 59,
                                                                                 'peptide_id': 59,
                                                                                 'score': 106.02801354837685}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19226'},
                                                           {'id': 124,
                                                            'identifications': [{'calculated_mass_to_charge': 1357.60549544377,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1357.60745977,
                                                                                 'id': 130,
                                                                                 'peptide_evidence_id': 59,
                                                                                 'peptide_id': 59,
                                                                                 'score': 98.70020342729985}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=19369'},
                                                           {'id': 125,
                                                            'identifications': [{'calculated_mass_to_charge': 886.41458460872,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 886.414553454,
                                                                                 'id': 131,
                                                                                 'peptide_evidence_id': 29,
                                                                                 'peptide_id': 29,
                                                                                 'score': 114.92021217632795}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=9596'},
                                                           {'id': 127,
                                                            'identifications': [{'calculated_mass_to_charge': 886.41458460872,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 886.4151463,
                                                                                 'id': 133,
                                                                                 'peptide_evidence_id': 29,
                                                                                 'peptide_id': 29,
                                                                                 'score': 107.61317727215251}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=9477'},
                                                           {'id': 128,
                                                            'identifications': [{'calculated_mass_to_charge': 761.3292695826899,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 761.330359428,
                                                                                 'id': 134,
                                                                                 'peptide_evidence_id': 8,
                                                                                 'peptide_id': 8,
                                                                                 'score': 75.90620834819877},
                                                                                {'calculated_mass_to_charge': 761.3292695826899,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 761.330359428,
                                                                                 'id': 135,
                                                                                 'peptide_evidence_id': 33,
                                                                                 'peptide_id': 33,
                                                                                 'score': 75.90620834819877}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=17434'},
                                                           {'id': 130,
                                                            'identifications': [{'calculated_mass_to_charge': 1301.53166179717,
                                                                                 'charge_state': 2,
                                                                                 'experimental_mass_to_charge': 1301.53335015,
                                                                                 'id': 138,
                                                                                 'peptide_evidence_id': 4,
                                                                                 'peptide_id': 4,
                                                                                 'score': 86.23025334660201}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14612'},
                                                           {'id': 131,
                                                            'identifications': [{'calculated_mass_to_charge': 868.0235333537033,
                                                                                 'charge_state': 3,
                                                                                 'experimental_mass_to_charge': 868.024330325,
                                                                                 'id': 139,
                                                                                 'peptide_evidence_id': 4,
                                                                                 'peptide_id': 4,
                                                                                 'score': 85.19583183565784}],
                                                            'spectra_data_id': 1,
                                                            'spectrum_id': u'controllerType=0 controllerNumber=1 scan=14592'}]}
