# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PipelineCloudRuleArgs', 'PipelineCloudRule']

@pulumi.input_type
class PipelineCloudRuleArgs:
    def __init__(__self__, *,
                 nrql: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PipelineCloudRule resource.
        :param pulumi.Input[_builtins.str] nrql: The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        :param pulumi.Input[_builtins.str] account_id: The account ID where the Pipeline Cloud Rule will be created.
        :param pulumi.Input[_builtins.str] description: Additional information about the rule.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique within an account.
        """
        pulumi.set(__self__, "nrql", nrql)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Input[_builtins.str]:
        """
        The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nrql", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account ID where the Pipeline Cloud Rule will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule. This must be unique within an account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PipelineCloudRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PipelineCloudRule resources.
        :param pulumi.Input[_builtins.str] account_id: The account ID where the Pipeline Cloud Rule will be created.
        :param pulumi.Input[_builtins.str] description: Additional information about the rule.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique within an account.
        :param pulumi.Input[_builtins.str] nrql: The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nrql is not None:
            pulumi.set(__self__, "nrql", nrql)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account ID where the Pipeline Cloud Rule will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule. This must be unique within an account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nrql", value)


@pulumi.type_token("newrelic:index/pipelineCloudRule:PipelineCloudRule")
class PipelineCloudRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.PipelineCloudRule("foo",
            account_id="1000100",
            name="Test Pipeline Cloud Rule",
            description="This rule deletes all DEBUG logs from the dev environment.",
            nrql="DELETE FROM Log WHERE logLevel = 'DEBUG' AND environment = 'dev'")
        ```

        ## Import

        Pipeline Cloud Rules can be imported using the `id`. For example:

        bash

        ```sh
        $ pulumi import newrelic:index/pipelineCloudRule:PipelineCloudRule foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account ID where the Pipeline Cloud Rule will be created.
        :param pulumi.Input[_builtins.str] description: Additional information about the rule.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique within an account.
        :param pulumi.Input[_builtins.str] nrql: The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineCloudRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.PipelineCloudRule("foo",
            account_id="1000100",
            name="Test Pipeline Cloud Rule",
            description="This rule deletes all DEBUG logs from the dev environment.",
            nrql="DELETE FROM Log WHERE logLevel = 'DEBUG' AND environment = 'dev'")
        ```

        ## Import

        Pipeline Cloud Rules can be imported using the `id`. For example:

        bash

        ```sh
        $ pulumi import newrelic:index/pipelineCloudRule:PipelineCloudRule foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param PipelineCloudRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineCloudRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineCloudRuleArgs.__new__(PipelineCloudRuleArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if nrql is None and not opts.urn:
                raise TypeError("Missing required property 'nrql'")
            __props__.__dict__["nrql"] = nrql
        super(PipelineCloudRule, __self__).__init__(
            'newrelic:index/pipelineCloudRule:PipelineCloudRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nrql: Optional[pulumi.Input[_builtins.str]] = None) -> 'PipelineCloudRule':
        """
        Get an existing PipelineCloudRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account ID where the Pipeline Cloud Rule will be created.
        :param pulumi.Input[_builtins.str] description: Additional information about the rule.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique within an account.
        :param pulumi.Input[_builtins.str] nrql: The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineCloudRuleState.__new__(_PipelineCloudRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["nrql"] = nrql
        return PipelineCloudRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account ID where the Pipeline Cloud Rule will be created.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional information about the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule. This must be unique within an account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Output[_builtins.str]:
        """
        The NRQL query that defines the data to be processed by this Pipeline Cloud Rule.
        """
        return pulumi.get(self, "nrql")

