def 列表_全员除法计算(列表, 要除的数值):
    """
    将列表中的每个数字元素都除以指定的数值，并返回结果列表。

    参数:
        - 列表 (list): 包含数字的列表
        - 要除的数值 (int or float): 要除以每个数字元素的数值，不能为0

    返回:
        - 新列表 (list): 包含所有数字元素除以指定数值后的结果

    如果遇到非数字元素（如字符串）或者要除的数值为0，则返回错误信息。
    """
    try:
        if 要除的数值 == 0:
            return "处理失败: 要除的数值不能为0"

        新列表 = []

        for 元素 in 列表:
            try:
                # 检查元素是否为数字类型
                if isinstance(元素, (int, float)):
                    # 尝试将元素除以指定的数值
                    新列表.append(元素 / 要除的数值)
                else:
                    # 如果遇到非数字元素，返回错误信息
                    return "处理失败: 列表中包含非数字元素"
            except Exception as e:
                # 捕获处理元素时的异常并返回错误信息
                return f"处理失败: {e}"

        return 新列表
    except Exception as e:
        # 捕获所有异常并返回错误信息
        return f"处理失败: {e}"