def 列表_成员合并(列表, 连接符号):
    """
    将列表中的每个元素转换为字符串，并用指定的连接符号将它们连接起来。

    参数:
        - 列表 (list): 包含元素的列表
        - 连接符号 (str): 用于连接每个元素的字符串

    返回:
        - 合并后的字符串 (str): 所有元素连接而成的字符串。如果处理过程中发生异常，则返回错误信息。

    示例:
        结果 = 列表_成员合并([1, 2, 3], '-')
        print("合并后的字符串:", 结果)
    """
    try:
        # 使用连接符号连接列表中的每个元素，确保每个元素都转换为字符串
        合并后的字符串 = 连接符号.join(str(元素) for 元素 in 列表)
        return 合并后的字符串
    except Exception as e:
        # 捕获所有异常并返回错误信息
        return f"处理失败: {e}"